import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl} from '@angular/forms';
import { InboundService } from '../inbound.service'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { managesite, managesiteForm } from '../inbound.class';
import { Router } from '@angular/router';
import { Observable } from 'rxjs';

declare var $:any;

@Component({
  selector: 'app-managesites',
  templateUrl: './managesites.component.html',
  styleUrls: ['./managesites.component.css']
})

export class ManagesitesComponent extends AppComponentClass<managesite, managesiteForm> {

  label: Observable<any>;
  p: number = 1;
	// defaultSelect : any = 1;
	page = 1;
	count = 0;
	tableSize = 25;
	tableSizes = [ 25, 50, 100];
  filterTerm: string
  header: any;
  listdata: any;
   managesite: any;
  public show: boolean = false;
  public buttonName: any = "Add";
  public submitted: boolean = false;
  public managesiteForm: FormGroup;

  constructor(public data: InboundService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  // constructor(private Formbuilder: FormBuilder, private data: InboundService,) { 

  //   this.managesiteForm = this.Formbuilder.group({
      
  //     nick_name: [''],
  //     type: [''],
  //     address: [''],
  //     location: [''],
  //     country: [''],
  //     state: [''],
  //     city: [''],
  //     zip: [''],
     
  //   })
  // }

  ngOnInit(): void {

    // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new managesiteForm(res);
				this.keyfield = res.id;
				this.managesiteForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new managesiteForm(null);
				this.keyfield = -1;
				this.managesiteForm = this.cdata.makeform(this.fb);
			}
		});

    this.data.getmanagesite().subscribe((result) => {
      this.header = result[0].headers_details; 
      this.listdata = result[0].sites_details; 
      this.label = result[1];  
      console.log(result)
    });
  }

saveForm(data: any){
  console.log(data, "data");
}
  
 toggle() {
    this.show = !this.show;

    // CHANGE THE NAME OF THE BUTTON.
    if (this.show) this.buttonName = "Close";
    else this.buttonName = "Add";
  }

 // @to edit the record
 editRow(rowdata: any): void {
  this.show = true
  this.Edit(rowdata)
}

get f() { return this.managesiteForm.controls; };

// @to save/update form data
onSubmit() {
  console.log("event task save");
  this.submitted = true;

  if (this.managesiteForm.invalid) {
    return false;
  } else {
    console.log("submit data::", this.cdata);
    if (this.cdata.saveForm(this.managesiteForm)) {
      console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
      if (this.keyfield == -1) {
        this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
          console.log("Response data::\n", res);
          this.ngOnInit();
        });
      } else {
        this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
          console.log("Response data::\n", res);
          this.ngOnInit();
        });
      }
    }
  }
}

onTableSizeChange(event): void {
  this.tableSize = event.target.value;
  this.page = 1;


  } 
  
  onTableDataChange(event){
  this.page = event;
  
  } 
}
