import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { AppService } from '../shared/service/AppService.class';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class KycService extends AppService<any> {

  constructor(public http: HttpClient) {
    super(http)
  }

  @LoaderEnabled()
  getQuestions(): Observable<any> {
    this.appmod = 'getQuestion';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onkycSubmit(data: any): Observable<any> {
    this.appmod = 'addkyc';
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }


  // @LoaderEnabled()
  // getallData(): Observable<any> {
  //   this.appmod = 'getallData';
  //   let result = super.getService();
  //   this.appmod = "";
  //   return result;
  // }

  @LoaderEnabled()
  getallData(type: any): Observable<any> {
    const apiURL = environment.SERVER + 'getallData';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: type });
  }

  /*KYC verification update function*/
  @LoaderEnabled()
  kycVerify(data: any) {
    this.appmod = "kycVerification";
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  rejectKycStatus(data: any) {
    this.appmod = "rejectKycStatus";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  checkKycRoute(): Observable<any> {
    this.appmod = 'checkKycRoute';
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  CustomerProfileInformation(): Observable<any> {
    this.appmod = 'CustomerProfileInformation';
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
   cancelKycStatus(data: any) {
     this.appmod = "cancelKycStatus";
     let result = super.updateService(data);
     this.appmod = "";
     return result;
   }
   
  @LoaderEnabled()
  getkycstatus(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'getkycstatus';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }


}
