import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { NewCamapignService } from '../new-camapign.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
  selector: 'app-cnp-campaign-new',
  templateUrl: './cnp-campaign-new.component.html',
  styleUrls: ['./cnp-campaign-new.component.css']
})
export class CnpCampaignNewComponent extends AppComponentClass<any, any> {
  @ViewChild('editmodal') editmodal: ElementRef;
  @ViewChild('resellermapID') resellermapID: ElementRef;
  @ViewChild('approveID') approveID: ElementRef;
  @ViewChild('closeDCAModal') closeDCAModal: ElementRef;
  @ViewChild('requestToRejectModal') requestToRejectModal: ElementRef;
  @ViewChild('cnpcampaign1') cnpcampaign1: ElementRef;
  @ViewChild('cnpcampaign2') cnpcampaign2: ElementRef;
  campaigns: any;
  all_campaign: any = [];
  /* p: number = 1;
  page = 1;
  count = 0;
  tableSize = 25;
  tableSizes = [ 25, 50, 100]; */
  /* filterTerm: string;
  filterTerm1: string; */
  responseMessage = "";
  collection: any;
  heading: any;
  main_heading: any;
  isCampaign: boolean = false;
  errMessage: any = "";
  campaign_key: any;
  iduser: any;
  campDid: any = [];
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  public show: boolean = false;
  CNPcampaignsfilter: any = [];
  public filterCampaign: FormGroup;
  exportButton: any;
  useCase: any = [];
  messs: string = '';
  submitted: boolean = false;
  pending_review: any = [];
  shared_campaign: any = [];
  failed_campaign: any = [];
  completed_campaign: any = [];
  userType: any;
  idaccount: any;
  headingComplete: any;
  tabNm: any = "All";
  heading1: any;
  userlist: any = [];
  CNPcampaignsfilterCSV: any = [];
  customer_action_campaign: any[];
  requestEdit: FormGroup;
  failedForm: FormGroup
  campData: any = {};
  headingCNP: any;
  headingCNP2a: any;
  closeDropdownSelection = true;
  dropdownSettingsuser: IDropdownSettings = {};
  dropdownSettingsprovisioning: IDropdownSettings = {};
  dropdownSettings: IDropdownSettings = {};
  provisioningcnp: any = [];

  formreseller: FormGroup;
  selectedResellers: any[] = [];
  tabtype: boolean = true;
  approvedCampaign: any = [];
  resellercampign: any[] = [];
  selectedItems: any[] = [];
  dropdownSettings1: IDropdownSettings = {};
  disableReject: boolean = false;
  submittedd: boolean = false;
  rejectForm: FormGroup
  pending_profiles: any = [];
  smsSupplier: any = [];
  selectedData: any = [];
  dcaSubForm: FormGroup;
  selectedOption: any;
  disableDCA: boolean = false;
  parent_campaign: any = [];
  selectedRedundent: any = [];
  headingg: any;
  downloadactive: boolean = false;
  tcrStatus: any = [];
  shorting: any = [];
  dropdownSettingsshorting: IDropdownSettings = {};
  dropdownSettingstcrStatus: IDropdownSettings = {};
  sm_reference_no: string;

  constructor(public data: NewCamapignService, public userService: UsermanagementService,
    public router: Router, public fb: FormBuilder, private route: ActivatedRoute) {
    super(data, router, fb);
  }

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    this.iduser = session.iduser;
    this.idaccount = session.idaccount;

    this.exportButton = 'Download Filter Campaign';
    this.data.getcampaign().subscribe((result) => {
      this.collection = result[1]
      $.getScript('./assets/table.js');
      this.heading = result[0].headerCNP
      this.headingg = result[0].headerCNPcust
      this.heading1 = result[0].headerCNP1
      this.headingComplete = result[0].headerCNPComplete
      this.headingCNP = result[0].headerCNP2
      this.headingCNP2a = result[0].headerCNP2a
      this.main_heading = result[0].users
      this.provisioningcnp = result[2].Provisioningcnp
      this.shorting = result[2].Shorting
      this.tcrStatus = result[2].TCRStatus
    });


    this.filterCampaign = this.fb.group({
      brandId: [''],
      brand_name: [''],
      referenceId: [''],
      usecase: [''],
      campaign_key: [''],
      filter_type: [''],
      provisioning_status: [''],
      idaccount: [''],
      shorting: [''],
      tcrStatus: [''],
      sm_reference_no: ['']
    });

    this.requestEdit = this.fb.group({
      campaign_key: [''],
      iduser: [''],
      idaccount: [''],
      description: ['', Validators.required]
    });

    this.failedForm = this.fb.group({
      desc_details: ['', Validators.required],
      mailCheck: []
    })

    this.filterCampaign.patchValue({
      filter_type: this.userType == 1 ? "All" : ''
    })
    this.data.getuseCases().subscribe(res => {
      this.useCase = res.data.map((item) => ({
        name: item.name,
        displayName: item.displayName
      }))
    });
    this.userService.getidAccount().subscribe(res => {
      this.userlist = res.data.map((item) => ({
        idaccount: item.idaccount,
        userlist: `${item.san} - ${item.first_name} ${item.last_name}`
      })).sort((a, b) => { return a.san - b.san });
    });

    this.CNPcampaignlist();

    this.dropdownSettingsuser = {
      singleSelection: true,
      idField: 'idaccount',
      textField: 'userlist',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettingsprovisioning = {
      singleSelection: true,
      idField: 'value',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'name',
      textField: 'displayName',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };
    this.dropdownSettingsshorting = {
      singleSelection: true,
      idField: 'value',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };
 
    this.dropdownSettingstcrStatus = {
      singleSelection: true,
      idField: 'value',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };


    // new code started 
    this.formreseller = this.fb.group({
      resellerid: ['', Validators.required]
    });

    this.rejectForm = this.fb.group({
      desc_details: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]],
    })

    this.dcaSubForm = this.fb.group({
      serviceName: ['', [Validators.required]]
    })

    if (this.userType == 1)
      this.getreseller();

    this.dropdownSettings1 = {
      singleSelection: true,
      idField: 'camp_reseller_unique_id',
      textField: 'legal_campany_name',
      selectAllText: 'Select All',
      unSelectAllText: 'UnSelect All',
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

  }

  smCampaignID(event: Event) {
    this.sm_reference_no = (event.target as HTMLInputElement).value.toUpperCase();
  }

  setStatus(list) {
    list.forEach(element => {
      if (element.provisioning_status == 0) {
        element.provisioning_status = 'Campaign Submission Pending'
      }
      if (element.provisioning_status == 1) {
        element.provisioning_status = 'Campaign Shared'
      }
      if (element.provisioning_status == 2) {
        element.provisioning_status = 'Provisioning Pending'
      }
      if (element.provisioning_status == 3) {
        element.provisioning_status = 'Campaign Provisioned'
      }
      if (element.provisioning_status == 4) {
        element.provisioning_status = 'Provisioning Failed'
      }
      if (element.provisioning_status == 5) {
        element.provisioning_status = 'Customer Action Required'
      }
      if (element.provisioning_status == 7) {
        element.provisioning_status = 'Pending for Profile Approval'
      }
    })
  }

  CNPcampaignlist() {
    let payLoad: any = JSON.stringify({
      idaccount: this.idaccount,
      iduser: this.iduser
    })
    $('#basic-datatablesCNPCust').DataTable().clear();
    $('#basic-datatablesCNPCust').DataTable().destroy();

    $('#basic-datatablesallcnp6').DataTable().clear();
    $('#basic-datatablesallcnp6').DataTable().destroy();

    $('#basic-datatablesallcnp3').DataTable().clear();
    $('#basic-datatablesallcnp3').DataTable().destroy();

    $('#basic-datatablesallcnp4').DataTable().clear();
    $('#basic-datatablesallcnp4').DataTable().destroy();

    $('#basic-datatablesallcnp5').DataTable().clear();
    $('#basic-datatablesallcnp5').DataTable().destroy();

    $('#basic-datatablesallcnp').DataTable().clear();
    $('#basic-datatablesallcnp').DataTable().destroy();

    $('#basic-datatablesallcnp1').DataTable().clear();
    $('#basic-datatablesallcnp1').DataTable().destroy();

    $('#basic-datatablesallcnp2').DataTable().clear();
    $('#basic-datatablesallcnp2').DataTable().destroy();
    // $.getScript('./assets/table.js');
    this.data.GetCNPCampaignsList(payLoad).subscribe(result => {
      if (result.status == 200) {
        var userID = this.data.iduser;
        this.campaigns = [];
        this.all_campaign = [];
        this.pending_review = [];
        this.pending_profiles = [];
        this.shared_campaign = [];
        this.completed_campaign = [];
        this.failed_campaign = [];
        this.customer_action_campaign = [];
        if (result.data.length > 0) {
          this.campaigns = result.data;
          // console.log("gggggggggggggggggggggggg", this.campaigns);
          if (this.userType == 1) {
            this.campaigns.forEach(element => {
              if (element.provisioning_status == 0) {
                element.provisioning_status = 'Campaign Submission Pending';
                this.pending_review.push(element);
              }
              if (element.provisioning_status == 5) {
                element.provisioning_status = 'Customer Action Required';
                this.customer_action_campaign.push(element);
              }
              if (element.provisioning_status == 1 || element.provisioning_status == 2) {
                element.provisioning_status = element.provisioning_status == 2 ? 'Provisioning Pending' : 'Campaign Shared';
                this.shared_campaign.push(element);
              }
              if (element.provisioning_status == 3) {
                element.provisioning_status = 'Campaign Provisioned';
                this.completed_campaign.push(element);
              }
              if (element.provisioning_status == 4) {
                element.provisioning_status = 'Provisioning Failed';
                this.failed_campaign.push(element);
              }
              if (element.provisioning_status == 7) {
                element.provisioning_status = 'Pending for Profile Approval';
                this.pending_profiles.push(element);
              }
            });
            this.all_campaign = result.data;
            this.setStatus(this.all_campaign);

          }
          else {
            this.campaigns = result.data;
            this.setStatus(this.campaigns);
          }
          this.messs = '';
          $.getScript('./assets/table.js');
          this.isCampaign = true;
        }
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  // dcaSubmit(campaign_key,iduser,idaccount){
  // 	let payload = JSON.stringify({
  // 		campId: campaign_key,
  // 		iduser: iduser,
  // 		idaccount: idaccount,
  // 	});
  // 	this.data.dcaSubmit(payload).subscribe((res) => {
  // 		if (res.status == 200) {
  // 			this.responseMessage = res.message;
  // 			setTimeout(() => {
  //         this.CNPcampaignlist();
  // 				this.responseMessage = "";
  // 			}, 5000);
  // 		}
  // 		else {
  // 			this.errMessage = res.message;
  // 			setTimeout(() => {
  //         this.errMessage = ""
  // 			}, 5000);
  // 		}			
  // 	})
  // }

  customerAction(campaign_key, iduser, idaccount) {
    this.requestEdit.reset();
    this.requestEdit.patchValue({
      iduser: iduser,
      idaccount: idaccount,
      campaign_key: campaign_key
    });
  }

  resetRequest() {
    this.requestEdit.reset();
    this.submitted = false;
  }

  submitRequestEdit() {
    if (this.requestEdit.invalid) {
      this.submitted = true;
    }
    else {
      this.data.RequestEdit(this.requestEdit.value).subscribe((res) => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
            document.getElementById("customerActionModal").click();
            window.location.reload();
            // this.CNPcampaignlist();
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    }
  }

  campaignFailed(campaign_key, iduser, idaccount) {
    this.campData = {
      campId: campaign_key,
      iduser: iduser,
      idaccount: idaccount,
    };
  }

  saveForm() {
    if (this.failedForm.invalid) {
      this.submitted = true;
    }
    else {
      this.campData.desc_details = this.failedForm.value.desc_details;
      this.campData.mailCheck = this.failedForm.value.mailCheck;
      this.data.failedCnpFormByAdmin(this.campData).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
            document.getElementById("requestToEditForFailed").click();
            window.location.reload();
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  resetFailed() {
    this.failedForm.reset();
    this.submitted = false;
  }

  getUser(camp: any, userid: any) {
    this.campaign_key = camp
    const campaign_key = camp;
    const userID = userid;
    this.campDid = [];
    this.data.getCampaignDID(this.campaign_key, userID).subscribe((res) => {
      if (res.status == 200) {
        this.campDid = res.data;
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  /*  onDeleteCampaign(campaign_key){
     if(confirm("Are You Sure ?")){
     this.data.onDeleteCampaign(campaign_key).subscribe(res => {
       if(res.status == 201){
         this.ngOnInit();
         this.responseMessage = res.message;
         setTimeout(()=>{
           this.responseMessage= "";
         }, 5000);
       }
       else{
         this.errMessage = res.message;
         setTimeout(() => {
           this.errMessage = "";
         }, 5000);
       }
       }, err  => {
         this.errMessage = err.message;
         setTimeout(()=>{
         this.errMessage= "";
         }, 5000);
       });
     }
     else{
     return
     }
   } */

  showfilter() {
    if (this.show == false) {
      this.show = true;
    }
    else {
      this.show = false;
    }
  }

  resetFilter() {
    this.tabNm = this.tabNm;
    this.filterCampaign.reset({
      filter_type: this.tabNm
    });
    this.CNPcampaignlist();
    //this.ngOnInit();
    this.messs = '';
  }
  tabName(e) {
    this.tabNm = e;
    this.filterCampaign.reset();
    this.filterCampaign.patchValue({
      filter_type: this.userType == 1 ? e : ''
    })
  }
  onKeyPress(event: any) {
    this.messs = '';
  }

  changeUsecase(event: any) {
    this.messs = '';
  }

  // applyCamFilter() {
  //   /* if (this.filterCampaign.value.campaign_key || this.filterCampaign.value.usecase ||
  //     this.filterCampaign.value.brandId || this.filterCampaign.value.brand_name) { */
  //   this.messs = '';
  //   const payload = {
  //     brandId: this.filterCampaign.value?.brandId || '',
  //     brand_name: this.filterCampaign.value?.brand_name || '',
  //     referenceId: this.filterCampaign.value?.referenceId || '',
  //     filter_type: this.filterCampaign.value?.filter_type || '',
  //     campaign_key: this.filterCampaign.value?.campaign_key || '',
  //     idaccount: Array.isArray(this.filterCampaign.value?.idaccount) && this.filterCampaign.value.idaccount.length > 0
  //       ? this.filterCampaign.value.idaccount[0]?.idaccount : '',
  //     provisioning_status: Array.isArray(this.filterCampaign.value?.provisioning_status) && this.filterCampaign.value.provisioning_status.length > 0
  //       ? this.filterCampaign.value.provisioning_status[0]?.value : '',
  //     usecase: Array.isArray(this.filterCampaign.value?.usecase) && this.filterCampaign.value.usecase.length > 0
  //       ? this.filterCampaign.value.usecase[0]?.name : ''
  //   };



  //   this.data.applyCNPCampaignFilter(payload).subscribe(res => {
  //     if (res.status == 200) {
  //       this.CNPcampaignsfilter = res.data;
  //       this.CNPcampaignsfilterCSV = res.data;
  //       if (this.userType == 1) {
  //         if (this.tabNm == "Pending Review") {
  //           $('#basic-datatables13a').DataTable().clear();
  //           $('#basic-datatables13a').DataTable().destroy();
  //           this.pending_review = this.CNPcampaignsfilter;
  //           this.setStatus(this.pending_review);
  //         }
  //         if (this.tabNm == "Customer Action Request") {
  //           $('#basic-datatables14').DataTable().clear();
  //           $('#basic-datatables14').DataTable().destroy();
  //           this.customer_action_campaign = this.CNPcampaignsfilter;
  //           this.setStatus(this.customer_action_campaign);
  //         }
  //         if (this.tabNm == "Campaign Shared") {
  //           $('#basic-datatables13b').DataTable().clear();
  //           $('#basic-datatables13b').DataTable().destroy();
  //           this.shared_campaign = this.CNPcampaignsfilter;
  //           this.setStatus(this.shared_campaign);
  //         }
  //         if (this.tabNm == "Provisioning Failed") {
  //           $('#basic-datatables13c').DataTable().clear();
  //           $('#basic-datatables13c').DataTable().destroy();
  //           this.failed_campaign = this.CNPcampaignsfilter;
  //           this.setStatus(this.failed_campaign);
  //         }
  //         if (this.tabNm == "Campaign Provisioned") {
  //           $('#basic-datatables13d').DataTable().clear();
  //           $('#basic-datatables13d').DataTable().destroy();
  //           this.completed_campaign = this.CNPcampaignsfilter;
  //           this.setStatus(this.completed_campaign);
  //         }
  //         if (this.tabNm == "All") {
  //           $('#basic-datatables13e').DataTable().clear();
  //           $('#basic-datatables13e').DataTable().destroy();
  //           this.all_campaign = this.CNPcampaignsfilter;
  //           this.setStatus(this.all_campaign);
  //         }
  //       }
  //       else {
  //         $('#basic-datatablesCNPCust').DataTable().clear();
  //         $('#basic-datatablesCNPCust').DataTable().destroy();
  //         this.campaigns = this.CNPcampaignsfilter;
  //         this.setStatus(this.campaigns);
  //       }
  //       $.getScript('./assets/table.js');
  //     }
  //     else {
  //       this.errMessage = res.message;
  //       setTimeout(() => {
  //         this.errMessage = "";
  //       }, 5000);
  //     }
  //   })
  //   /* }
  //   else {
  //     this.messs = "Please Enter atleast 1 field!";
  //   } */
  // }

  CNPfiltersumbit() {
    this.submitted = true;
    if (this.filterCampaign.invalid) {
      return false;
    }
    else {
      if (this.filterCampaign.value.campaign_key || (this.filterCampaign.value.usecase && this.filterCampaign.value.usecase.length > 0) || this.filterCampaign.value.brandId || this.filterCampaign.value.brand_name || this.filterCampaign.value.referenceId || (this.filterCampaign.value.provisioning_status && this.filterCampaign.value.provisioning_status.length > 0) || (this.filterCampaign.value.idaccount && this.filterCampaign.value.idaccount.length > 0) || (this.filterCampaign.value.tcrStatus && this.filterCampaign.value.tcrStatus.length > 0) || this.filterCampaign.value.sm_reference_no || (this.filterCampaign.value.shorting && this.filterCampaign.value.shorting.length > 0)) {
        $('#basic-datatablesallcnp6').DataTable().clear();
        $('#basic-datatablesallcnp6').DataTable().destroy();
 
        $('#basic-datatablesallcnp3').DataTable().clear();
        $('#basic-datatablesallcnp3').DataTable().destroy();
 
        $('#basic-datatablesallcnp4').DataTable().clear();
        $('#basic-datatablesallcnp4').DataTable().destroy();
 
        $('#basic-datatablesallcnp5').DataTable().clear();
        $('#basic-datatablesallcnp5').DataTable().destroy();
 
        $('#basic-datatablesallcnp').DataTable().clear();
        $('#basic-datatablesallcnp').DataTable().destroy();
 
        $('#basic-datatablesallcnp1').DataTable().clear();
        $('#basic-datatablesallcnp1').DataTable().destroy();
 
        $('#basic-datatablesallcnp2').DataTable().clear();
        $('#basic-datatablesallcnp2').DataTable().destroy();
 
 
        const payload = {
          brandId: this.filterCampaign.value?.brandId || '',
          brand_name: this.filterCampaign.value?.brand_name || '',
          campaign_key: this.filterCampaign.value?.campaign_key || '',
          filter_type: this.filterCampaign.value?.filter_type || '',
          referenceId: this.filterCampaign.value?.referenceId || '',
          idaccount: Array.isArray(this.filterCampaign.value?.idaccount) && this.filterCampaign.value.idaccount.length > 0
            ? this.filterCampaign.value.idaccount[0]?.idaccount
            : '',
          provisioning_status: Array.isArray(this.filterCampaign.value?.provisioning_status) && this.filterCampaign.value.provisioning_status.length > 0
            ? this.filterCampaign.value.provisioning_status[0]?.value
            : '',
          usecase: Array.isArray(this.filterCampaign.value?.usecase) && this.filterCampaign.value.usecase.length > 0
            ? this.filterCampaign.value.usecase[0]?.name
            : '',
            shorting: Array.isArray(this.filterCampaign.value?.shorting) && this.filterCampaign.value.shorting.length > 0
            ? this.filterCampaign.value.shorting[0]?.value
            : '',
          tcrStatus: Array.isArray(this.filterCampaign.value?.tcrStatus) && this.filterCampaign.value.tcrStatus.length > 0
            ? this.filterCampaign.value.tcrStatus[0]?.value
            : '',
            sm_reference_no: this.filterCampaign.value?.sm_reference_no || ''
 
        };
 
        this.data.applyCNPCampaignFilter(payload).subscribe(res => {
          if (res.status == 200) {
            this.CNPcampaignsfilter = res.data;
            this.CNPcampaignsfilterCSV = res.data;
 
            if (this.userType == 1) {
              if (this.tabNm == "DCA Submission") {
                this.pending_review = this.CNPcampaignsfilter;
                this.setStatus(this.pending_review);
              }
              if (this.tabNm == "Customer Action Required") {
                this.customer_action_campaign = this.CNPcampaignsfilter;
                this.setStatus(this.customer_action_campaign);
              }
              if (this.tabNm == "DCA Shared") {
                this.shared_campaign = this.CNPcampaignsfilter;
                this.setStatus(this.shared_campaign);
              }
              if (this.tabNm == "Provisioning Failed") {
                this.failed_campaign = this.CNPcampaignsfilter;
                this.setStatus(this.failed_campaign);
              }
              if (this.tabNm == "Campaign Provisioned") {
                this.completed_campaign = this.CNPcampaignsfilter;
                this.setStatus(this.completed_campaign);
              }
              if (this.tabNm == "Pending for Profile Approval") {
                this.pending_profiles = this.CNPcampaignsfilter;
                this.setStatus(this.pending_profiles);
              }
              if (this.tabNm == "All") {
                this.all_campaign = this.CNPcampaignsfilter;
                this.setStatus(this.all_campaign);
              }
            }
            else {
              $('#basic-datatablesCNPCust').DataTable().clear();
              $('#basic-datatablesCNPCust').DataTable().destroy();
              this.campaigns = this.CNPcampaignsfilter;
              this.setStatus(this.campaigns);
            }
            $.getScript('./assets/table.js');
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        })
      }
      else {
        if (this.downloadactive) {
          this.errMessage = "";
        } else {
          this.errMessage = "Please Enter atleast 1 field!";
        }
        this.downloadactive = false;
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      }
 
    }
  }

downloadCSVFile() {
  this.downloadactive = true
  this.CNPfiltersumbit();
  setTimeout(() => {
    let dataToDownload = [];
    if (this.userType == 2 || this.userType == 201 || this.userType == 202 || this.userType == 203) {
      dataToDownload = this.campaigns;

    } else if (this.userType == 1) {
      if (this.tabNm == "All") {
        dataToDownload = this.all_campaign.map(item => {
          delete item.id_campaign;
          const { idaccount, ...rest } = item;
          return { ...rest, 'SAN': 100000000 + idaccount };
        });
      }
      else if (this.tabNm == "DCA Submission") {
        dataToDownload = this.pending_review.map(item => {
          delete item.id_campaign;
          const { idaccount, ...rest } = item;
          return { ...rest, 'SAN': 100000000 + idaccount };
        });
      }
      else if (this.tabNm == "Pending for Profile Approval") {
        dataToDownload = this.pending_profiles.map(item => {
          delete item.id_campaign;
          const { idaccount, ...rest } = item;
          return { ...rest, 'SAN': 100000000 + idaccount };
        });
      }
      else if (this.tabNm == "Customer Action Required") {
        dataToDownload = this.customer_action_campaign.map(item => {
          delete item.id_campaign;
          const { idaccount, ...rest } = item;
          return { ...rest, 'SAN': 100000000 + idaccount };
        });
      }
      else if (this.tabNm == "Provisioning Failed") {
        dataToDownload = this.failed_campaign.map(item => {
          delete item.id_campaign;
          const { idaccount, ...rest } = item;
          return { ...rest, 'SAN': 100000000 + idaccount };
        });
      }
      else if (this.tabNm == "DCA Shared") {
        dataToDownload = this.shared_campaign.map(item => {
          delete item.id_campaign;
          const { idaccount, ...rest } = item;
          return { ...rest, 'SAN': 100000000 + idaccount };
        });
      }
      else {
        dataToDownload = this.completed_campaign.map(item => {
          delete item.id_campaign;
          const { idaccount, ...rest } = item;
          return { ...rest, 'SAN': 100000000 + idaccount };
        });
      }
    }
    if (dataToDownload.length > 0) {
      let NewFilteredRes = dataToDownload.map((item) => {
        const {
           brandId, brand_name, sm_reference_no, campaign_key,
           usecase, start_date, provisioning_status,
          did_count, did_limit, camp_reseller_unique_id, idaccount,
          parent_sm_reference_no, upstreamCnpId, parent_campaign_id,
          updated_at,status, SAN
        } = item;

        const formattedDate = start_date
          ? new Date(start_date).toLocaleDateString('en-US', { year: 'numeric', month: '2-digit', day: '2-digit' }).split(/[-\/]/).join(start_date.includes('-') ? '-' : '/')
          : 'N/A';

        const formattedDate1 = updated_at
          ? new Date(updated_at).toLocaleDateString('en-US', { year: 'numeric', month: '2-digit', day: '2-digit' }).split(/[-\/]/).join(updated_at.includes('-') ? '-' : '/')
          : 'N/A';

        let record: { [key: string]: any } = {
          // 'Entity Type': entityType,
          'Brand Id': brandId,
          'Brand Name': brand_name,
          'SM Reference No': sm_reference_no,
          'Campaign Key': campaign_key,
          // 'Campaign Name': campaign_name,
          'Usecase': usecase,
          'Status': item.deleted == 1 ? 'DEACTIVATED' : 'ACTIVE',
          // 'Deleted': deleted,
          // 'Camp Reseller Unique Id': camp_reseller_unique_id,
          // 'Parent sm reference no': parent_sm_reference_no,
          // 'UpstreamCnpId': upstreamCnpId,
          // 'Parent campaign ID': parent_campaign_id,
          'Start At': formattedDate,
          'Did Limit': did_limit,
          'Did Count': did_count,
          // 'Update At': updated_at,
          'Provisioning Status': provisioning_status,
        };

        if (this.userType != 2) {
          record = {
            'SAN': SAN,
            ...record,
            // 'Camp Reseller Unique Id': camp_reseller_unique_id,
          };
        }


        return record;
      });

      const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
      const workbook: XLSX.WorkBook = { Sheets: { 'Campaign': worksheet }, SheetNames: ['Campaign'] };
      const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
      this.saveAsExcelFile(excelBuffer, "Campaign");
    } else {
      this.errMessage = "No Record Available!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  });
}

  private saveAsExcelFile(buffer: any, fileName: string): void {
  const data: Blob = new Blob([buffer], {
    type: this.EXCEL_TYPE
  });
  saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

// new code for cnp
Resetrejectform() {
  this.rejectForm.reset();
  this.submitted = false;
}

rejectPendingCNP() {
  if (this.rejectForm.invalid) {
    this.submitted = true;
  }
  else {
    this.campData.desc_details = this.rejectForm.value.desc_details;
    this.data.rejectCNPFormByAdmin(this.campData).subscribe(res => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
          this.requestToRejectModal.nativeElement.click();
          this.CNPcampaignlist();
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
}

openDCAModal(data) {
  this.selectedData = data;

  this.dcaSubForm.markAsUntouched();
  this.dcaSubForm.markAsPristine();
  this.submitted = false;

  this.data.getDCAServices().subscribe(supplier => {
    this.smsSupplier = supplier.data;
    this.smsSupplier.forEach(item => {
      if (item.sms_provider === "SYNIV") {
        item.sms_provider = "SYNIVERSE";
      }
    });
  });
}

submitDCA() {
  if (this.dcaSubForm.get('serviceName').invalid) {
    this.submitted = true;
    return
  }
  else {
    const selectedService = this.dcaSubForm.get('serviceName').value;
    let selectedData = this.smsSupplier.find(element => element.idosr_nnid == selectedService)
    if (this.selectedData && this.dcaSubForm.valid) {
      // this.dcaSubmit(this.selectedData.campaign_key, this.selectedData.iduser, this.selectedData.idaccount, selectedData);
      let payload = JSON.stringify({
        campId: this.selectedData.campaign_key,
        iduser: this.selectedData.iduser,
        idaccount: this.selectedData.idaccount,
        service: selectedData
      });
      this.data.dcaSubmit(payload).subscribe((res) => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          this.closeDCAModal.nativeElement.click();
          this.selectedData = [];
          this.dcaSubForm.get('serviceName').setValue('');
          this.submitted = false;
          setTimeout(() => {
            this.ngOnInit();
            this.responseMessage = "";
            this.disableDCA = false;
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          this.disableDCA = false;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
    this.disableDCA = true;
  }
}
resetDCA() {
  this.submitted = false;
  this.dcaSubForm.reset();
  this.dcaSubForm.get('serviceName').setValue('');
}

closeDCA() {
  this.dcaSubForm.reset();
  this.dcaSubForm.get('serviceName').setValue('');
  this.submitted = false;
  // this.selectedOption = "";
  this.smsSupplier = [];
  this.selectedData = [];
}

onItemSelect(item: any) {
  this.selectedResellers = [item];
}

mapResellerId() {
  this.submittedd = true;
  if (this.formreseller.invalid) {
    return false;
  } else {
    if (this.selectedResellers.length > 0 && this.selectedResellers[0].camp_reseller_unique_id) {
      let payLoad = {
        campId: this.approvedCampaign.campaign_key,
        iduser: this.approvedCampaign.iduser,
        idaccount: this.approvedCampaign.idaccount,
        selectedResellers: this.selectedResellers
      }
      this.data.campResellerMap(payLoad).subscribe((res) => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
            this.resellermapID.nativeElement.click();
            this.resellerReset()
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000)
        }
      })
    }
    else {
      this.errMessage = 'Please select reseller!!';
      setTimeout(() => {
        this.errMessage = "";
      }, 3000)
    }
  }
}

resellerReset() {
  this.submittedd = false;
  this.formreseller.reset();
  this.selectedResellers = [];
  this.formreseller.get('resellerid').setValue('');
}

openApproveModalForALLProComp(data) {
  this.approvedCampaign = data;
  const foundItem = this.resellercampign.find(element => element.camp_reseller_unique_id === this.approvedCampaign.camp_reseller_unique_id);
  this.selectedItems = [foundItem];
  this.selectedResellers = [foundItem];
}

openApproveModal(data) {
  this.approvedCampaign = data;
}

approveCamp() {
  let payLoad = {
    campId: this.approvedCampaign.campaign_key,
    iduser: this.approvedCampaign.iduser,
    idaccount: this.approvedCampaign.idaccount,
  }
  this.data.campApproveByAdminCNP(payLoad).subscribe((resApprove) => {
    if (resApprove.status == 200) {
      this.responseMessage = resApprove.message;
      setTimeout(() => {
        this.responseMessage = "";
        this.approveID.nativeElement.click();
        this.CNPcampaignlist();
      }, 5000);
    }
    else {
      this.errMessage = resApprove.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000)
    }
  })

}

getreseller() {
  this.data.getresellercampign().subscribe((res: any) => {
    if (res.status === 201) {
      this.resellercampign = res.data;
      const index = res.data.findIndex(item => item.camp_reseller_unique_id === 'R000000');
      if (index !== -1) {
        const [entry] = this.resellercampign.splice(index, 1);
        this.resellercampign.unshift(entry);
      }
    }
    else {
      this.errMessage = res.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  });
}





ngOnDestroy() {
  this.editmodal.nativeElement.click();
  this.cnpcampaign1.nativeElement.click();
  this.cnpcampaign2.nativeElement.click();
  this.approveID.nativeElement.click();
  this.closeDCAModal.nativeElement.click();
  this.requestToRejectModal.nativeElement.click();
}

}
