import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';

@Component({
  selector: 'app-cnp-setting-new',
  templateUrl: './cnp-setting-new.component.html',
  styleUrls: ['./cnp-setting-new.component.css']
})
export class CnpSettingNewComponent implements OnInit {
  public cspForm: FormGroup;
  public submitted: boolean = false;
  responseMessage: any;
  errMessage: any = "";
  cspId: any;
  csp: any;
  csp_id: any;
  constructor(public data: CapmaignserviceService, public fb: FormBuilder) { }

  ngOnInit(): void {
    this.cspForm = this.fb.group({
      csp_id: ['']
    });
    this.data.getCspId().subscribe((res)=>{
      this.cspId = res.data;
      this.csp_id = this.cspId[0].csp_id
      console.log("dataaa",this.csp_id)
    })
  }

  reset(){
    this.csp_id ='';
  }
  onCsp() {
    this.submitted = true;
    if (this.csp_id.invalid) {
      return false;
    }
    else {
      this.data.onAddCspId({csp_id: this.csp_id}).subscribe(response => {
        console.log("insert data",response)
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        } 
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });

    }
  }
}
