import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class NewCamapignService extends AppService<any>{

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });
  iduser: any[];
  campaignId: any;

  constructor(public http: HttpClient) {
    super(http)
  }

  getBrands(): Observable<any> {
    return this.http.get('./assets/newBrand.json');
  }

  @LoaderEnabled()
  onBrandRegister(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + 'registerbrand';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiUrl, data, { headers: httpheaders });
  }

  @LoaderEnabled()
  brandRelationship(): Observable<any> {
    this.appmod = "brandRelationship";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBranAppeal(data): Observable<any> {
    this.appmod = "getBranAppeal";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBranAppealFiles(data): Observable<any> {
    this.appmod = "getBranAppealFiles";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignCases(): Observable<any> {
    this.appmod = "campaignCasesPanel";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBrandViewFiles(data): Observable<any> {
    this.appmod = "getBrandAppealViewFiles";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  onGetNewCampaigns(brandId): Observable<any> {
    this.appmod = 'brandCampaign';
    let result = super.getService(brandId);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetCampaignsList(payLoad): Observable<any> {
    this.appmod = 'campaignsList';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetCNPCampaignsList(payLoad): Observable<any> {
    this.appmod = 'cnpCampaign';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  dcaSubmit(data?: any) {
    this.appmod = "dcaSubmit";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  rejectFormByAdmin(data?: any) {
    this.appmod = "rejectFormByAdmin";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  failedFormByAdmin(data?: any) {
    this.appmod = "failedFormByAdmin";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  RequestEdit(data?: any): Observable<any> {
    this.appmod = "RequestEdit";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  rejectCNPFormByAdmin(data?: any): Observable<any> {
    this.appmod = "rejectCNPbyadmin";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  failedCnpFormByAdmin(data): Observable<any> {
    this.appmod = "failedCnpFormByAdmin";
    let result = super.saveService(data)
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignDID(campaign_key, userID): Observable<any> {
    this.appmod = "getCampaignDID";
    let result = super.getService(campaign_key, userID);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignDIDCount(campaign_key, userID): Observable<any> {
    this.appmod = "getCampaignDIDCount";
    let result = super.getService(campaign_key, userID);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onGetCampaignsMno(): Observable<any> {
    this.appmod = 'mnoMetaDataDetails';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  mnoMetaDataForRegister(data?: any): Observable<any> {
    this.appmod = 'qualifyBrandByUsecas';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  mnoMetaDataForResubmit(data?: any): Observable<any> {
    this.appmod = 'qualifyBrandByUsecas';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBrand(): Observable<any> {
    this.appmod = 'getbrands';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBrandCnpList(): Observable<any> {
    this.appmod = 'getBrandCnpList';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  brandVertical(): Observable<any> {
    this.appmod = "brandVertical";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBrandsDetail(id): Observable<any> {
    this.appmod = 'brand';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignsDetail(id): Observable<any> {
    this.appmod = 'campaignDetails';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  getCampaignsDetailId(id): Observable<any> {
    this.appmod = 'getCampaignsDetailId';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getConntPratners(): Observable<any> {
    this.appmod = "connPartnersDetails";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getResellerDetailss(): Observable<any> {
    this.appmod = "getResellerDetails";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBrandVetting(payLoad): Observable<any> {
    this.appmod = 'getBrandsVettingList';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getVettingClass(payLoad): Observable<any> {
    this.appmod = 'getVettingClass';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  getVettingPartner(payLoad): Observable<any> {
    this.appmod = 'getVettingPartner';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }

  //@LoaderEnabled()
  updateVetting(data?: any): Observable<any> {
    this.appmod = "updateVettingForStatus";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  brandVettingClass(): Observable<any> {
    this.appmod = "vettingClass";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  brandVettingProvider(): Observable<any> {
    this.appmod = "extVettingProvider";
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  applyNewVetting(data: any): Observable<any> {
    let apiURL = environment.SERVER + "applyVetting";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
    // this.appmod = 'addcampaign';
    // let result = super.saveService(data);
    // this.appmod = "";
    // return result;
  }
  @LoaderEnabled()
  importVetting(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + 'importVetting';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiUrl, data, { headers: httpheaders });
  }

  @LoaderEnabled()
  onNewRegisterCampaign(data: any): Observable<any> {
    let apiURL = environment.SERVER + "registercampaign";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });

  }

  getcampaign(): Observable<any> {
    return this.http.get('./assets/newCampaign.json');
  }

  getlegalOrg(): Observable<any> {
    return this.http.get('./assets/newBrand.json');
  }
  Duns_giinData(): Observable<any> {
    return this.http.get('./assets/newBrand.json');
  }

  US_State(): Observable<any> {
    return this.http.get('./assets/newBrand.json');
  }

  CA_State(): Observable<any> {
    return this.http.get('./assets/newBrand.json');
  }

  @LoaderEnabled()
  stock_Exchange(): Observable<any> {
    this.appmod = "stockExchange";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  altBusinessIdType(): Observable<any> {
    this.appmod = "altBusinessIdType";
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  editBrand(data?: any) {
    this.appmod = "updateBrand";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaign(data?: any): Observable<any> {
    this.appmod = "brandCampaign";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  DeleteNewBrand(data: any): Observable<any> {
    this.appmod = 'deleteBrand';
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
  }

    @LoaderEnabled()
    DeleteNewCampaign(data: any): Observable<any> {
      let apiUrl = environment.SERVER + 'deletecampaign';
      let httpHeaders = new HttpHeaders({
        "Content-Type": "application/json"
      });
      return this.http.delete(apiUrl, { headers: httpHeaders, params: { data: data } });
    }
 

  @LoaderEnabled()
  getBrandIdentityStatus(): Observable<any> {
    this.appmod = "brandIdentityStatus";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBrandEntityType(): Observable<any> {
    this.appmod = "brandEntity";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyFilter(data?: any): Observable<any> {
    this.appmod = "brandFilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyCnpFilter(data?: any): Observable<any> {
    this.appmod = "cnpBrandFilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyCampaignFilter(data?: any): Observable<any> {
    this.appmod = "campaignFilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyCNPCampaignFilter(data?: any): Observable<any> {
    this.appmod = "CNPcampaignFilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getuseCases(): Observable<any> {
    this.appmod = "campaignCasesPanel";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  campaignFilter(data?: any): Observable<any> {
    this.appmod = "campaignFilterForBrand";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateCampaignsDetail(data?: any) {
    this.appmod = "updateCampaign";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  finalUpdateForCampaign(data?: any) {
    this.appmod = "finalUpdateForCampaign";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getAddress(): Observable<any> {
    this.appmod = "company";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignMnoDetails(camId?: any): Observable<any> {
    this.appmod = 'mnoMetaDataDetails';
    let result = super.getService(camId);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  campMnoMetaDataDetails(camId?: any): Observable<any> {
    this.appmod = 'campMnoMetaDataDetails';
    let result = super.getService(camId);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignEvents(data?: any): Observable<any> {
    this.appmod = 'getCampaignEvents';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  resubmitBrand(brandId?: any): Observable<any> {
    this.appmod = "updateBrandIdentity";
    let result = super.updateService(brandId);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  brandQualifyByAllUseCases(data?: any): Observable<any> {
    this.appmod = 'brandQualifyByAllUseCases';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  checkNonProfitBrand(data?: any): Observable<any> {
    this.appmod = 'checkNonProfitBrand';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }
  
  getlocaldata(): Observable<any> {
    return this.http.get('./assets/newBrand.json');
  }
  getpinPreference(): Observable<any> {
    return this.http.get('./assets/newBrand.json');
  }

  getfecCommitteeTypeCode(): Observable<any> {
    return this.http.get('./assets/newBrand.json');
  }

  @LoaderEnabled()
  createCampaignFile(data?: any): Observable<any> {
    this.appmod = "createCampaignFile";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBrandFeedback(brandId?: any): Observable<any> {
    this.appmod = 'getBrandFeedback';
    let result = super.getService(brandId);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  resubmitCampaign(data?: any) {
    this.appmod = "resubmitCampaign";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  appealVettingRequest(data: any, file: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("data", JSON.stringify(data));
    formData.append("ATTACHMENTS", file);
    const apiURL = environment.SERVER + 'appealVettingRequest';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  getVettingAppealDetails(data): Observable<any> {
    this.appmod = 'getVettingAppealDetails';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  getCampaignsFileById(id): Observable<any> {
    this.appmod = 'getCampaignsFileById';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  deleteCampFile(data: any): Observable<any> {
    this.appmod = 'campaignMultimediaFileDelete';
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  deleteAddCampFile(data: any): Observable<any> {
    this.appmod = 'deleteAddCampFile';
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  campApproveByAdmin(data: any): Observable<any> {
    let apiURL = environment.SERVER + "campApproveByAdmin";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
  }
  @LoaderEnabled()
  campApproveByAdminCNP(data: any): Observable<any> {
    let apiURL = environment.SERVER + "CNPcampApproveByAdmin";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
  }

  @LoaderEnabled()
  campResellerMap(data?: any) {
    this.appmod = "campaResellerMap";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  
  @LoaderEnabled()
  getDCAServices(): Observable<any> {
    this.appmod = "getDCAServices";
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  getNewCampDetailById(id): Observable<any> {
    this.appmod = 'getnewCampDetailById';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  getNewCampaignsFileById(id): Observable<any> {
    this.appmod = 'getNewCampaignsFileById';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  redundantBrandRegister(data?: any) {
    this.appmod = "redundantregisterbrand";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  deleteSamFile(data: any): Observable<any> {
    this.appmod = 'campaignSamMultimediaFileDelete';
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  applyRedCampaignFilter(data?: any): Observable<any> {
    this.appmod = "redcampaignFilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  resend2FAEmail(data?: any) : Observable<any>{
    this.appmod = "2faEmail";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  getresellercampign(): Observable<any> {
    this.appmod = "campaignResellerget";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  singleReseller(data:any): Observable<any> {
    this.appmod = "campaignsingleResellerget";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  resellerdataupdate(data?: any) {
    this.appmod = "campaignResellerupdate";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  resellerdata(data?: any) {
    this.appmod = "campaignResellerpost";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  deletereseller(data: any): Observable<any> {
    this.appmod = 'campaignResellerdelete';
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCountry(): Observable<any> {
    this.appmod = "getcountrybrand";
    let tmp = this.getService();
    this.appmod = "";
    return tmp;
  }

  @LoaderEnabled()
  Updatetaxdata(media: any, file: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("UPLOAD", file);
    formData.append("data", JSON.stringify(media));
    const apiURL = environment.SERVER + 'updatetax';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  smsEnablePendingDID(data?:any): Observable<any> {
    this.appmod = "smsEnablePendingDID";
    let tmp = this.getService(data);
    this.appmod = "";
    return tmp;
  }
  
  @LoaderEnabled()
  smsEnablePendinglog(data?:any): Observable<any> {
    this.appmod = "smsEnablePendinglog";
    let tmp = this.getService(data);
    this.appmod = "";
    return tmp;
  }

  @LoaderEnabled()
  smsEnablePendingremove(data?:any): Observable<any> {
    this.appmod = "smsEnablePendingremove";
    let tmp = this.saveService(data);
    this.appmod = "";
    return tmp;
  }
  
}
