import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { saveAs } from 'file-saver';
import * as XLSX from 'xlsx';
import { NewCamapignService } from '../new-camapign.service';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { InboundService } from 'src/app/inbound/inbound.service';
declare var $: any;

@Component({
  selector: 'app-pending-sms-enable',
  templateUrl: './pending-sms-enable.component.html',
  styleUrls: ['./pending-sms-enable.component.css']
})
export class PendingSmsEnableComponent implements OnInit {
  @ViewChild('dataModal') dataModal: ElementRef;
  public filterUser: FormGroup;
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  show_filter: boolean = false;
  responseMessage: any;
  errMessage: any;
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  submitted: boolean = false;
  pendingsms: any[];
  Didlog: any[];
  name_with_san: any = [];
  users: any[]
  userss: any = []
  selectedItem: any = [];
  DID: any;
  userType: any;
  isAdmin: boolean = false;


  constructor(public fb: FormBuilder, public data: NewCamapignService, private userService: UsermanagementService, public smsdata: InboundService) { }

  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    let user = JSON.parse(isLoggedIn);
    this.userType = user.type;
    if (user.type == '1') {
      this.isAdmin = true;
    }
    else {
      this.isAdmin = false;
    }

    this.userService.getidAccount().subscribe(res => {
      if (res.status == 200) {
        this.users = res.data;
        this.users.sort((a, b) => {
          return a.idaccount - b.idaccount;
        });
        const uniqueUsers = this.users.filter((value, index, self) =>
          index === self.findIndex((t) => t.iduser === value.iduser)
        );
        uniqueUsers.forEach(element => {
          const fullName = `${element.first_name} ${element.last_name}`;
          this.name_with_san.push({
            name: element.idaccount + ' - ' + element.iduser,
            Name_san: element.san + ' - ' + fullName
          });
        });

        this.userss = this.name_with_san;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

    this.filterUser = this.fb.group({
      // from_date: [''],
      // to_date: [''],
      npa: [''],
      nxx: [''],
      number: [''],
      // campaignId:[''],
      // brandId:[''],
      // brandName:[''],
      san: ['']
    })

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'name',
      textField: 'Name_san',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    this.PendingSMSData()
  }

  PendingSMSData() {
    this.filterUser.value.san = this.selectedItem?.[0]?.name?.split(' - ')[0] ?? '';
    this.data.smsEnablePendingDID(JSON.stringify(this.filterUser.value)).subscribe((res) => {
      if (res.status == 201) {
        this.pendingsms = res.data
        $('#basic-datatables11').DataTable().clear();
        $('#basic-datatables11').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }
  }

  // messageshow() {
  //   const from_date = this.filterUser.get('from_date').value;
  //   const to_date = this.filterUser.get('to_date').value;
  //   const currentDate = new Date();
  //   this.filterUser.get('from_date').setErrors(null);
  //   this.filterUser.get('to_date').setErrors(null);

  //   if (!to_date && !from_date) {
  //     return;
  //   }
  //   if (to_date) {
  //     if (new Date(to_date) > currentDate) {
  //       this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
  //       return;
  //     }
  //   }
  //   if (from_date) {
  //     if (new Date(from_date) > currentDate) {
  //       this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
  //       return;
  //     }
  //   }
  //   if (!from_date && to_date) {
  //     this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please Select From Date' });
  //     return;
  //   }
  //   if (from_date && !to_date) {
  //     this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please Select To Date' });
  //     return;
  //   }
  //   if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
  //     this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
  //     return;
  //   }
  // }


  onSubmit() {
    this.submitted = false;
    if (this.filterUser.invalid) {
      return;
    } else {
      this.filterUser.value.san = this.selectedItem?.[0]?.name?.split(' - ')[0] ?? '';
      this.data.smsEnablePendingDID(JSON.stringify(this.filterUser.value)).subscribe((res) => {
        if (res.status == 201) {
          this.pendingsms = res.data;
          $('#basic-datatables11').DataTable().clear();
          $('#basic-datatables11').DataTable().destroy();
          $.getScript('./assets/tollfree.js');
          if (res.data.length > 0) {
            this.responseMessage = res.message
          } else {
            this.responseMessage = ""
          }
          setTimeout(() => {
            this.responseMessage = ""
          }, 5000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      })
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterUser.reset()
    this.selectedItem = []
    this.PendingSMSData()
  }


  downloadCSV() {
    setTimeout(() => {
      this.filterUser.value.san = this.selectedItem?.[0]?.name?.split(' - ')[0] ?? '';
      this.data.smsEnablePendingDID(JSON.stringify(this.filterUser.value)).subscribe((res) => {
        if (res.status == 201) {
          let SIPdata = res.data
          if (SIPdata.length > 0) {
            let NewFilteredRes = SIPdata.map((item) => {
              const { san, did, camp_registry, idbrand, brand_name, usecase, osr_status, created_at } = item;
              const formattedDate = created_at ? new Date(created_at).toLocaleDateString('en-US', { year: 'numeric', month: '2-digit', day: '2-digit' }).split(/[-\/]/).join(created_at.includes('-') ? '-' : '/') : 'N/A';
              return {
                "SAN": san,
                "Number": did,
                "Campaign ID": camp_registry,
                "Brand ID": idbrand,
                "Brand Name": brand_name,
                "Use Case": usecase,
                "OSR Status": osr_status,
                'Created At': formattedDate
              };
            });
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
            const workbook: XLSX.WorkBook = { Sheets: { 'Pending SMS Enable': worksheet }, SheetNames: ['Pending SMS Enable'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
            this.saveAsExcelFile(excelBuffer, 'Pending SMS Enable');
          } else {
            this.errMessage = 'No Record Available'
            setTimeout(() => {
              this.errMessage = '';
            }, 5000);
          }
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    }, 1000);
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }


  pendingSmsLog(account_id, did) {
    this.DID = '';
    $('#basic-datatables3').DataTable().destroy();
    this.Didlog = [];
    this.DID = did;
    let payload: any = JSON.stringify({
      account_id: account_id,
      did: did
    });
    this.data.smsEnablePendinglog(payload).subscribe((res) => {
      if (res.status == 201) {
        this.Didlog = res.data
        // .map((item: any) => {
        //   try {
        //     const parsedLog = JSON.parse(item.full_log);
        //     return {
        //       ...item,
        //       parsed_full_log: parsedLog.status
        //     };
        //   } catch (e) {
        //     return {
        //       ...item,
        //       parsed_full_log: item.full_log
        //     };
        //   }
        // });
        $('#basic-datatables3').DataTable().clear();
        $('#basic-datatables3').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);

      }

    });

  }



  Pendingremovesms(item) {
    if (confirm("Are you sure you want remove this did!")) {
      this.smsdata.disableSMSAdmin(item.did, item.iduser, item.account_id).subscribe(disres => {
        if (disres.status == 200 || disres.status == 201 || disres.status == 202) {
          this.PendingSMSData()
          this.responseMessage = disres.message
          setTimeout(() => {
            this.responseMessage = ""
          }, 5000);
        }
        else {
          this.errMessage = disres.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    } else {
      "Cancel!"
    }
  }


  SMSReEnablement(item) {
    if (this.isAdmin) {
      this.enableDIDSMS(item);
    }
    else {
      console.log("No API Called For Customer!!");
    }
  }

  enableDIDSMS(item) {
    let updateDID: any = {};
    updateDID = {
      iddid: item.iddid, DID: item.did, CampaignId: item.camp_registry, iduser: item.iduser, idaccount: item.account_id, sinchStatus: item.sinch_status
    };
    if (item.camp_registry !== '') {
      if (confirm("This DID will be Disable from previous campaign after that it will be Enable with new campaign!!")) {
        if (confirm("Are you sure you want to Disable SMS service from old Campaign and Enable with New Campaign!!")) {
          console.log("enable did=>");
          this.smsdata.disableSMSAdmin(item.did, item.iduser, item.account_id).subscribe(disres => {
            if (disres.status == 200 || disres.status == 201 || disres.status == 202) {
              this.enableSMS(updateDID);
            }
            else {
              this.errMessage = disres.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          })
        }
      }
    }
    else {
      if (confirm("Are you sure you want to Enable SMS service from this Campaign!!")) {
        this.enableSMS(updateDID);
      }
    }
  }

  enableSMS(updateDID) {
    this.smsdata.enableSMSAdmin(updateDID).subscribe(res => {
      if (res.status == 200) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, error => {
      this.errMessage = "Something went wrong with SMS Re-enable!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }
  toggleDescription(item, property) {
    item[property] = !item[property];
  }
  ngOnDestroy() {
    this.dataModal.nativeElement.click();
  }
}