import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { NewCamapignService } from '../new-camapign.service';
declare var $: any;

@Component({
  selector: 'app-taxdetails',
  templateUrl: './taxdetails.component.html',
  styleUrls: ['./taxdetails.component.css']
})
export class TaxdetailsComponent implements OnInit {
  public taxdetails: FormGroup;
  public submitted: boolean = false
	dropdownSetting: IDropdownSettings = {};
	closeDropdownSelection = true;
  selectedItem: any = [];
  tax: any=[];
  errMessage: any;
  responseMessage: any;
  Taxs: any=[];
  file: File;
  files: any;
  fileErr: string;
  isEdit: boolean = false;
  uploadedFileUrl: string = '';
  brand_tax_docc:string='';
  isFileUploaded = false;
  isUpdated = false;

 
 
  constructor(public data: NewCamapignService, public fb: FormBuilder) { }

  ngOnInit(): void {
    $('#basic-datatables').DataTable().clear();
    $('#basic-datatables').DataTable().destroy();
    $('#basic-datatables').dataTable().fnDestroy();
    $.getScript('./assets/tollfree.js');


		this.dropdownSetting = {
			singleSelection: true,
			idField: 'country_id',
			textField: 'name',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: false
		};
    this.taxdetails = this.fb.group({
      country: ['',Validators.required],
      code: ['', Validators.required],
      uploadfile: ['',Validators.required]
    })

   this.taxData()
  }

  taxData(){
    this.data.getCountry().subscribe((res)=>{
      if(res.status == 200){
        this.tax = res.data.map(item => ({
          ...item,
         code: item.code == null || item.code === '' ? 0 : item.code
        }));
        this.Taxs = this.tax.slice().reverse();
        $('#basic-datatables').DataTable().clear();
        $('#basic-datatables').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
      }else{
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  SetValue(){
    if (this.selectedItem.length !== 0) {
      let country_id = this.selectedItem[0].country_id;
      let matched = this.tax.find(item => item.country_id === country_id);
      if (matched) {
        let code = matched.code
        let brand_tax_doc=matched.brand_tax_doc
        this.taxdetails.patchValue({
          code : code,
        })
        this.brand_tax_docc = brand_tax_doc; 
        this.isUpdated=false
      } else {
        this.taxdetails.patchValue({
          code :0,
        })  
        this.brand_tax_docc = '';     
      }
    }
  }
  
  


  editTax(name:any,country_id:any, code:any,brand_tax_doc:any){

    this.isEdit = true;
    this.isUpdated=false;
    this.selectedItem = []
    this.selectedItem = [{ name: name, country_id: country_id,brand_tax_doc}];
    this.brand_tax_docc=brand_tax_doc;
    this.taxdetails.patchValue({
      code:code,
      // brand_tax_docc:brand_tax_doc
      
    })
    
  }

  getFileName(url: string): string {
    return url ? url.substring(url.lastIndexOf('/') + 1) : '';
  }
  

  updatetax() {
    this.submitted = true;
    this.isUpdated = true;

    if (this.taxdetails.invalid) {
        return false;
    }

    this.taxdetails.value.country = this.selectedItem[0].name;
    this.taxdetails.value.country_id = this.selectedItem[0].country_id;
    this.data.Updatetaxdata(this.taxdetails.value, this.file).subscribe((res) => {
        if (res.status === 201) {
            this.file=null
            this.Resettax();
            this.taxData();
            this.responseMessage = res.message;
            setTimeout(() => {
                this.responseMessage = "";
            }, 5000);
        } else {
            this.errMessage = res.message;
            setTimeout(() => {
                this.errMessage = "";
            }, 5000);
        }
    });
}



  onFilePicked(event: Event) {
    const fileInput = event.target as HTMLInputElement;
    const file: File = fileInput.files[0];
    if (!file) {
      this.errMessage = "No file selected!";
      setTimeout(() => this.errMessage = "", 5000);
      return;
    }
    const allowedTypes = ['image/jpeg', 'image/jpg', 'image/gif', 'image/png', 'application/pdf'];
    if (!allowedTypes.includes(file.type)) {
      this.errMessage = "Invalid file type !";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
      fileInput.value = '';
      return;
    }
    this.file = file;
    const reader = new FileReader();
    reader.onload = () => {
      const fileData = reader.result;
    };
    reader.onerror = () => {
      this.errMessage = "Error reading file!";
      setTimeout(() => this.errMessage = "", 5000);
    };
    reader.readAsDataURL(file);
  
    this.fileErr = '';
  }



  Resettax(){
    this.submitted = false
    this.taxdetails.reset()
    this.selectedItem = []
    this.isEdit = false; 
    this.brand_tax_docc = null;
    this.fileErr = ''
    $('#upload').val("");
  }

}
