import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { SystemNotificationComponent } from './system-notification/system-notification.component';
import { EmailSubscriptionSettingComponent } from './email-subscription-setting/email-subscription-setting.component';
import { NotificationEmailComponent } from './notification-email/notification-email.component';
import { ComposemailComponent } from './composemail/composemail.component';
import { EmailNotificationComponent } from './email-notification/email-notification.component';



const routes: Routes = [
    {
        path: '',
        children: [
            {
                path: 'system-notification',
                component: SystemNotificationComponent,
                data: {
                    title: 'Notification',
                    urls: [
                        {
                            title: 'Notification',
                        },
                        {
                            title: ' System Notification'
                        }
                    ]
                }
            },
            {
                path: 'email-notification',
                component: EmailNotificationComponent,
                data: {
                    title: 'Notification',
                    urls: [
                        {
                            title: 'Notification',
                        },
                        {
                            title: 'Email Notification'
                        }
                    ]
                }
            },
            {
                path: 'composemail',
                component: ComposemailComponent,
                data: {
                    title: 'Notification',
                    urls: [
                        {
                            title: 'Notification',
                        },
                        {
                            title: ' Compose Email'
                        }
                    ]
                }
            },
            {
                path: 'notification',
                component: NotificationEmailComponent,
                data: {
                    title: 'Notification',
                    urls: [
                        {
                            title: 'Notification',
                        },
                        {
                            title: 'Notification'
                        }
                    ]
                }
            },
            {
                path: 'notification/:key/:to/:view_status',
                component: NotificationEmailComponent,
                data: {
                    title: 'Notification',
                    urls: [
                        {
                            title: 'Notification',
                        },
                        {
                            title: 'Notification'
                        }
                    ]
                }
            },
            {
                path: 'notification/:key/:to/:view_status/:view_status',
                component: NotificationEmailComponent,
                data: {
                    title: 'Notification',
                    urls: [
                        {
                            title: 'Notification',
                        },
                        {
                            title: 'Notification'
                        }
                    ]
                }
            },
            {
                path: 'notification/:key',
                component: NotificationEmailComponent,
                data: {
                    title: 'Notification',
                    urls: [
                        {
                            title: 'Notification',
                        },
                        {
                            title: 'Notification'
                        }
                    ]
                }
            },
            {
                path: 'email-notification-setting',
                component: EmailSubscriptionSettingComponent,
                data: {
                    title: 'Notification',
                    urls: [
                        {
                            title: 'Notification',
                        },
                        {
                            title: 'Email Notification Settings'
                        }
                    ]
                }
            }
        ]
    }

];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class NotificationRoutingModule { }
