import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { OutboundService } from '../outbound.service';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { cdrs, callForm } from '../outbound.class';
import { Router } from '@angular/router';
import { Observable } from 'rxjs';

declare var $: any;

@Component({
	selector: 'app-calldetailsrecord',
	templateUrl: './calldetailsrecord.component.html',
	styleUrls: ['./calldetailsrecord.component.css']
})

export class CalldetailsrecordComponent extends AppComponentClass<cdrs, callForm>{
	editData?: Observable<any>;
	searchText = { count: 0 };
	filtre: string;
	label: Observable<any>;
	header: any;
	rowdata: any;
	p: number = 1;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	filterTerm: string
	snackBar : any ;
	public cdrForm: FormGroup;
	public submitted: boolean = false;
	filterCdr: any = [];


	constructor(public data: OutboundService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

	ngOnInit(): void {
		this.cdrForm = this.fb.group({
			to_date: ['', Validators.required],
			from_date: ['', Validators.required],
			from_number: [''],
			to_number: [''],
			direction: ['outbound']
		})

		this.data.getCdr().subscribe((result) => {
			this.label = result[1];
			this.header = result[0].headers_details;
			this.rowdata = result[0].product_details;
		});
	}

	onCdrFilter() {
		this.submitted = true;
		if(this.cdrForm.invalid){
			return false;
		}

		else{
			this.filterCdr = [];
			this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
				if(response.data){
					this.filterCdr = response.data;
				}
			});
		}
	}


	onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
	}

	onTableDataChange(event) {
		this.page = event;
	}
}