import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { RoutingprofileComponent } from './routingprofile/routingprofile.component';
import { CalldetailsrecordComponent } from './calldetailsrecord/calldetailsrecord.component';
import { TestcallComponent } from './testcall/testcall.component';
import { MediaUploadFilesComponent } from './media-upload-files/media-upload-files.component';
import { TestCallByMediaComponent } from './test-call-by-media/test-call-by-media.component';
const routes: Routes = [
  {
    path: '',
    children: [
        {
            path: '',
            component: RoutingprofileComponent,
            data: {
                title: 'Dashboard',
                urls: [
                    {
                        title: 'Dashboard',
                        url: '/dashboards/dashboard'
                    },
                    {
                        title: 'Dashboard'
                    }
                ]
            }
        },
        {
          path: 'test-call',
          component: TestcallComponent,
          data: {
              title: 'Outbound',
              urls: [
                  {
                      title: 'Outbound',
                    //   url: '/outbound/test-call'
                  },
                  {
                      title: 'Test Call'
                  }
              ]
          }
      },

      {
        path: 'routing-profiles',
        component: RoutingprofileComponent,
        data: {
            title: 'Outbound',
            urls: [
                {
                    title: 'Outbound',
                    // url: '/outbound/routing-profile'
                },
                {
                    title: 'Routing Profile'
                }
            ]
        }
    },


    {
      path: 'call-details-record',
      component: CalldetailsrecordComponent,
      data: {
          title: 'Outbound',
          urls: [
              {
                  title: 'Outbound',
                //   url: '/outbound/call-details-record'
              },
              {
                  title: 'CDR'
              }
          ]
      }
  },

  {
    path: 'media-upload-files',
    component: MediaUploadFilesComponent,
    data: {
        title: 'Media Upload File',
        urls: [
            {
                title: 'Outbound',
                //   url: '/outbound/media-upload-files'
              
            },
            {
                title: 'Media Upload File'
            }
        ]
    }
},

{
    path: 'test-call-by-media',
    component: TestCallByMediaComponent,
    data: {
        title: 'Test Call Via Media',
        urls: [
            {
                title: 'Outbound',
                //   url: '/outbound/test-call-by-media'
              
            },
            {
                title: 'Test Call Via Media'
            }
        ]
    }
},



    ]
}
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class OutboundRoutingModule { }
