import { FormBuilder, FormGroup, Validators } from "@angular/forms";

// profile : userprofile 
export interface profile
{
    first_name:string,
    last_name:string,
    email:string,
    contact_number:string,
    company_name:string,
    address1:string   
    address2:string   
    city:string   
    state:string   
    zip_code:string   
}

export interface HTTPprofile
{
    first_name:string,
    last_name:string,
    email:string,
    contact_number:string,
    company_name:string,
    address1:string   
    address2:string   
    city:string   
    state:string   
    zip_code:string      
}

export class profileForm implements HTTPprofile
{
    first_name:string;
    last_name:string;
    email:string;
    contact_number:string;
    company_name:string;
    address1:string;
    address2:string;  
    city:string;
    state:string;   
    zip_code:string;  
  
    constructor(data : profile) 
    {
        if(data==null)
        {        
            this.first_name="";
            this.last_name="";
            this.email="";
            this.contact_number="";
            this.company_name="";
            this.address1="";
            this.address2="";
            this.city="";
            this.state="";
            this.zip_code="";
        }
        else
        {         
            this.first_name = data.first_name;
            this.last_name = data.last_name;
            this.email = data.email;
            this.contact_number = data.contact_number;
            this.company_name = data.company_name;
            this.address1 = data.address1;
            this.address2 = data.address2;
            this.city = data.city;
            this.state = data.state;
            this.zip_code = data.zip_code;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            first_name:[this.first_name, [Validators.required]],
            last_name:[this.last_name, Validators.required],
            email:[this.email, [Validators.required, Validators.pattern("^[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,10}$")]],
            contact_number:[this.contact_number, [Validators.required, Validators.pattern("[0-9 ]{10}")]],
            company_name:[this.company_name, [Validators.required]],   
            address1:[this.address1, [Validators.required]],    
            address2:[this.address2, [Validators.required]],     
            city:[this.city, [Validators.required]],     
            state:[this.state, [Validators.required]],     
            zip_code:[this.zip_code, [Validators.required]]     
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.first_name = fg.get("first_name").value;
            this.last_name = fg.get("last_name").value;
            this.email = fg.get("email").value;
            this.contact_number = fg.get("contact_number").value;            
            this.company_name = fg.get("company_name").value;            
            this.address1 = fg.get("address1").value;            
            this.address2 = fg.get("address2").value;            
            this.city = fg.get("city").value;            
            this.state = fg.get("state").value;            
            this.zip_code = fg.get("zip_code").value;            
            return true;
        }
        else
        {
            return false;
        }
    }
  }

// profile : changepassword 
export interface changepassword
{
    old_password:string,
    new_password:string,
    confirm_password:string 
}

export interface HTTPgetchangepassword
{
    old_password:string,
    new_password:string,
    confirm_password:string      
}

export class changepasswordForm implements HTTPgetchangepassword
{
    old_password:string;
    new_password:string;
    confirm_password:string;

    constructor(data : changepassword) 
    {
        if(data==null)
        {        
            this.old_password="";
            this.new_password="";
            this.confirm_password="";
        }
        else
        {         
            this.old_password = data.old_password;
            this.new_password = data.new_password;
            this.confirm_password = data.confirm_password;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            old_password:[this.old_password],
            new_password:[this.new_password],
            confirm_password:[this.confirm_password]   
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.old_password = fg.get("old_password").value;
            this.new_password = fg.get("new_password").value;
            this.confirm_password = fg.get("confirm_password").value;            
            return true;
        }
        else
        {
            return false;
        }
    }
  }
