import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { HttpClient, HttpHeaders, HttpParams } from '@angular/common/http';
import { AppService } from '../shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';

@Injectable({
  providedIn: 'root'
})
export class ProfileService extends AppService<any>{

  constructor(public http: HttpClient) {
    super(http)
    this.appmod = "user";
   }

   @LoaderEnabled()
   getUsers(data: any):Observable<any>
   {
     this.appmod="user";
     let tmp=this.getService(data);
     this.appmod="usermanagement";
     return tmp;
   }

   SaveData(data: any, image: File | string): Observable<any> {
    let postData: FormData;
    postData.append("data", data);
    postData.append("image", image);

    this.appmod="user";
    let result = super.saveService(postData);
    this.appmod="usermanagement";
    return result;
  }
  
}
