import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class ReportService extends AppService<any>{

  constructor(public http: HttpClient) {
    super(http)
   }

   @LoaderEnabled()
   tMobileReportList(): Observable<any>{
    let apiUrl = environment.SERVER + 'tmobile-list';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
     });
    return this.http.get(apiUrl, {headers: httpHeaders});
   }

   @LoaderEnabled()
   tMobileReport(month?: any): Observable<any> {
     let apiUrl = environment.SERVER+ 'tmobile-report';
     let httpHeaders = new HttpHeaders({
     
     });
     return this.http.get(apiUrl, {headers: httpHeaders, params: {month: month}})
   }

  gettmobile():Observable<any>{
    return this.http.get('./assets/tmobile.json');
  }
}
