import { Component } from '@angular/core';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { FormBuilder } from '@angular/forms';
import { ReportService } from '../reports.service';
import { saveAs } from 'file-saver';
import * as XLSX from 'xlsx';

@Component({
  selector: 'app-tmobile',
  templateUrl: './tmobile.component.html',
  styleUrls: ['./tmobile.component.css']
})
export class TmobileComponent extends AppComponentClass<any,any> {
  listdata: any;
  header: any;
  page = 1;
	count = 0;
	tableSize = 25;
	tableSizes = [ 25,50 , 100];
	searchText = { count: 0 };
	filtre: string;
  errMessage: any = "";
  EXCEL_TYPE = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
  EXCEL_EXTENSION = '.xlsx';

  constructor(public data: ReportService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  ngOnInit(): void {

    this.data.gettmobile().subscribe((result) => {
      this.header = result[0].headers_details; 
    });

    this.data.tMobileReportList().subscribe(res => {
        if(res.status == 200){
          this.listdata = res.data;
          $.getScript('./assets/table.js');
        }
        else{
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  exportFile(data){
     this.data.tMobileReport(data.month).subscribe(res => {
        if(res.status == 200){
            let data = res.data[0];
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(data);
            const workbook: XLSX.WorkBook = { Sheets: { 'data': worksheet }, SheetNames: ['data'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
            this.saveAsExcelFile(excelBuffer, "tmobile_report");
        }
        else{
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
     }, err => {
       this.errMessage = err.message;
       setTimeout(() => {
         this.errMessage = "";
       }, 5000);
     });
  }


private saveAsExcelFile(buffer: any, fileName: string): void {
  const data: Blob = new Blob([buffer], {
    type: this.EXCEL_TYPE
  });
  saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
}

  onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
    } 
	  
	onTableDataChange(event){
		this.page = event.length;	
	} 
}
