import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { resourceUsage } from "node:process";
import { Observable } from "rxjs";
import { environment } from "src/environments/environment";
import { LoaderEnabled } from "../shared/loader/loader.service";
import { AppService } from "../shared/service/AppService.class";
@Injectable({
  providedIn: 'root'
})
export class ResellerService extends AppService<any> {
  from_amount: any;
  to_amount: any;
  commission: any;
  tier: any;
  patchValue(arg0: { isAddress: string; isPlan: string; }) {
    throw new Error('Method not implemented.');
  }

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });

  constructor(public http: HttpClient) {
    super(http);
  }

  public getsuppiler(): Observable<any> {
    return this.http.get('./assets/reseller.json');
  }

  @LoaderEnabled()
  saveReseller(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "saveReseller";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getTariffs(): Observable<any> {
    this.appmod = "getTariffs";
    let tmp = this.getService();
    this.appmod = "";
    return tmp;
  }

  @LoaderEnabled()
  getPreferenceService(): Observable<any> {
    this.appmod = "service";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getresellerlinkdetails(): Observable<any> {
    this.appmod = "get_resellerLINK";
    let tmp = this.getService();
    this.appmod = "";
    return tmp;
  }

  @LoaderEnabled()
  applyFilter(data?: any): Observable<any> {
    this.appmod = "getresellerlinkfilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getReseller(data?: any): Observable<any> {
    this.appmod = "getReseller";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  /*customer details filter services*/
  @LoaderEnabled()
  applyCustomerDFilter(data?: any): Observable<any> {
    this.appmod = "customerDetailsFilter";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  commissionTerm(): Observable<any> {
    this.appmod = "commissionTerm";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  /*DELETE RESELLER service*/
  @LoaderEnabled()
  onDeleteReseller(iduser: any): Observable<any> {
    const apiURL = environment.SERVER + 'deleteReseller';
    let httpHeaders = new HttpHeaders({

    });
    return this.http.delete(apiURL, { headers: httpHeaders, params: { iduser: iduser } });
  }
  /*end here domian block services..*/

  @LoaderEnabled()
  getsingleReseller(data: any): Observable<any> {
    this.appmod = "getResellerPlan_tariff";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateResellerbyID(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'updateResellerbyID';
    let result = super.updateService(data);
    this.appmod = tmp;
    return result;
  }

  // @LoaderEnabled()
  // getsingleUser(data: any): Observable<any> {
  //   this.appmod = "getsingleReseller";
  //   let result = super.getService(data);
  //   this.appmod = "";
  //   return result;
  // }

  @LoaderEnabled()
  applyresellerFilter(data?: any): Observable<any> {
    this.appmod = "resellerFilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  /* Reseller services closed here*/


  /*FOR COMMISSION DETAILS*/

  /*GET commission detail filter service*/
  @LoaderEnabled()
  applyCommDetailsFilter(data?: any): Observable<any> {
    this.appmod = "commDetailsFilter";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  /*end here commission detail services..*/

  /*FOR COMMISSION PLAN*/

  /*INSERT commission plan service*/
  @LoaderEnabled()
  saveCommissionPlan(data: any): Observable<any> {
    this.appmod = "saveCommissionPlan";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  /*GET commission plan service*/
  @LoaderEnabled()
  getCommissionPlan(data?: any): Observable<any> {
    this.appmod = "getCommissionPlan";
    let tmp = this.getService(data);
    this.appmod = "";
    return tmp;
  }


  @LoaderEnabled()
  setDefault(data): Observable<any> {
    let apiUrl = environment.SERVER + "default_plan";
    let httpHeaders = new HttpHeaders({
      // "Content-Type": "application/json",
    });
    return this.http.put(apiUrl, { data: data }, { headers: httpHeaders });
  }


  /*UPDATE commission plan service*/
  @LoaderEnabled()
  updateCommissionPlan(data: any) {
    this.appmod = "updateCommissionPlan";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  /*DELETE commission plan service*/
  @LoaderEnabled()
  ondeleteCommissionPlan(id_plan: any): Observable<any> {
    const apiURL = environment.SERVER + 'deleteCommissionPlan';
    let httpHeaders = new HttpHeaders({

    });
    return this.http.delete(apiURL, { headers: httpHeaders, params: { id_plan: id_plan } });
  }

  // @LoaderEnabled()
  // getsingleCommPlan(data: any): Observable<any> {
  //   this.appmod = "singleGetCommissionPlan";
  //   let result = super.getService(data);
  //   this.appmod = "";
  //   return result;
  // }

  // @LoaderEnabled()
  // Loginreseller(resellerLogin:any): Observable<any> {
  //   const apiURL = 'http://localhost:4250/reseller_login';
  //   let httpHeaders = new HttpHeaders({
  //   });
  //   return this.http.post(apiURL, { headers: httpHeaders, params: { resellerLogin: resellerLogin } });
  // }


  // @LoaderEnabled()
  // applycommissionFilter(): Observable<any> {
  //   this.appmod = "commissionFilter";
  //   let result = super.getService();
  //   this.appmod = "";
  //   return result;
  // }

  /*end here commission detail services..*/

  /*FOR COMMISSION PLAN--Tiers*/

  /*INSERT commission tiers service*/
  @LoaderEnabled()
  saveCommissionTier(data: any): Observable<any> {
    this.appmod = "saveCommissionTier";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  /*GET commission Tier service*/
  @LoaderEnabled()
  getCommissionTier(data: any): Observable<any> {
    this.appmod = "getCommissionTier";
    let tmp = this.getService(data);
    this.appmod = "";
    return tmp;
  }


  @LoaderEnabled()
  ResellerLogin(ResellerLogin): Observable<any> {
    this.appmod = 'reseller_login';
    let result = super.saveService(ResellerLogin);
    this.appmod = "";
    return result;
  }

  /*UPDATE commission tiers service*/
  @LoaderEnabled()
  updateCommPTier(data: any) {
    this.appmod = "updateCommissionTier";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  /*DELETE commission plan service*/
  @LoaderEnabled()
  ondeleteTier(id_tier: any): Observable<any> {
    const apiURL = environment.SERVER + 'deleteCommissionTier';
    let httpHeaders = new HttpHeaders({

    });
    return this.http.delete(apiURL, { headers: httpHeaders, params: { id_tier: id_tier } });
  }

  @LoaderEnabled()
  PayTransaction(data: any): Observable<any> {
    this.appmod = "PayTransactionAmount";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }


}
