import { Component, Inject, OnInit } from '@angular/core';
import {  MatDialogRef, MAT_DIALOG_DATA  } from '@angular/material/dialog';
import { BehaviorSubject } from 'rxjs';

@Component({
  selector: 'app-dialog',
  templateUrl: './dialog.component.html',
  styleUrls: ['./dialog.component.css']
})
export class DialogComponent implements OnInit {

  errMessage$ =  new BehaviorSubject<string>("");
  errMessage = this.errMessage$.asObservable();

  constructor( 
    
    public dialogRef: MatDialogRef<DialogComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any
    ) {
      this.errMessage$.next(data.errorMessage);
    }

  ngOnInit(): void {

  }

  onClick(): void {
    this.dialogRef.close();
  }
}
