import { HttpClient } from '@angular/common/http';
import { Component, Injectable, Input, OnDestroy, OnInit, ViewChild } from '@angular/core';
import { ChartComponent } from 'ng-apexcharts';
import { Observable, Subscription } from 'rxjs';
import { environment } from 'src/environments/environment';
import { LoaderEnabled } from '../loader/loader.service';

@Injectable()
export class ReportService {
	constructor(protected http: HttpClient) { }

	@LoaderEnabled()
	public Report(type: string, tab: string, idaccountuser: string, filter?: any): Observable<any> {
		return this.http.get<any>(environment.SERVER + "custom/chartdata", { headers: { "Content-Type": "application/json" }, params: { type, tab, idaccountuser } });
	}
}

@Component({
	selector: 'Report',
	templateUrl: './report.component.html',
	styleUrls: ['./report.component.css']
})
export class ReportComponent implements OnInit, OnDestroy {
	@Input() title?: string;
	@Input() type: string;
	@Input() tab: string;
	@Input() graph: any;
	@Input() idaccountuser: any;
	@Input() zoom?: boolean = false;

	private sub: Subscription;
	public reportstatus: boolean = false;
	public reportdata: any;

	public circularOption = {
		series: [],
		chart: {
			height: 200,
			type: "pie"
		},

		dataLabels: {
			enabled: true
		},
		labels: [],

		responsive: [
			{
				breakpoint: 480,
				options: {
					chart: {
						height: 200
					}
				}
			}
		],
		legend: { show: false, horizontalAlign: 'top', showForSingleSeries: false },
	};

	public lineOptions = {
		series: [
			{
				name: "basic",
				data: []
			}
		],
		chart: {
			type: "bar",
			height: 200
		},
		plotOptions: {
			bar: {
				horizontal: false
			}
		},
		dataLabels: {
			enabled: true
		},
		xaxis: {
			categories: []
		}

	};

	@ViewChild("chart") chart: ChartComponent;

	constructor(private report: ReportService) { }

	OnDataChange(event: any) {
		if (this.graph == "bar" || this.graph == "area" || this.graph == "line") {
			this.getLineReport();
		}

		if (this.graph == "donut" || this.graph == "pie" || this.graph == "radialBar") {
			this.getCirularReport();
		}
	}

	getLineReport() {
		this.sub = this.report.Report(this.type, this.tab, this.idaccountuser).subscribe(res => {
			let xaxis = [];
			let fields = [];
			let label = [];
			let i = 0;
			res.reports.forEach((element, index) => {
				Object.entries(element).forEach((key, value) => {
					if (key[0].toString() != "_id") {
						if (key[0].toString() == "Date" || key[0].toString() == "Hour") {
							xaxis.push(key[1]);
						}
						else {
							if (index == 0) {
								fields[key[0]] = [];
								label.push(key[0]);
								i++;
							}
							fields[key[0]].push(Math.round(parseFloat(key[1].toString()) * 100) / 100);
						}
					}
				});
			});
			this.lineOptions["xaxis"]["categories"] = xaxis;
			let data = []
			label.forEach(ele => {
				data.push({ data: fields[ele], name: ele });
			});
			this.lineOptions["series"] = data;
			this.lineOptions["chart"]["type"] = this.graph;
			this.reportstatus = true;
		});
	}

	getCirularReport() {
		this.sub = this.report.Report(this.type, this.tab, this.idaccountuser).subscribe(res => {
			let tmpseries = [], tmplabels = [];
			if (res.reports.length == 1) {
				Object.entries(res.reports[0]).forEach((key) => {
					if(key[0] !== "_id" && key[1]!==null) {
						tmpseries.push(Math.round(parseFloat(key[1].toString()) * 100) / 100);
						tmplabels.push(key[0]);
					}
				});
				this.circularOption["series"] = tmpseries;
				this.circularOption["labels"] = tmplabels;
			}
			this.reportstatus = true;
		});
	}

	ngOnInit() {
		if (this.graph == "bar" || this.graph == "area" || this.graph == "line") {
			this.getLineReport();
		}

		if (this.graph == "donut" || this.graph == "pie" || this.graph == "radialBar") {
			this.getCirularReport();
		}
	}

	ngOnChanges() {
		this.ngOnInit()
	}

	// ngAfterViewInit() {
	// 	if (this.graph == "bar" || this.graph == "area" || this.graph == "line") {
	// 		this.getLineReport();
	// 	}

	// 	if (this.graph == "donut" || this.graph == "pie" || this.graph == "radialBar") {
	// 		this.getCirularReport();				
	// 	}
	// }

	ngOnDestroy() {
		if (this.sub != undefined)
			this.sub.unsubscribe();
	}
}