import { OnInit, ViewChild } from "@angular/core";
import { Router } from "@angular/router";
import { AppService } from './AppService.class';
import { environment } from '../../../environments/environment';
import { AppData } from '../../shared/service/AppData.class'

export class AppComponentReport<T1> extends AppData {
    protected leadid:any;
    public displayedColumns : any[];
    private debug=environment.production;
    

    constructor(protected data: AppService<T1>, protected router: Router) {  
      super(router)
    }

    public debug_log(log:string)
    {
      if(!this.debug){}
    }

    ngOnInit()
    {
      this.data.getReport(this.leadid).subscribe(res=>{
        this.debug_log(res.toString());
      });
    }

    applyFilter(filterValue: string) {
      filterValue = filterValue.trim();
      filterValue = filterValue.toLowerCase();
    }
  }