import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs/Observable';
import { BehaviorSubject } from 'rxjs/BehaviorSubject';
import { environment } from '../../../environments/environment';
import { Option } from '../model/model.class';
import { APIURL } from '../../app-routing.module';
import { LoaderEnabled } from '../loader/loader.service';

export class AppService<T> {
  push(arg0: { id: number; callerid: string; areacode: string; phone: string; cost: string; followup: string; dialer: string; purchased: string; selected: boolean; }) {
    throw new Error("Method not implemented.");
  }
  every(arg0: (item: any) => boolean): any {
    throw new Error("Method not implemented.");
  }
    protected appmod : string;
    protected action : string;
    protected gdata : any;
    protected userkey : number;
    protected userid : number;
    private debug=environment.production;

    public service_data = new BehaviorSubject<T>(null);
    public solution= this.service_data.asObservable();

    public frm_label= new BehaviorSubject<string>("List Details");
    public label=this.frm_label.asObservable();
    public frm_status= new BehaviorSubject<boolean>(false);
    public status=this.frm_status.asObservable();
    length: number;
      
    constructor(protected http : HttpClient) { }


    public debug_log(log:string)
    {
      if(!this.debug){

      }
    }

    public get Action() : string {
      return this.action
    }
    
    public set Action(v : string) {
      this.action = v;
    }
  
    public set Data(v : T) {
      this.debug_log("Setting current data");
      this.service_data.next(v);
    }

    changefrm(value:boolean)
    {
      this.frm_status.next(value);
    }

    changelabel(lbl:string)
    {
      this.frm_label.next(lbl);
    }    

    public getReport(data:any):Observable<T[]>{    
      return this.http.get<T[]>(APIURL+this.appmod, {headers:{"Content-Type": "application/json"}, params:{type:"main", filter: JSON.stringify(data)}});
    }

    public getOption(data:string, filter?:any):Observable<Option[]>{
      if(filter==undefined)
      {
        return this.http.get<Option[]>(APIURL+this.appmod,{headers:{"Content-Type": "application/json"}, params:{type:data}});
      }
      else
      {
        return this.http.get<Option[]>(APIURL+this.appmod,{headers:{"Content-Type": "application/json"}, params:{type:data, filter: JSON.stringify(filter)}});
      }
    }

    public getServiceParam(type?:string, filter?:any): Observable<T[]> {
      if(filter==undefined)
      {
        if(type!=undefined)
          return this.http.get<T[]>(APIURL+this.appmod,{headers:{"Content-Type": "application/json"}, params:{type}});
        else
          return this.http.get<T[]>(APIURL+this.appmod, {headers:{"Content-Type": "application/json"}, params:{type:"main"}});  
      }
      else
      {
        if(type!=undefined)
          return this.http.get<T[]>(APIURL+this.appmod,{headers:{"Content-Type": "application/json"}, params:{type, filter: JSON.stringify(filter)}});
        else
          return this.http.get<T[]>(APIURL+this.appmod, {headers:{"Content-Type": "application/json"}, params:{type:"main", filter: JSON.stringify(filter)}});
      }
    }

    public getOptionParams(url:any, filter:any):Observable<Option[]>{
      return this.http.get<Option[]>(APIURL+url,{headers:{"Content-Type": "application/json"}, params:{type:url, data:filter}});
    }
    
    // public getDownload(data:string):Observable<Blob>{
    //   return this.http.get(APIURL+'download/'+this.appmod, {headers: {"Content-Type": "application/octet-stream"}, params: {type:"download", data:data}, responseType: 'blob', observe: 'body'});
    // }

    public getDownload(data:string, type:string='download'):Observable<Blob>{
      return this.http.get(APIURL+this.appmod, {headers: {"Content-Type": "application/octet-stream"}, params: {type:type, data:data}, responseType: 'blob', observe: 'body'});
    }

    public getServiceQParam(type?:any): Observable<T[]> {     
      if(type==undefined)
      {
        return this.http.get<T[]>(APIURL+this.appmod, {headers:{"Content-Type": "application/json"}, params:{type:"main"}});  
      }
      else
      {
         return this.http.get<T[]>(APIURL+this.appmod, {headers:{"Content-Type": "application/json"}, params:{type:JSON.stringify(type)}});
      }
    }

    
    public getService(type?: string, filter?: any, where?: string): Observable<T[]> {
      if (filter == undefined) {
        if (where == undefined) {
          if (type != undefined)
            return this.http.get<T[]>(APIURL + this.appmod, { headers: { "Content-Type": "application/json" }, params: { type } });
          else
            return this.http.get<T[]>(APIURL + this.appmod, { headers: { "Content-Type": "application/json" }, params: { type: "main" } });
        }
        else {
          if (type != undefined)
            return this.http.get<T[]>(APIURL + this.appmod, { headers: { "Content-Type": "application/json" }, params: { type, where } });
          else
            return this.http.get<T[]>(APIURL + this.appmod, { headers: { "Content-Type": "application/json" }, params: { type: "main", where } });
        }
      }
      else {
        if (type != undefined)
          return this.http.get<T[]>(APIURL + this.appmod, { headers: { "Content-Type": "application/json" }, params: { type, filter: JSON.stringify(filter) } });
        else
          return this.http.get<T[]>(APIURL + this.appmod, { headers: { "Content-Type": "application/json" }, params: { type: "main", filter: JSON.stringify(filter) } });
      }
    }
  

    public getCalandarService( variables?:any): Observable<T[]> {
          if(variables!=undefined)
            return this.http.get<T[]>(APIURL+this.appmod,{headers:{"Content-Type": "application/json"}, params:{variables: JSON.stringify(variables)}});
    }
  
    public saveService(data:any, type?:string): Observable<any>
    {
      if(type!=undefined)
        return this.http.post<any>(APIURL+this.appmod, {"data":data}, { headers: {"Content-Type": "application/json"}, params:{type} });
      else
        return this.http.post<any>(APIURL+this.appmod, {"data":data}, { headers: {"Content-Type": "application/json"}, params:{type:"main"}});
    }

    public detailService(key:number, type?:string):Observable<T>
    {
      if(type!=undefined)
        return this.http.get<T>(APIURL+this.appmod,{headers:{"Content-Type": "application/json"}, params:{id:key.toString(), type:type, authkey:localStorage.getItem('token')}});
      else
        return this.http.get<T>(APIURL+this.appmod,{headers:{"Content-Type": "application/json"}, params:{id:key.toString(), type:"detail", authkey:localStorage.getItem('token')}});
    }
  
    public statusService(data:any, key:number, type?:string): Observable<string>
    {
      if(type!=undefined)
        return this.http.post<string>(APIURL+this.appmod+key, {"data":data, "id":key}, { headers: {"Content-Type": "application/json"}, params:{id:key.toString(), type:type} });
      else
        return this.http.post<string>(APIURL+this.appmod+key, {"data":data, "id":key}, { headers: {"Content-Type": "application/json"}, params:{id:key.toString(), type:"status"} });
    }
  
    public updateService(data:any, key?:number, type?:string): Observable<T>
    {
      if(key!=undefined)
      {
        if(type!=undefined)
          return this.http.put<T>(APIURL+this.appmod, {"data":data}, { headers: {"Content-Type": "application/json"}, params: {id:key.toString(), type:type} });
        else
          return this.http.put<T>(APIURL+this.appmod, {"data":data}, { headers: {"Content-Type": "application/json"}, params: {id:key.toString(),type:"main"} });
      }
      else
      {
        return this.http.put<T>(APIURL+this.appmod, {"data":data}, { headers: {"Content-Type": "application/json"}, params: {type:type} });        
      }
    }

    public custupdateService(data:any, type?:string): Observable<T>
    {
      if(type!=undefined)
        return this.http.put<T>(APIURL+this.appmod, {"data":data}, { headers: {"Content-Type": "application/json"}, params: {type:type} });
      else
        return this.http.put<T>(APIURL+this.appmod, {"data":data}, { headers: {"Content-Type": "application/json"}, params: {type:"main"} });
    }

    @LoaderEnabled()
    public updatePassword(data:any, key:number): Observable<T>
    {
      return this.http.put<T>(APIURL+'custom/changepassword/', {"data":data}, { headers: {"Content-Type": "application/json"}, params: {id:key.toString()} });
    }
    @LoaderEnabled()
    public updatePass(data:any, key:number): Observable<T>
    {
      return this.http.put<T>(APIURL+'custom/changepass/', {"data":data}, { headers: {"Content-Type": "application/json"} });
    }
    public deleteService( key?:number, type?:string): Observable<T>
    {
      if(type!=undefined)
        return this.http.delete<T>(APIURL+this.appmod, { headers: {"Content-Type": "application/json"}, params: {id:key.toString(), type:type}});
      else
        return this.http.delete<T>(APIURL+this.appmod, { headers: {"Content-Type": "application/json"}, params: {id:key.toString(),type:"main"}});
    }

    public getReportwhere(data:string, where?:string):Observable<any>{
      if(where==undefined)
        return this.http.get<T[]>(APIURL+"reports/"+data+"/");
      else
        return this.http.get<T[]>(APIURL+"reports/"+data+"/", { headers: {"Content-Type": "application/json"}, params: {where}});
    }


    public PatchService(data:any, key?:number, type?:string):Observable<T>{
      if(key!=undefined)
      {
        if(type!=undefined)
          return this.http.patch<T>(APIURL+this.appmod, {"data":data}, {headers:{"Content-Type": "application/json"}, params:{id:key.toString(), type:type}});
        else
          return this.http.patch<T>(APIURL+this.appmod, {"data":data}, {headers:{"Content-Type": "application/json"}, params:{id:key.toString(),type:"main"}});
      }
      else
      {
        if(type!=undefined)
          return this.http.patch<T>(APIURL+this.appmod, {"data":data}, {headers:{"Content-Type": "application/json"}, params:{type:type}});
        else
          return this.http.patch<T>(APIURL+this.appmod, {"data":data}, {headers:{"Content-Type": "application/json"}, params:{type:"main"}});
      }
     
    }

    public customGetService(url:string,filter?:any): Observable<any> {
      return this.http.get<any>(APIURL+url,{ headers: {"Content-Type": "application/json"}, params: {filter}});
    }

  /** custom services **/
  public customGetServiceUI(url: string, data?: any): Observable<any> {
    return this.http.get<any>(APIURL + url, { headers: { "Content-Type": "application/json" }, params: { type: "main", filter: JSON.stringify(data) } });
  }

  public customDeleteServiceUI(url: string, data: any): Observable<any> {
    let options: any = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json'
      }),
      body: {
        data: JSON.stringify(data)
      }
    }
    return this.http.delete<any>(APIURL + url, options)
  }

  public Download(data:string, filename:string):Observable<Blob>{
    this.debug_log(APIURL+"download/"+data);
    return this.http.post(APIURL+"download/"+data, {"filename":filename}, {headers: {"Content-Type": "application/octet-stream"}, params: {"filename":filename}, responseType: 'blob', observe: 'body'});
  }

  }