import * as CryptoJS from 'crypto-js';

export default function decryptData(data:string) {
    try {
        const bytes = CryptoJS.AES.decrypt(data, sessionStorage.getItem('token'));
        if (bytes.toString()) {
            return JSON.parse(bytes.toString(CryptoJS.enc.Utf8));
        }
        return data;
    } catch (e) {
        console.log(e);
    }
}

export function encryptData(setItemTo:string, data:object, salt:string) {
    try {
        sessionStorage.setItem(setItemTo, CryptoJS.AES.encrypt(JSON.stringify(data), salt).toString());

    } catch (e) {
        console.log(e);
    }

}

