import { Injectable } from "@angular/core";
import { HttpClient } from "@angular/common/http";
import { Observable } from "rxjs";
import { AppService } from "../service/AppService.class";
import { LoaderEnabled } from "../loader/loader.service";

@Injectable()
export class MenuService extends AppService<any>{
  constructor(protected http:HttpClient) {
    super(http);
    this.appmod="getcdr";
   }  

  // public getMenu():Observable<any>{
  //   return this.http.get('./assets/menu.json');
  // }

  @LoaderEnabled()
  public getAdminMenu(): Observable<any>{
    return this.http.get("./assets/adminmenu.json");
  }

  @LoaderEnabled()
  public getCustomerMenu(): Observable<any>{
    return this.http.get('./assets/customermenu.json');
  }

  @LoaderEnabled()
  public getCustomersideMenu(): Observable<any>{
    return this.http.get('./assets/customersidemenu.json');
  }

  @LoaderEnabled()
  public getCustomersideMenuForKyc(): Observable<any>{
    return this.http.get('./assets/customermenuforkyc.json');
  }
  @LoaderEnabled()
  public getSubCustomer(): Observable<any>{
    return this.http.get('./assets/sub-customer.json');
  }

  @LoaderEnabled()
  public getSupplierMenu(): Observable<any>{
    return this.http.get('./assets/suppliermenu.json');
  }
  
  @LoaderEnabled()
  public getSignupMenu(): Observable<any>{
    return this.http.get('./assets/signupmenu.json');
  }
  @LoaderEnabled()
  public getCustomersideMenuForVerifykyc(): Observable<any>{
    return this.http.get('./assets/customermenuforVerifykyc.json');
  }
  @LoaderEnabled()
  public getSubUserMenu(): Observable<any>{
    return this.http.get('./assets/subUserMenu.json');
  }
}
