import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ShortcodesmsService } from '../shortcodesms.service';
import { ActivatedRoute, Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { environment } from 'src/environments/environment';
import { HttpClient, HttpRequest } from '@angular/common/http';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
  selector: 'app-shortcodesms',
  templateUrl: './shortcodesms.component.html',
  styleUrls: ['./shortcodesms.component.css'],
})
export class ShortcodesmsComponent implements OnInit {
  @ViewChild('modalImageAppeal') modalImageAppeal: ElementRef;
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  @ViewChild('closeModal') closeModal: ElementRef;
  @ViewChild('reject') reject: ElementRef;
  @ViewChild('viewclose') viewclose: ElementRef;
  @ViewChild('CloseIcn') CloseIcn: ElementRef;
  @ViewChild('approvemodal') closeapprove: ElementRef;
  show_filter: boolean = false;
  public filterForm: FormGroup;
  Campaign: any;
  responseMessage: any = '';
  errMessage: any = '';
  isSubmit: boolean = false;
  isEdit: boolean = false;
  selected_id: any;
  userType: any;
  public userInfo: any;
  tabheader1: any;
  tabheader2: any;
  tabheader3: any;
  tabheader4: any;
  tabheader5: any;
  tabheader6: any;
  tabheader7: any;
  CustomerCampaign: any[];
  filteredCampaigns: any[];
  approved: any[];
  pending: any[];
  rejected: any[];
  numbermapped: any[];
  process_started: any[];
  process_rejected: any[];
  process_approved: any[];
  Filter: string = 'Pending Review'
  selectedTab: string = '';
  users: any[];
  selectedUser: any;
  submitted: boolean = false;
  SCfilter: any;
  SCfilterCSV: any;
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  status: any;
  batchdata: any[];
  selectedItem1: any = [];
  iselectAll: Boolean = false;
  selectedAwait: any = [];
  selectedAwaitCount: any;
  isSelected: Boolean = false;
  isChecked: Boolean = false;

  reviewId: any;
  user_id: any;
  user_acc: any;
  unique_id: any;
  scNumber: any;
  scContact: any;
  profileID: any;
  pID: any;
  public rejectForm: FormGroup
  idaccount1: any;
  iduser1: any;
  idprofile1: any;
  SCrequest: any = [];
  User_ID: any;
  sctype: any;
  campID: any;
  profile_id: any;
  checkedCarriers: any = [];
  totalRate: number = 0;
  carriers: any[]
  user1: any = [];
  connectionList: any = [];
  user2: any;
  key: any;
  myvalue1: string;
  user: any;
  IDuser: any;
  IDAccount: any;
  randomVanityform: FormGroup;
  tariff: any;
  myvaluee: string;
  rates: any = [];
  showrates: any = [];
  migratedDID: number | null = null;
  allconnection: any = [];
  files: File[] = [];
  fileErr: string;
  oldfile: boolean = false;
  ScRequest: any;
  approveIDAcc: any;
  approveIDUser: any;
  approveID: any;
  approveRates: any;
  dropdownSettingsscType: IDropdownSettings = {};
  dropdownSettingsstatus: IDropdownSettings = {};
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  selectedItem: any = [];
  name_with_san: any = [];
  userss: any = [];
  isselet: boolean = false
   scType: any =[]
   Account_ID: any;
   selectedItem2: any = []

  constructor(private fb: FormBuilder, public data: ShortcodesmsService, public router: Router, private route: ActivatedRoute, private userService: UsermanagementService, private http: HttpClient) { }

  ngOnInit(): void {
    this.selectedAwaitCount = '';
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.filterForm = this.fb.group({
      from: [''],
      to: [''],
      campaignname: [''],
      requestid: [''],
      status: [''],
      filter_type: [''],
      user: [''],
      sc_request_id: [''],
      sc_type: [''],
      batch_id: ['']
    });

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'name',
      textField: 'Name_san',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    this.filterForm.patchValue({
      filter_type: this.userType == 1 ? "Pending Review" : ''
    })
    this.batchData();
    this.GetSCampaign();


    this.data.get_Carrier().subscribe((result) => {
      this.userInfo = result[3].tabheader;
      this.tabheader1 = this.userInfo[0].tableheaders
      this.tabheader2 = this.userInfo[1].tableheaders
      this.tabheader3 = this.userInfo[2].tableheaders
      this.tabheader4 = this.userInfo[3].tableheaders
      this.tabheader5 = this.userInfo[4].tableheaders
      this.tabheader6 = this.userInfo[5].tableheaders
      this.tabheader7 = this.userInfo[6].tableheaders
      this.tabheader7 = this.userInfo[6].tableheaders
      this.status = result[6]
       this.scType = result[8].SCType
    });
    $.getScript('./assets/tollfree.js');

    // this.userService.getidAccount().subscribe(res => {
    //   if (res.status == 200) {
    //     this.users = res.data;
    //     this.users.sort((a, b) => {
    //       return a.idaccount - b.idaccount;
    //     });
    //     const uniqueUsers = this.users.filter((value, index, self) =>
    //       index === self.findIndex((t) => t.iduser === value.iduser)
    //     );        
    //     uniqueUsers.forEach(element => {
    //       const fullName = `${element.first_name} ${element.last_name}`;
    //       this.name_with_san.push({
    //         name: element.idaccount + ' - ' + element.iduser,
    //         Name_san: element.san + ' - ' + fullName
    //       });
    //     });
        
    //     this.userss = this.name_with_san;
    //   }
    //   else {
    //     this.errMessage = res.message;
    //     setTimeout(() => {
    //       this.errMessage = "";
    //     }, 5000);
    //   }
    // }, err => {
    //   this.errMessage = err.message;
    //   setTimeout(() => {
    //     this.errMessage = "";
    //   }, 5000);
    // });
    this.getUsers()

    this.rejectForm = this.fb.group({
      reject_text: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]],
    });
    // this.data.getSCRequest().subscribe((result) => {
    //   if (result.status == 200) {
    //     this.SCrequest = result.data;
    //   }
    // });
    this.getRequestSC()
    this.randomVanityform = this.fb.group({
      randomVanityFile: ['', [Validators.required]],
      randomVanityInput: ['', [Validators.required]],
      SCtype: [''],
      SCReqID: [''],
      DIDprovider: [''],
      connectionName1: [''],
      rates: [''],
      description: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]]
    });
    this.getCarrier();

    this.dropdownSettingsstatus = {
      singleSelection: true,
      idField: 'Value',
      textField: 'Category',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
 
    this.dropdownSettingsscType = {
      singleSelection: true,
      idField: 'value',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
  }

  getUsers(){
    this.userService.getidAccount().subscribe(res => {
      if (res.status == 200) {
        this.users = res.data;
        this.users.sort((a, b) => {
          return a.idaccount - b.idaccount;
        });
        const uniqueUsers = this.users.filter((value, index, self) =>
          index === self.findIndex((t) => t.iduser === value.iduser)
        );        
        uniqueUsers.forEach(element => {
          const fullName = `${element.first_name} ${element.last_name}`;
          this.name_with_san.push({
            name: element.idaccount + ' - ' + element.iduser,
            Name_san: element.san + ' - ' + fullName
          });
        });
        
        this.userss = this.name_with_san;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  getRequestSC(){
    this.data.getSCRequest().subscribe((result) => {
      if (result.status == 200) {
        this.SCrequest = result.data;
      }
    });
  }

  getCarrier() {
    this.data.getCarrier().subscribe(result => {
      this.carriers = result.data
    });
  }
  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    } else {
      this.show_filter = false;
    }
  }

  setStatus(list) {
    list.forEach(element => {
      if (element.status == 0) {
        element.status = 'Number Mapped Process Start'
      }
      if (element.status == 1) {
        element.status = 'Pending Review'
      }
      if (element.status == 2) {
        element.status = 'Rejected'
      }
      if (element.status == 3) {
        element.status = 'Approved'
      }
      if (element.status == 4) {
        element.status = 'Number Mapped'
      }
      if (element.status == 5) {
        element.status = 'SC Campaign Profile Process Started'
      }
      if (element.status == 6) {
        element.status = 'SC Campaign Profile Approved'
      }
      if (element.status == 7) {
        element.status = 'SC Campaign Profile Rejected'
      }
    })
  }

  batchData() {
    this.data.get_scBatch().subscribe(res => {
      if (res.status == 200) {
        this.batchdata = res.data;
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  getid1(id: any, SCty: any, ID_user: any, IDprf: any, ScReq: any,IDAcc:any) {
    this.User_ID = ID_user;
    this.sctype = SCty;
    this.campID = id;
    this.profile_id = IDprf;
    this.ScRequest = ScReq;
    this.Account_ID = IDAcc;
    this.carriers = this.carriers.filter(item => item.sc_type == SCty);
  }

  getviewdata(accID: any, user: any, request: any) {
    this.checkedCarriers = []
    this.totalRate = 0
    let data: any = JSON.stringify({
      idaccount: accID,
      iduser: user
    });
    this.data.getConnection(data).subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.connectionList = response.data;
          let payLoad: any = JSON.stringify({
            idprofile: this.profile_id,
            iduser: this.User_ID,
            idrequest: request
          });
          this.data.getSCdata(payLoad).subscribe(result => {
            if (result.status == 200) {
              this.user1.push(result.data[0]);
              this.user2 = result.data1[0];
              this.key = this.user1[0].connection;
              const connection = this.connectionList.find(conn => conn.connection_key === this.key);
              if (connection) {
                const connectionName = connection.name;
                this.user1[0].connection = connectionName;
              }
              this.myvalue1 = this.user1[0].sc_type;
              const modifiedData = result.data3.map(item => {
                const { sc_carrier_coverage, ...rest } = item;
                return { display_name: sc_carrier_coverage, ...rest };
              });
              this.checkedCarriers = modifiedData
              this.totalRate = this.checkedCarriers.reduce((total, carrier) => total + carrier.rate, 0);
            } else {
              this.errMessage = result.message;
              setTimeout(() => {
                this.errMessage = '';
              }, 5000);
            }
          });
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = "Something went wrong with get Connection!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });


  }

  getrandomvanity(id: any, userID: any, idacc: any, request: any, ScReq: any, sctype: any) {
    this.totalRate = 0
    this.carriers = this.carriers.filter(item => item.sc_type == sctype);
    this.checkedCarriers = []
    let payload: any = JSON.stringify({
      iduser: userID,
      idaccount: idacc
    })
    this.data.getConnection(payload).subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.connectionList = response.data;
          this.IDuser = userID;
          this.IDAccount = idacc;
          this.profile_id = id;
          this.ScRequest = ScReq;

          const payLoad: any = JSON.stringify({
            idprofile: this.profile_id,
            iduser: this.IDuser,
            idrequest: request
          });

          this.data.getSCdata(payLoad).subscribe(result => {
            if (result.status === 200) {
              this.user = result.data[0];
              this.tariff = result.data1[0].idtariff;
              this.myvaluee = this.user.sc_type;

              let scTypeValue = '';
              if (this.user.sc_type === 2) {
                scTypeValue = 'New Random Shortcode';
              } else if (this.user.sc_type === 3) {
                scTypeValue = 'New Vanity Shortcode';
              }

              const key = this.user.connection.trim();
              const connection = this.connectionList.find(conn => conn.connection_key === key);
              if (connection) {
                const connectionName = connection.name;
                this.GetRatesID();
                this.randomVanityform.patchValue({
                  Random_vanity: '',
                  SCtype: scTypeValue,
                  SCReqID: this.user.sc_campaign_unique_id,
                  DIDprovider: 'Shortcode',
                  rates: '',
                  description: '',
                  connectionName1: connectionName.trim()
                });
              }
              const modifiedData = result.data3.map(item => {
                const { sc_carrier_coverage, ...rest } = item;
                return { display_name: sc_carrier_coverage, ...rest };
              });
              this.checkedCarriers = modifiedData
              this.totalRate = this.checkedCarriers.reduce((total, carrier) => total + carrier.rate, 0);
            } else {
              this.errMessage = result.message;
              setTimeout(() => {
                this.errMessage = '';
              }, 5000);
            }
          });
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = "Something went wrong with get Connection!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

  }

  GetRatesID() {
    let idtariff = this.tariff;
    this.data.GetRates(idtariff).subscribe(result => {
      if (result.status == 200) {
        if (result.data.length > 0) {
          this.rates = result.data;
          this.function1()
        }
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
  function1() {
    this.showrates = this.rates.filter(rate => rate.category === 'short_code_lease' || rate.category === 'vanity_short_code');
  }
  viewFile(data: any) {
    const fileExtension = data.migrated_filename.split('.').pop();
    const docxModal = document.getElementById('modalDocxAppeal');
    if (data.migrated_file_path) {
      const a = document.createElement('a');
      a.href = data.migrated_file_path;
      a.download = data.migrated_filename;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      $(docxModal).modal('show');
    }
  }
  viewFile1(data: any) {
    const fileExtension = data.sc_proof_filename.split('.').pop().toLowerCase();
    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const docxModal = document.getElementById('modalDocxAppeal');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalPdf = document.getElementById('modalPdf') as HTMLIFrameElement;

    if (fileExtension === "png" || fileExtension === "jpg" || fileExtension === "jpeg") {
      modalImage.src = data.sc_proof_doc_filepath;
      $(imageModal).modal('show');
    } else if (fileExtension === 'pdf') {
      modalPdf.src = data.sc_proof_doc_filepath;
      $(pdfModal).modal('show');
    } else {
      if (data.sc_proof_doc_filepath) {
        const a = document.createElement('a');
        a.href = data.sc_proof_doc_filepath;
        a.download = data.sc_proof_filename;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        // $(docxModal).modal('show');
      }
    }
  }
  viewFile2(data: any) {
    const fileExtension = data.filename.split('.').pop();
    // const docxModal = document.getElementById('modalDocxAppeal');
    if (data.file_path) {
      const a = document.createElement('a');
      a.href = data.file_path;
      a.download = data.filename;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      // $(docxModal).modal('show');
    }
  }
  downloadFile(data) {
    if (data.sc_proof_doc_filepath) {
      const a = document.createElement('a');
      a.href = data.sc_proof_doc_filepath;
      a.download = data.sc_proof_filename;
      a.click();
    }
  }
  downloadFile1(data) {
    if (data.migrated_file_path) {
      const a = document.createElement('a');
      a.href = data.migrated_file_path;
      a.download = data.migrated_filename;
      a.click();
    }
  }
  isChecked1(carrierName: string): boolean {
    return this.checkedCarriers.some(carrier => carrier.display_name === carrierName);
  }
  SCRequestData() {
    this.data.allConnection().subscribe((res) => {
      this.allconnection = res.data;
      this.data.getSCRequest().subscribe((result) => {
        if (result.status == 200) {
          this.SCrequest = result.data;
          this.SCrequest.forEach(item => {
            const matchingConnection = this.allconnection.find(conn => conn.connection_key === item.connection);
            if (matchingConnection) {
              item.name = matchingConnection.name;
            }
          });
          $('#basic-datatables7').dataTable().fnClearTable();
          $('#basic-datatables7').dataTable().fnDraw();
          $('#basic-datatables7').dataTable().fnDestroy();
          $.getScript('./assets/tollfree.js');

          $('#basic-datatablessc3').dataTable().fnClearTable();
          $('#basic-datatablessc3').dataTable().fnDraw();
          $('#basic-datatablessc3').dataTable().fnDestroy();
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = result.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      })
    })
  }
  verifySCrequest() {
    let data = {
      idaccount: this.user1[0].idaccount,
      iduser: this.user1[0].iduser,
      idcamp: this.campID,
      sc_req_id: this.ScRequest,
      SC_Number: this.user1[0].shortocde_number,
      sc_type: this.user1[0].sc_type,
      idprofile: this.profile_id,
      connection: this.key,
      total: this.totalRate,
      idtaiff: this.user2.idtariff
    }
    this.data.approveSC_req(data).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        this.viewclose.nativeElement.click();
        setTimeout(() => {
          this.responseMessage = "";
          // this.router.navigate(['./shortcode-request']);
          // this.SCRequestData();
          this.GetSCampaign();
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }

    })
  }

  SubmitrandomVanity() {
    if (this.randomVanityform.invalid) {
      this.submitted = true;
      return;
    } else {
      let scTypeValue = this.randomVanityform.get('SCtype').value == 'New Random Shortcode' ? '2' : '3';
      let providerValue;
      if (this.randomVanityform.get('DIDprovider').value === 'Shortcode') {
        providerValue = 'shortcode';
      }
      this.randomVanityform.patchValue({
        SCtype: scTypeValue,
        DIDprovider: providerValue
      })

      if (this.randomVanityform.get('SCtype').value === '2') {
        const rate = this.showrates.find(rate => rate.category === 'short_code_lease');
        this.randomVanityform.get('rates').setValue(rate.rate);
      } else if (this.randomVanityform.get('SCtype').value === '3') {
        const rate = this.showrates.find(rate => rate.category === 'vanity_short_code');
        this.randomVanityform.get('rates').setValue(rate.rate);
      }

      let didnumberValue = this.migratedDID ? this.migratedDID : this.randomVanityform.value.randomVanityInput;

      let payload: any = JSON.stringify({
        data: this.randomVanityform.value,
        // didnumber: this.migratedDID,
        didnumber: didnumberValue,
        idcamp: this.campID,
        iduser: this.IDuser,
        idaccount: this.IDAccount,
        idprofile: this.profile_id,
        connectionname: this.user.connection,
        total: this.totalRate,
        sc_request: this.ScRequest,
        idtariff: this.tariff
      })

      this.data.Saverandomvanity(payload, this.files).subscribe(
        (res) => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.CloseIcn.nativeElement.click();
            // this.ngOnInit();
            this.getRequestSC()
            // this.getUsers()
            this.SCRequestData();
            this.GetSCampaign();
            //window.location.reload();
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
          } else {
            this.errMessage = res.message;
            let scTypeValue = this.randomVanityform.get('SCtype').value === '2' ? 'Random Shortcode' : 'Vanity Shortcode';
            let providerValue;
            if (this.randomVanityform.get('DIDprovider').value === 'shortcode') {
              providerValue = 'Shortcode';
            }
            this.randomVanityform.patchValue({
              SCtype: scTypeValue,
              DIDprovider: providerValue
            })
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        },
        (err) => {
          let errorMessage = 'An unknown error occurred';
          if (err.error && err.error.error) {
            errorMessage = err.error.error;
          }
          this.errMessage = errorMessage;
          let scTypeValue = this.randomVanityform.get('SCtype').value === '2' ? 'Random Shortcode' : 'Vanity Shortcode';
          let providerValue;
          if (this.randomVanityform.get('DIDprovider').value === 'shortcode') {
            providerValue = 'Shortcode';
          }
          this.randomVanityform.patchValue({
            SCtype: scTypeValue,
            DIDprovider: providerValue
          })
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      );

    }
  }
  resetrandomvanity() {
    this.submitted = false;
    this.randomVanityform.reset();
    this.randomVanityform.get('randomVanityFile').enable();
    this.randomVanityform.get('randomVanityInput').enable();
    this.getCarrier();
    // this.user1 = [];
  }
  Resetrejectform() {
    this.submitted = false
    this.rejectForm.reset()
  }
  onFilePicked(event: Event,userid:any,idaccount:any) {    
    const fileInput = event.target as HTMLInputElement;
    const file: File = fileInput.files[0];

    if (!file) {
      return;
    }

    const allowedTypes = ['text/csv'];
    if (!allowedTypes.includes(file.type)) {
      this.errMessage = "Invalid file type!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
      fileInput.value = '';
      // this.shortcoderequestform.get('MigratedSC').setValue('');
      this.randomVanityform.get('randomVanityInput').setValue('');
      this.randomVanityform.get('randomVanityFile').setValue('');
      this.randomVanityform.get('randomVanityInput').enable();
      // this.shortcoderequestform.get('SC_Proof').setValue('');
      return;
    }

    const reader = new FileReader();
    reader.onload = () => {
      const fileContent = reader.result as string;
      const numbers = fileContent.match(/\b\d+\b/g);

      if (!numbers || numbers.length !== 1) {
        this.errMessage = "Please select a file with exactly one SC number.";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        // this.shortcoderequestform.get('MigratedSC').setValue('');
        this.randomVanityform.get('randomVanityInput').setValue('');
        this.randomVanityform.get('randomVanityFile').setValue('');
        this.randomVanityform.get('randomVanityInput').enable();
        // this.shortcoderequestform.get('SC_Proof').setValue('');
        return;
      }

      const validNumbers = numbers.filter(num => num.length === 5 || num.length === 6);

      if (validNumbers.length !== 1) {
        this.errMessage = "Please select a file with exactly one SC number.";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        // this.shortcoderequestform.get('MigratedSC').setValue('');
        this.randomVanityform.get('randomVanityInput').setValue('');
        this.randomVanityform.get('randomVanityFile').setValue('');
        this.randomVanityform.get('randomVanityInput').enable();
        // this.shortcoderequestform.get('SC_Proof').setValue('');
        return;
      }

      this.migratedDID = parseInt(validNumbers[0]);
      let payload: any = JSON.stringify({
        iduser: userid,
        idaccount: idaccount,
        did:this.migratedDID
      })
      this.data.checkDid(payload).subscribe(
        (res: any) => {
          if (res.status === 200) {
            this.files.push(file);
            this.oldfile = false;
            this.fileErr = '';
          } else {
            this.errMessage = res.message || 'Invalid DID';
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
            fileInput.value = '';
            this.randomVanityform.get('randomVanityFile').setValue('');
          }
        },
        (err) => {
          this.errMessage = 'You cannot upload the same Shortcode DID';
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
          fileInput.value = '';
          this.randomVanityform.get('randomVanityFile').setValue('');
        }
      );
    };

    reader.readAsText(file);
  }
  onRnInputChange(event: any) {
    const fileInput = event.target as HTMLInputElement;
    const file: File = fileInput.files[0];

    if (file) {
      this.randomVanityform.get('randomVanityInput').disable();
    } else {
      this.randomVanityform.get('randomVanityInput').enable();
      this.files = [];
      this.migratedDID = null;
    }
  }
  onRnFileChange(value: string) {
    if (value) {
      this.randomVanityform.get('randomVanityFile').disable();
    } else {
      this.randomVanityform.get('randomVanityFile').enable();
    }
  }

  GetSCampaign() {
    this.data.get_scBatch().subscribe(res1 => {
      this.data.GetCamp().subscribe((res) => {
        if (res.status === 201) {
          this.Campaign = res.data;
          for (const itemScCampaign of this.Campaign) {
            const sc_campaign_unique_id = itemScCampaign.id_profile;
            const matchingBatchData = res1.data.find(
              batchItem => batchItem.sc_campaign_unique_id == sc_campaign_unique_id
            );
            if (matchingBatchData) {
              itemScCampaign.batch_id_unique = matchingBatchData.batch_id_unique;
            }
          }
          this.CustomerCampaign = res.data;
          // this.filteredCampaigns = this.CustomerCampaign.filter(campaign =>
          //   campaign.status === 1 || campaign.status === 2 || campaign.status === 3);
          this.CustomerCampaign.forEach(campaign => {
            // if(campaign.status == 6){
            let matchingRequest = this.SCrequest.find(request => request.profile_id == campaign.id_profile);

            if (matchingRequest) {
              campaign.sc_type = matchingRequest.sc_type;
              campaign.sc_request_status = matchingRequest.status;
              campaign.id_request = matchingRequest.id_request;
              campaign.sc_request_id = matchingRequest.sc_request_id;
            }
            // }
          })
          this.pending = [];
          this.rejected = [];
          this.approved = []
          this.numbermapped = [];
          this.process_started = [];
          this.process_rejected = [];
          this.process_approved = [];
          if (this.userType == 1) {
            this.CustomerCampaign.forEach((element) => {
              if (element.status == 1) {
                element.status = 'Pending Review';
                this.pending.push(element);
              }
              if (element.status == 2) {
                element.status = 'Rejected';
                this.rejected.push(element);
              }
              if (element.status == 3) {
                element.status = 'Approved';
                this.approved.push(element);
              }
              if (element.status == 4) {
                element.status = 'Number Mapped';
                this.numbermapped.push(element);
              }
              if (element.status == 5) {
                element.status = 'SC Campaign Profile Process Started';
                this.process_started.push(element);
              }
              if (element.status == 6) {
                element.status = 'SC Campaign Profile Approved';
                this.process_approved.push(element);
              }
              if (element.status == 7) {
                element.status = 'SC Campaign Profile Rejected';
                this.process_rejected.push(element);
              }
            });
          } else {
            this.CustomerCampaign = res.data;
            this.setStatus(this.CustomerCampaign);
            $('#basic-datatables7').dataTable().fnClearTable();
            $('#basic-datatables7').dataTable().fnDraw();
            $('#basic-datatables7').dataTable().fnDestroy();
          }


          $('#basic-datatables1').dataTable().fnClearTable();
          $('#basic-datatables1').dataTable().fnDraw();
          $('#basic-datatables1').dataTable().fnDestroy();

          $('#basic-datatablessc1').dataTable().fnClearTable();
          $('#basic-datatablessc1').dataTable().fnDraw();
          $('#basic-datatablessc1').dataTable().fnDestroy();

          $('#basic-datatablessc3').dataTable().fnClearTable();
          $('#basic-datatablessc3').dataTable().fnDraw();
          $('#basic-datatablessc3').dataTable().fnDestroy();

          $('#basic-datatablessc4').dataTable().fnClearTable();
          $('#basic-datatablessc4').dataTable().fnDraw();
          $('#basic-datatablessc4').dataTable().fnDestroy();

          $('#basic-datatablessc5').dataTable().fnClearTable();
          $('#basic-datatablessc5').dataTable().fnDraw();
          $('#basic-datatablessc5').dataTable().fnDestroy();

          $('#basic-datatablessc6').dataTable().fnClearTable();
          $('#basic-datatablessc6').dataTable().fnDraw();
          $('#basic-datatablessc6').dataTable().fnDestroy();

          $('#basic-datatablesShortsc').dataTable().fnClearTable();
          $('#basic-datatablesShortsc').dataTable().fnDraw();
          $('#basic-datatablesShortsc').dataTable().fnDestroy();

          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      });
    })
  }

  CopyButton(id: any) {
    this.selected_id = id;
  }

  onRadioChange(option: string) {
    if (option === 'edit') {
      this.isSubmit = false;
      this.isEdit = true;
    } else if (option === 'copy') {
      this.isSubmit = true;
      this.isEdit = false;
    }
  }

  Resetradio() {
    this.isEdit = false;
    this.isSubmit = false;
    const editCheck = document.getElementById("editCheck") as HTMLInputElement;
    const copyCheck = document.getElementById("copyCheck") as HTMLInputElement;

    if (editCheck && copyCheck) {
      editCheck.checked = false;
      copyCheck.checked = false;
    }
  }

  copySC() {
    this.data.copySCDAta(this.selected_id).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message
        this.closeModal.nativeElement.click();
        this.GetSCampaign()
        setTimeout(() => {
          this.responseMessage = ''
        }, 5000);
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  EditSc() {
    const id = this.selected_id
    this.router.navigateByUrl(`/create-profile/copy/${this.selected_id}`);
  }

  submit1() {
    let myid = this.selected_id;
  }


  showbtn1(data: any) {
    if (data === 'Approved') {
      this.Filter = 'Approved';
    } else if ((data === 'Rejected')) {
      this.Filter = 'Rejected';
    } else if (data === 'Shortcode Request Created') {
      this.Filter = 'Shortcode Request Created';
    } else if (data === 'SC Campaign Profile Process Started') {
      this.Filter = 'SC Campaign Profile Process Started';
    } else if (data === 'SC Campaign Profile Approved') {
      this.Filter = 'SC Campaign Profile Approved';
    } else if (data === 'SC Campaign Profile Rejected') {
      this.Filter = 'SC Campaign Profile Rejected';
    }
    else {
      this.Filter = 'Pending Review';
    }
    this.filterForm.reset();
    this.filterForm.get('user').setValue('')
    this.filterForm.get('sc_type').setValue('')
    this.filterForm.patchValue({
      filter_type: this.userType == 1 ? data : '',
    })
  }

  filterByUser(ev: any) {
    this.selectedUser = ev.target.value;
  }

  messageshow() {
    const fromDate = this.filterForm.get('from').value;
    const toDate = this.filterForm.get('to').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterForm.get('from').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterForm.get('to').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterForm.get('to').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterForm.get('to').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterForm.get('from').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterForm.get('from').setErrors(null);
      this.filterForm.get('to').setErrors(null);
    }

  }
  onItemSelect(item: any) {
    // console.log(item);
  }
  Submitfilter() {
    this.submitted = true;
    if (this.filterForm.invalid) {
      return false;
    } else {
      // if (this.selectedItem && this.selectedItem.length > 0) {
      //   this.filterForm.value.user = this.selectedItem[0].name.split(' - ')[0];
      // } else {
      //   this.filterForm.value.user = '';
      // }
      // const payload = {
      //   batch_id: this.filterForm.value.batch_id || null,
      //   campaignname: this.filterForm.value.campaignname || null,
      //   filter_type: this.filterForm.value.filter_type || null,
      //   from: this.filterForm.value.from || null,
      //   requestid: this.filterForm.value.requestid || null,
      //   sc_request_id: this.filterForm.value.sc_request_id || null,
      //   sc_type: this.filterForm.value.sc_type?.length ? this.filterForm.value.sc_type[0].value : null,
      //   status: this.filterForm.value.status?.length ? String(this.filterForm.value.status[0].Value) : null,
      //   to: this.filterForm.value.to || null,
      //   user: this.selectedItem?.length ? this.selectedItem[0].name.split(' - ')[0] : null
      // };
      this.filterForm.value.user = this.selectedItem?.[0]?.name?.split(' - ')[0] || '';
     this.filterForm.value.status = this.selectedItem1?.[0]?.Value || '';
     this.filterForm.value.sc_type = this.selectedItem2?.[0]?.value || '';
      this.data.appllyFilter(this.filterForm.value).subscribe((res) => {
        if (res.status == 201) {
          // this.SCfilter = res.data;
          this.SCfilter = res.data.filter((item, index, self) => index === self.findIndex((t) => t.id_profile === item.id_profile));
          this.SCfilterCSV = res.data;
          // for (const itemScCampaign of this.SCfilter) {
          //   const sc_campaign_unique_id = itemScCampaign.sc_campaign_unique_id;
          //   const matchingBatchData = this.batchdata.find(
          //     batchItem => batchItem.sc_campaign_unique_id && batchItem.sc_campaign_unique_id.includes(sc_campaign_unique_id)
          //   );
          //   // let matchingRequest = this.SCrequest.find(request => request.profile_id == itemScCampaign.id_profile);
          //   // console.log(matchingRequest , "matched request")
          //   if (matchingBatchData) {
          //     itemScCampaign.batch_id = matchingBatchData.batch_id_unique;
          //     // itemScCampaign.sc_request_id = matchingRequest.sc_request_id;
          //     // itemScCampaign.sc_type = matchingRequest.sc_type;
          //   }
          // }
          if (this.userType == 1) {
            if (this.Filter == 'Pending Review') {
              $('#basic-datatables1').DataTable().clear();
              $('#basic-datatables1').DataTable().destroy();
              this.pending = this.SCfilter;
              this.setStatus(this.pending);
            }
            if (this.Filter == 'Rejected') {
              $('#basic-datatablessc1').DataTable().clear();
              $('#basic-datatablessc1').DataTable().destroy();
              this.rejected = this.SCfilter;
              this.setStatus(this.rejected);
            }
            if (this.Filter == 'Approved') {
              $('#basic-datatablessc3').DataTable().clear();
              $('#basic-datatablessc3').DataTable().destroy();
              this.approved = this.SCfilter;
              this.setStatus(this.approved);
            }
            if (this.Filter == 'Shortcode Request Created') {
              $('#basic-datatablessc4').DataTable().clear();
              $('#basic-datatablessc4').DataTable().destroy();
              this.numbermapped = this.SCfilter;
              this.setStatus(this.numbermapped);
            }
            if (this.Filter == 'SC Campaign Profile Process Started') {
              $('#basic-datatablessc5').DataTable().clear();
              $('#basic-datatablessc5').DataTable().destroy();
              this.process_started = this.SCfilter;
              this.setStatus(this.process_started);
            }
            if (this.Filter == 'SC Campaign Profile Approved') {
              $('#basic-datatablessc6').DataTable().clear();
              $('#basic-datatablessc6').DataTable().destroy();
              this.process_approved = this.SCfilter;
              this.setStatus(this.process_approved);
            }
            if (this.Filter == 'SC Campaign Profile Rejected') {
              $('#basic-datatablesShortsc').DataTable().clear();
              $('#basic-datatablesShortsc').DataTable().destroy();
              this.process_rejected = this.SCfilter;
              this.setStatus(this.process_rejected);
            }
          } else {
            $('#basic-datatables7').DataTable().clear();
            $('#basic-datatables7').DataTable().destroy();
            this.CustomerCampaign = this.SCfilter;
            this.setStatus(this.CustomerCampaign);
          }
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ''
          }, 5000);
        }
      })
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterForm.reset();
    this.filterForm.patchValue({
      filter_type: this.userType === 1 ? this.Filter : ''
    });
    this.filterForm.get('status').setValue('')
    this.filterForm.get('user').setValue('')
    this.filterForm.get('sc_type').setValue('')
    this.GetSCampaign()
    this.Filter = this.Filter;
  }


  downloadCSV() {
    this.Submitfilter();
    setTimeout(() => {
      if (this.SCfilterCSV.length > 0) {
        let NewFilteredRes = this.SCfilterCSV.map((item) => {
          if (this.userType === 1) {
            const { idaccount, customer_name, campaign_name, created_at, status, sc_campaign_unique_id, reject_date, approved_date, updated_at, process_approved_date, process_rejected_date, process_started_date, batch_id_unique, shortcode_number, sc_request_id, sc_type } = item;
            const SAN = 100000000 + idaccount;
            const Customer_Name = customer_name;
            const Status = status;
            const Request_ID = sc_campaign_unique_id;
            const Campaign = campaign_name;
            const reject = new Date(reject_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const approve = new Date(approved_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const process_start = new Date(process_started_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const process_approv = new Date(process_approved_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const process_reject = new Date(process_rejected_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const number_mapped = new Date(updated_at).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const batch = batch_id_unique
            const shortcode = shortcode_number
            const sc_request = sc_request_id
            const shortcode_type = sc_type === 1 ? "Customer Provided Migrated Shortcode" : sc_type === 2 ? "New Random Shortcode" : sc_type === 3 ? "New Vanity Shortcode" : sc_type === 4 ? "Customer Provided New Shortcode" : "";
            const formattedDate = new Date(created_at).toLocaleDateString('en-US', { timeZone: 'UTC' });
            if (this.Filter == 'Pending Review')
              return { SAN, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, Status, Date: formattedDate };
            if (this.Filter == 'Rejected')
              return { SAN, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, Status, 'Created Date': formattedDate, 'Updated Date': reject };
            if (this.Filter == 'Approved')
              return { SAN, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, Status, 'Created Date': formattedDate, 'Updated Date': approve };
            if (this.Filter == 'Shortcode Request Created')
              return { SAN, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, 'SC Request ID': sc_request, 'SC Type': shortcode_type, Status, 'Created Date': formattedDate, 'Updated Date': number_mapped };
            if (this.Filter == 'SC Campaign Profile Process Started')
              return { SAN, 'Batch ID': batch, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, 'SC Request ID': sc_request, 'SC Type': shortcode_type, Status, 'Created Date': formattedDate, 'Updated Date': process_start };
            if (this.Filter == 'SC Campaign Profile Rejected')
              return { SAN, 'Batch ID': batch, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, 'SC Request ID': sc_request, 'SC Type': shortcode_type, Status, 'Created Date': formattedDate, 'Updated Date': process_reject };
            if (this.Filter == 'SC Campaign Profile Approved')
              return { SAN, 'Batch ID': batch, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, 'SC Request ID': sc_request, 'SC Type': shortcode_type, 'Shortcode': shortcode_number, Status, 'Created Date': formattedDate, 'Updated Date': process_approv };
 
 
          } else {
            const { created_at, status, campaign_name, sc_campaign_unique_id } = item;
            const Campaign = campaign_name;
            const Status = status;
            const Request_ID = sc_campaign_unique_id;
            const formattedDate = new Date(created_at).toLocaleDateString('en-US', { timeZone: 'UTC' });
            return { 'SC Campaign ID': Request_ID, 'Campaign Name': Campaign, Status, Date: formattedDate };
          }
        });
        const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
        const workbook: XLSX.WorkBook = { Sheets: { 'ShortCode Campaign': worksheet }, SheetNames: ['ShortCode Campaign'] };
        const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
        this.saveAsExcelFile1(excelBuffer, 'ShortCode Campaign');
      } else {
        this.errMessage = 'No Record Available!';
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    }, 2000);
  }

  private saveAsExcelFile1(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  onSelectAll(e) {
    if (e.target.checked) {
      this.selectedAwait = [];
      this.numbermapped.forEach((ele: any) => {
        ele.isChecked = true;
        this.selectedAwait.push(ele);
      });
    }
    else {
      this.iselectAll = false;
      this.selectedAwait = [];
      this.numbermapped.forEach((ele: any) => {
        ele.isChecked = false;
      });
    }
    if (this.selectedAwait.length == this.numbermapped.length) {
      this.iselectAll = true;
    }
    else {
      this.iselectAll = false;
    }
    this.selectedAwaitCount = this.selectedAwait.length;
    if (this.selectedAwaitCount.length === 0) {
      this.isselet = true;
    } else {
      this.isselet = false;
    }
  }

  onSelectAwait(e, data, idx) {
    if (e.target.checked) {
      this.selectedAwait.push(data);
    } else {
      this.selectedAwait = this.selectedAwait.filter(item => item.id_profile !== data.id_profile);
    }
    if (this.selectedAwait.length === this.numbermapped.length) {
      this.iselectAll = true;
    } else {
      this.iselectAll = false;
    }

    if (this.selectedAwait.length > 0) {
      this.isSelected = true;
    }
    else {
      this.isSelected = false;
    }
    // this.isSelected = this.selectedAwait.length > 0;
    this.selectedAwaitCount = this.selectedAwait.length;
  }

  sendmailid() {
    const selectedCheckboxIds = this.selectedAwait.map(item => item.id_profile);
    let data = {
      requestId: selectedCheckboxIds
    }
    if (confirm("Please click on 'OK' to Submit ")) {
      this.data.sendcsvForNumberMap(data).subscribe((res) => {
        if (res.status == 200) {
          let manageDID = res.data;
          if (manageDID.length > 0) {
            const groupedData = this.groupfiles_and_did(manageDID, res.data1);
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(groupedData);
            const workbook: XLSX.WorkBook = { Sheets: { 'did': worksheet }, SheetNames: ['did'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
            this.saveAsExcelFile(excelBuffer);
          } else {
            this.errMessage = "Data is not Available";
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    } else {
      this.router.navigateByUrl['/shortcode-campaign']
    }
  }

  groupfiles_and_did(data, data2) {
    const groupedData = {};

    data.forEach((entry, index) => {
      const SC_Request_ID = entry.SC_Request_ID || '';

      const Campaign_name = entry.Campaign_Name || '';
      const ShortCode_number = entry.ShortCode_Number || '';
      const Migrated_campaign = entry.Migrated_Campaign || '';
      const Campaign_overview = entry.Campaign_Overview || '';
      const Optoutkeyword = entry.Opt_Out_Keyword || '';
      const OptOutMT = entry.Opt_Out_MT || '';
      const HelpMT = entry.Help_MT || '';
      const email = entry.Email || '';
      const WebURL = entry.Web_URL || '';
      const PhoneNumber = entry.Phone_Number || '';
      const T_Web_Url = entry['T&C_Web_Url'] || '';
      const TC_text = entry['T&C_Text'] || '';
      const Customer_name = entry.Customer_Name || '';
      const Subscription_types = entry.Subscription_Types || '';

      const trimmedMessageType = entry.Message_Types ? entry.Message_Types.toString().trim() : '';
      const trimmedContentType = entry.Content_Types ? entry.Content_Types.toString().trim() : '';
      const trimmedCallToAction = entry.Call_To_Action ? entry.Call_To_Action.trim() : '';
      const trimmedOptInMessage = entry.Opt_In_Message ? entry.Opt_In_Message.trim() : '';
      const trimmedExampleMessage = entry.Example_message ? entry.Example_message.trim() : '';
      const trimmedFilename = entry.Filenames ? entry.Filenames.trim() : '';
      const filePath = entry.Filepaths || '';

      const notes = entry.Notes || '';

      const carrierCoverage = (data2[index] && data2[index].sc_carrier_coverage) || '';

      if (!groupedData[SC_Request_ID]) {
        groupedData[SC_Request_ID] = {
          "Campaign Name": Campaign_name,
          "ShortCode Number": ShortCode_number,
          "Migrated Campaign": Migrated_campaign,
          "Campaign Overview": Campaign_overview,
          "Opt Out MT": OptOutMT,
          "Opt Out Keyword": Optoutkeyword,
          "Help MT": HelpMT,
          "Email": email,
          "Web URL": WebURL,
          "Phone Number": PhoneNumber,
          "T&C Web Url": T_Web_Url,
          "T&C Text": TC_text,
          "Customer Name": Customer_name,
          "Subscription Types": Subscription_types,

          "Carrier Coverage": carrierCoverage,
          "Message Types": trimmedMessageType,
          "Content Types": trimmedContentType,
          "Call To Action": trimmedCallToAction,
          "Opt In Message": trimmedOptInMessage,
          "Example message": trimmedExampleMessage,
          "Filenames": trimmedFilename,
          "Filepaths": filePath,
          "Notes": notes,
        };
      } else {
        console.log("Data Already Present")
      }
    });

    return Object.values(groupedData);
  }


  saveAsExcelFile(csvFile: string): void {
    const selectedCheckboxIds = this.selectedAwait.map(item => item.id_profile);
    var target = environment.SERVER + "sc_sendMail";
    let data = JSON.stringify({
      requestId: selectedCheckboxIds
    })

    const blob = new Blob([csvFile], { type: 'text/csv' });
    const formData = new FormData();
    formData.append('ATTACHMENTS', blob, "file.csv");
    formData.append('data', data)
    const token = sessionStorage.getItem('authkey');
    this.http.post(target, formData, { headers: { "Authorization": `${token}` } })
      .subscribe((res: any) => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.selectedAwait = [];
            this.selectedAwaitCount = '';
            // window.location.reload()
            this.GetSCampaign();
            this.responseMessage = "";
            this.iselectAll = false;
          }, 3000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      }
      );
  }

  approveSC(id: any, number: any, id_profile: any) {
    this.reviewId = id;
    this.scNumber = number;
    this.profileID = id_profile;
    const user = this.Campaign.find(
      (user) => user.sc_campaign_unique_id === this.reviewId,
      (user) => user.shortcode_number === this.scNumber,
      (user) => user.id_profile === this.profileID
    );
    this.user_id = user.iduser;
    this.user_acc = user.idaccount;
    let data = {
      iduser: this.user_id,
      idaccount: this.user_acc,
      id: this.reviewId,
      number: this.scNumber,
      id_profile: this.profileID,

    };

    this.data.approveShortCode(data).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        this.GetSCampaign();
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }

    })
  }

  rejectSC(id: any, number: any, idProfile: any) {
    this.unique_id = id;
    this.scContact = number;
    this.pID = idProfile;
    const user = this.Campaign.find(
      (user) => user.sc_campaign_unique_id === this.unique_id,
      (user) => user.shortcode_number === this.scContact,
      (user) => user.id_profile === this.pID
    );
    this.user_id = user.iduser;
    this.user_acc = user.idaccount;
    let data = {
      iduser: this.user_id,
      idaccount: this.user_acc,
      id: this.unique_id,
      number: this.scContact,
      idProfile: this.pID
    };
    this.data.rejectShortCode(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.GetSCampaign();
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  getDetailID(idacc: any, idu: any, idpro: any, rate: any){
    this.approveIDAcc=idacc,
    this.approveIDUser=idu,
    this.approveID=idpro,
    this.approveRates=rate
  }

  // verifiedSC(idacc: any, idu: any, idpro: any, rate: any) {
  //   const data = {
  //     idaccount: idacc,
  //     iduser: idu,
  //     id: idpro,
  //     rates: rate
  //   };

  //   this.data.approveSCampaign(data).subscribe((res) => {
  //     if (res.status === 201) {
  //       this.responseMessage = res.message;
  //       this.GetSCampaign();
  //       setTimeout(() => {
  //         this.responseMessage = '';
  //       }, 2000);
  //     } else {
  //       this.errMessage = res.message;
  //       setTimeout(() => {
  //         this.errMessage = '';
  //       }, 5000);
  //     }
  //   });
  // }

  verifiedSC() {
    const data = {
      idaccount: this.approveIDAcc,
      iduser: this.approveIDUser,
      id: this.approveID,
      rates: this.approveRates
    };

    this.data.approveSCampaign(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.closeapprove.nativeElement.click();
        this.GetSCampaign();
        setTimeout(() => {
          this.responseMessage = '';
        }, 2000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }


  getdata(idacc: any, idu: any, idpro: any) {
    this.idaccount1 = idacc;
    this.iduser1 = idu;
    this.idprofile1 = idpro;
  }

  rejectedSC() {
    this.submitted = true;
    if (this.rejectForm.invalid) {
      return false;
    }
    const data = {
      idaccount: this.Account_ID ?? this.idaccount1,
      iduser: this.User_ID ?? this.iduser1,
      id: this.idprofile1 ?? this.profile_id,
      reject_text: this.rejectForm.get('reject_text').value,
    };
    this.data.rejectSCampaign(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.reject.nativeElement.click();
        this.GetSCampaign();
        setTimeout(() => {
          this.responseMessage = '';
        }, 2000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  OnReset() {
    this.submitted = false;
    this.rejectForm.reset();
    this.user1 = []
    this.profile_id = '';
    this.getCarrier();
  }

  truncatenotification(subject: string, maxLength: number): string {
    if (subject && subject.length > maxLength) {
      return subject.substring(0, maxLength) + '...';
    } else {
      return subject;
    }
  }

  ngOnDestroy() {
    this.closeModal.nativeElement.click();
    this.reject.nativeElement.click();
    this.closeapprove.nativeElement.click();
  }

}