import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { FormBuilder } from '@angular/forms';
import { SignuptemplateService } from '../signuptemplate.service';
declare var $: any;
@Component({
  selector: 'app-emailtemplatedetails',
  templateUrl: './emailtemplatedetails.component.html',
  styleUrls: ['./emailtemplatedetails.component.css']
})
export class EmailtemplatedetailsComponent extends AppComponentClass<any, any> {
  page = 1;
  field: any;
  header: any;
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  searchText = { count: 0 };
  filtre: string;
  listdata: any;
  errMessage: any = "";
  resMessage: any = "";
  responseMessage: any;

  constructor(public data: SignuptemplateService,

    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) {

    super(data, router, fb);

  }

  ngOnInit(): void {


    this.data.getEmailTemplates().subscribe(res => {
      if (res.status == 200) {
        this.listdata = res.data;
        $('#basic-datatables').DataTable().clear();
				$('#basic-datatables').DataTable().destroy();
        $.getScript('./assets/table.js');
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }
  onToggle(event, id) {
    this.data.updateStatus(event.checked, id).subscribe(res => {
      console.log(res);
      
      if (res.status == 201) {
        this.ngOnInit();
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    })
  }

  onDelete(idemail_template) {
    if (confirm("Are you sure you want to delete data!")) {
      this.data.deleteEmailTempalte(idemail_template).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.ngOnInit();
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    } else {
      "Cancel!"
    }
  }

}
