import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { AngularEditorConfig } from '@kolkov/angular-editor';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { SignuptemplateService } from '../signuptemplate.service';

@Component({
  selector: 'app-factorauthentication',
  templateUrl: './factorauthentication.component.html',
  styleUrls: ['./factorauthentication.component.css']
})
export class FactorauthenticationComponent extends AppComponentClass<any, any> {
  factorauthenticationForm: FormGroup;
  submitted: boolean = false;
  message = '';
  id2faTemplate: any;
  twofaTemplate: any = {};
  errMessage: any = '';
  responseMessage: any = '';

  constructor(public data: SignuptemplateService,

    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) {

    super(data, router, fb);

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.id2faTemplate = params.get('id');
      if (this.id2faTemplate) {
        this.data.get2FATemplate(this.id2faTemplate).subscribe(res => {
          if (res.status == 200) {
            if (res.data.length > 0) {
              this.twofaTemplate = res.data[0];
              this.factorauthenticationForm.patchValue({
                id2fa_template: this.twofaTemplate.id2fa_template,
                otp_digit: this.twofaTemplate.otp_digit,
                type: this.twofaTemplate.type,
                body: this.twofaTemplate.body
              });
            }
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        })
      }
    })

  }

  ngOnInit(): void {


    this.factorauthenticationForm = this.fb.group({
      id2fa_template: [''],
      type: ['', [Validators.required]],
      otp_digit: ['', [Validators.required]],
      body: ['', [Validators.required]],
    });
  }



  click1(event: any) {
    this.message = this.factorauthenticationForm.value.body + event.target.value;

    this.factorauthenticationForm.patchValue({
      body: this.message
    });
  }

  click2(event: any) {
    this.message = this.factorauthenticationForm.value.body + event.target.value;

    this.factorauthenticationForm.patchValue({
      body: this.message
    });
  }

  click3(event: any) {
    this.message = this.factorauthenticationForm.value.body + event.target.value;

    this.factorauthenticationForm.patchValue({
      body: this.message
    });
  }
  click4(event: any) {
    this.message = this.factorauthenticationForm.value.body + event.target.value;

    this.factorauthenticationForm.patchValue({
      body: this.message
    });
  }

  click5(event: any) {
    this.message = this.factorauthenticationForm.value.body + event.target.value;

    this.factorauthenticationForm.patchValue({
      body: this.message
    });

  }

  onSubmit() {
    this.submitted = true;
    if (this.factorauthenticationForm.value.id2fa_template) {
      console.log(this.factorauthenticationForm.value);
      this.data.update2FATemplate(this.factorauthenticationForm.value).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.router.navigateByUrl('/signup-template/factor-authentication-details');
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    } else {
      this.data.twofaTemaplate(this.factorauthenticationForm.value).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          this.router.navigateByUrl('/signup-template/factor-authentication-details');
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        } else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  onEdit(data: any) { }

}




