import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { SignuptemplateService } from '../signuptemplate.service';
declare var $: any;

@Component({
  selector: 'app-mms',
  templateUrl: './mms.component.html',
  styleUrls: ['./mms.component.css']
})
export class MmsComponent implements OnInit {
  listdata: any;
  errMessage: string;
  responseMessage: any;
  mmsTestForm: FormGroup;
  submitted: boolean = false;
  isSelected: Boolean = false;


  constructor(public data: SignuptemplateService, public fb: FormBuilder) { }

  ngOnInit(): void {
    this.mmsTestForm = this.fb.group({
      FROM: new FormControl('', [Validators.required]),
      TO: new FormControl('', [Validators.required]),
      template: new FormControl('', [Validators.required]),
    });

    this.data.getmms().subscribe(res => {
      if (res.status == 200) {
        this.listdata = res.data;
        $.getScript('./assets/table.js');
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

  }

  onDelete(idmms_template) {
    $('#basic-datatables').DataTable().clear();
    $('#basic-datatables').DataTable().destroy();
    if (confirm("Are you sure you want to delete this Template!")) {
      this.data.delete_mms(idmms_template).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.ngOnInit();
        } else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      })
    } else {
      "Cancel!"
    }
  }

  onReset(){
    this.submitted = false;
  }

  onSubmit() {
    if (this.mmsTestForm.invalid) {
      this.submitted = true;
      return false;
    }
    else {
      this.data.sendMMSTemplate(this.mmsTestForm.value).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.submitted = false;
          $('#exampleModal').modal('hide');
          this.ngOnInit();
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

}
