import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { SignuptemplateService } from '../signuptemplate.service';
import { InboundService } from 'src/app/inbound/inbound.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
  selector: 'app-mmstemplate',
  templateUrl: './mmstemplate.component.html',
  styleUrls: ['./mmstemplate.component.css']
})
export class MmstemplateComponent implements OnInit {

  mmsTemplateForm: FormGroup;
  submitted: boolean = false;
  errMessage: any = '';
  responseMessage: any = '';
  idMMStemplate: any;
  mmsTemplate: any = {};
  type: string;
  file: File | any;
  distext: string;
  distype: string;
  actvt: any;
  actvf: any;
  imagePreview: any;
  listdata: any;
  textfile: string;
  mediaFiles: any = [];
  userType: any
  featureServiceData: any;
  isDisabledServiceStatus: boolean;
  serviceMessage: any = 'MMS service has been suspended. More information please contact support';
  dropdownSettings: IDropdownSettings = {};
  dropdownSettings1: IDropdownSettings = {};
  dids: any = '';
  selectedItems: any = '';
  selectedItem = []

  constructor(public data: SignuptemplateService, public fb: FormBuilder, private route: ActivatedRoute, public router: Router, private userService: UsermanagementService, private inboundService: InboundService) {

  }

  ngOnInit(): void {
    this.userService.getfeatureServiceStatus().subscribe(res => {
      this.featureServiceData = res.data.find(x => x.fs_id == '1');
      if (this.featureServiceData !== undefined && this.featureServiceData.as_status == '1') {
        this.isDisabledServiceStatus = false;

      } else {
        this.isDisabledServiceStatus = true;
        this.showMsg();
      }
    });

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idMMStemplate = params.get('id');
      if (this.idMMStemplate) {
        this.data.getmms_id(this.idMMStemplate).subscribe(res => {
          if (res.status == 200) {
            if (res.data.length > 0) {
              this.mmsTemplate = res.data[0];
              this.imagePreview = this.mmsTemplate.file_path;
              this.mmsTemplateForm.patchValue({
                idmms_template: this.mmsTemplate.idmms_template,
                name: this.mmsTemplate.name,
                type: this.mmsTemplate.type,
                body: this.mmsTemplate.body,
                file_path: this.mmsTemplate.file_path

              });
            }
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        })
      }
    })
    this.mmsTemplateForm = this.fb.group({
      FROM: ['', [Validators.required]],
      TO: ['', [Validators.required]],
      //BODY: ['',[Validators.required, Validators.pattern(/^[^\s].*$/)]],
      BODY: [''],
      mediaID: ['', [Validators.required]],
    });

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'did',
      textField: 'did',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings1 = {
      singleSelection: true,
      idField: 'name',
      textField: 'nameMediaID',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.inboundService.onGetBuySMSDids().subscribe(res => {
      this.dids = res.data;
    }, err => {
      console.log(err);
    })

    if (this.userType != 1) {
      this.mediaFilesDrop()
    } else {
      this.adminmediaFilesDrop()
    }
  }

  getStretegy(event) {
    this.mmsTemplateForm.patchValue({
      dropdownSettings: event.did

    });
    this.selectedItems = [event.did];
  }

  adminmediaFilesDrop() {
    this.data.getAllMmsMediaFiles().subscribe(res => {
      if (res.status == 200) {
        this.mediaFiles = res.data.sort((a, b) => a.mediaID.localeCompare(b.mediaID));
        this.mediaFiles = res.data.map(item => ({
          ...item,
          nameMediaID: `${item.mediaID} - ${item.name}`
        })
        )
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  mediaFilesDrop() {
    this.data.getMmsMediaFiles().subscribe(res => {
      if (res.status == 200) {
        // this.mediaFiles = res.data
        this.mediaFiles = res.data.sort((a, b) => a.mediaID.localeCompare(b.mediaID));
        this.mediaFiles = res.data.map(item => ({
          ...item,
          nameMediaID: `${item.mediaID} - ${item.name}`
        })
        )
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  onFilePicked(event: Event) {
    const file: File = (event.target as HTMLInputElement).files[0];
    this.file = file;
    const reader = new FileReader();
    reader.readAsDataURL(file)
  }

  onSubmit() {
    this.submitted = true;
    if (this.mmsTemplateForm.invalid) {
      // if (this.file == null || this.file == undefined) {
      //   this.errMessage = "File is required";
      //   setTimeout(() => {
      //     this.errMessage = "";
      //   }, 5000);
      // }
      return false;
    }
    else {
      //this.data.postmms(this.mmsTemplateForm.value, this.file).subscribe(response => {
      const payload = {
        // FROM : this.mmsTemplateForm.value.FROM,
        FROM: this.selectedItems[0],
        TO: this.mmsTemplateForm.value.TO,
        mediaID: this.mmsTemplateForm.value.mediaID,
        BODY: this.mmsTemplateForm.value.BODY,

      }

      // this.data.postmms(this.mmsTemplateForm.value).subscribe(response => {
      this.data.postmms(payload).subscribe(response => {
        if (response.status == 201) {
          this.onReset();
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.router.navigateByUrl("/signup-template/mms-template");
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  onReset() {
    this.submitted = false;
    this.mmsTemplateForm.reset();
    this.mmsTemplateForm.get('mediaID').setValue('')
    this.mmsTemplateForm.get('BODY').setValue('')
  }
  truncatenotification(subject: string, maxLength: number): string {
    return subject.length > maxLength
      ? subject.substring(0, maxLength) + '..'
      : subject;
  }
  showMsg() {
    this.errMessage = this.serviceMessage;
    setTimeout(() => {
      this.errMessage = "";
    }, 5000);
  }
}
