import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { environment } from 'src/environments/environment';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { formatWithOptions } from 'node:util';
import { AnyARecord } from 'node:dns';
@Injectable({
  providedIn: 'root'
})
export class SignuptemplateService extends AppService<any> {

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });

  constructor(public http: HttpClient) {
    super(http)
  }

  @LoaderEnabled()
  getEmailTemplate(idemail_template): Observable<any> {
    let apiUrl = environment.SERVER + 'email-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders, params: { idemail_template: idemail_template } });
  }

  @LoaderEnabled()
  getEmailTemplates(): Observable<any> {
    let apiUrl = environment.SERVER + 'email-templates';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }

  @LoaderEnabled()
  emailTemplate(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + 'email-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiUrl, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  deleteEmailTempalte(idemail_template): Observable<any> {
    let apiUrl = environment.SERVER + 'email-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { idemail_template: idemail_template } });
  }

  @LoaderEnabled()
  updateStatus(data?: any, id?: any): Observable<any> {
    let data1 = { status: data, id: id };
    let apiUrl = environment.SERVER + 'email-template-status';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiUrl, data1, { headers: httpheaders });
  }

  @LoaderEnabled()
  updateEmailTemplate(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + 'email-template';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiUrl, data, { headers: httpheaders });
  }

  @LoaderEnabled()
  getSmsTemplate(idsms_template): Observable<any> {
    let apiUrl = environment.SERVER + 'sms-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders, params: { idsms_template: idsms_template } });
  }

  @LoaderEnabled()
  getSmsTemplates(): Observable<any> {
    let apiUrl = environment.SERVER + 'sms-templates';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }
  @LoaderEnabled()
  updateStatusSMS(data?: any, id?: any): Observable<any> {
    let data1 = { status: data, id: id };
    let apiUrl = environment.SERVER + 'sms-template-status';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiUrl, data1, { headers: httpheaders });
  }
  @LoaderEnabled()
  updateSmsTemplate(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + "sms-template";
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiUrl, data, { headers: httpheaders });
  }
  @LoaderEnabled()
  twofaTemaplate(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiUrl, data, { headers: httpHeaders });
  }
  @LoaderEnabled()
  get2FATemplate(id2fa_template): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders, params: { id2fa_template: id2fa_template } });
  }
  @LoaderEnabled()
  get2FATemplates(): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-templates';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }
  @LoaderEnabled()
  update2FATemplate(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-template';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiUrl, data, { headers: httpheaders });
  }
  @LoaderEnabled()
  delete2FATemplate(id2fa_template): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { id2fa_template: id2fa_template } });
  }

  @LoaderEnabled()
  update_mms(mmsTemplateForm: any, file: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("data", JSON.stringify(mmsTemplateForm));
    formData.append("ATTACHMENT", file);
    const apiURL = environment.SERVER + 'update_mms';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.put(apiURL, formData, { headers: httpHeaders });
  }

  // @LoaderEnabled()
  // postmms(mmsTemplate: any, file: File | any): Observable<any> {
  //   const formData = new FormData();
  //   formData.append("ATTACHMENT", file);
  //   formData.append("data", JSON.stringify(mmsTemplate));
  //   const apiURL = environment.SERVER + 'post_mms';
  //   let httpHeaders = new HttpHeaders({
  //   });
  //   return this.http.post(apiURL, formData, { headers: httpHeaders });
  // }

  /* @LoaderEnabled()
  postmms(mmsTemplate: any, file: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("ATTACHMENT", file);
    formData.append("data", JSON.stringify(mmsTemplate));
    const apiURL = environment.SERVER + 'mms';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.post(apiURL, formData, { headers: httpHeaders });
  } */

  @LoaderEnabled()
  postmms(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + 'mmsbymedia';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiUrl, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  getmms(): Observable<any> {
    let apiUrl = environment.SERVER + 'getmms';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }

  @LoaderEnabled()
  getmms_id(idmms_template): Observable<any> {
    let apiUrl = environment.SERVER + 'getmms_id';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders, params: { idmms_template: idmms_template } });
  }

  @LoaderEnabled()
  delete_mms(idmms_template): Observable<any> {
    let apiUrl = environment.SERVER + 'delete_mms';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { idmms_template: idmms_template } });
  }

  @LoaderEnabled()
  sendMMSTemplate(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'mms';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  getMmsMediaFiles(): Observable<any> {
    let apiUrl = environment.SERVER + 'listMmsMedia';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }

  @LoaderEnabled()
  getAllMmsMediaFiles(): Observable<any> {
    let apiUrl = environment.SERVER + 'listallmmsmedia';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }

}
