import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { SmsService } from '../sms.service';
declare var $: any;

@Component({
  selector: 'app-addfavoice',
  templateUrl: './addfavoice.component.html',
  styleUrls: ['./addfavoice.component.css']
})
export class AddfavoiceComponent implements OnInit {
  @ViewChild('createmodal') createmodal: ElementRef;
  factorauthenticationForm: FormGroup;
  submitted: boolean = false;
  message = '';
  id2faTemplate: any;
  twofaTemplate: any = {};
  errMessage: any = '';
  responseMessage: any = '';
  OrginalId2faTemplate: String

  constructor(public data:SmsService,
    
    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) 
    {
      this.route.paramMap.subscribe((params: ParamMap) => {
        this.id2faTemplate = params.get('id');
        this.OrginalId2faTemplate =this.id2faTemplate
        if (this.id2faTemplate) {
          this.data.get2FATemplate(this.id2faTemplate).subscribe(res => {
            if (res.status == 200) {
              if (res.data.length > 0) {
                this.twofaTemplate = res.data[0];
                this.factorauthenticationForm.patchValue({
                  id2fa_template: this.twofaTemplate.id2fa_template,
                  otp_digit: this.twofaTemplate.otp_digit,
                  type: this.twofaTemplate.type,
                  body: this.twofaTemplate.body
                });
              }
            } else {
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          })
        }
      })
     }

  ngOnInit(): void {
    this.factorauthenticationForm = this.fb.group({
      id2fa_template: [''],
      type: [''],
      otp_digit: ['', [Validators.required]],
      body: ['', [Validators.required]],
      tmpType: ['voice']
    });
  }
  // click1(event: any) {
  //   this.message = this.factorauthenticationForm.value.body + event.target.value;

  //   this.factorauthenticationForm.patchValue({
  //     body: this.message
  //   });
  // }

  // click2(event: any) {
  //   this.message = this.factorauthenticationForm.value.body + event.target.value;

  //   this.factorauthenticationForm.patchValue({
  //     body: this.message
  //   });
  // }

  // click3(event: any) {
  //   this.message = this.factorauthenticationForm.value.body + event.target.value;

  //   this.factorauthenticationForm.patchValue({
  //     body: this.message
  //   });
  // }

  click4(event: any) {
    this.message = this.factorauthenticationForm.value.body + event.target.value;

    this.factorauthenticationForm.patchValue({
      body: this.message
    });
  }

  // click5(event: any) {
  //   this.message = this.factorauthenticationForm.value.body + event.target.value;

  //   this.factorauthenticationForm.patchValue({
  //     body: this.message
  //   });

  // }
  
  onSubmit() {
    this.submitted = true;
    if(this.factorauthenticationForm.invalid){
      return false;
    } 
    else {
      if (this.factorauthenticationForm.value.id2fa_template) {
        this.data.update2FATemplate(this.factorauthenticationForm.value).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;           
            setTimeout(() => {
              this.responseMessage = "";
              this.router.navigateByUrl('/sms/2fa-voicedetails');
            }, 5000);
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      } else {
        this.data.twofaTemaplate(this.factorauthenticationForm.value).subscribe(response => {
          if (response.status == 201) {
            this.responseMessage = response.message;
            this.reset()
            const compModal = document.getElementById('createmodal');
            $(compModal).modal({ backdrop: 'static', keyboard: false });
            $(compModal).modal('show');
            // this.router.navigateByUrl('/sms/2fa-voicedetails');
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          } else {
            this.errMessage = response.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
    }
  }

  reset() {
    this.factorauthenticationForm.reset({
      id2fa_template: this.OrginalId2faTemplate,
      tmpType: 'voice',
      body: ''
    });
    this.submitted = false;
  }

  ModalClose() {
    const modal = document.getElementById('createmodal');
    if (modal) {
      $(modal).modal('hide');
      $('.modal-backdrop').remove();
    }
  }

  ngOnDestroy() {
    this.createmodal.nativeElement.click();
  }
 
}
