import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, Router } from '@angular/router';
import { Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { SmsService } from '../sms.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
  selector: 'app-factorauthenticationdetails',
  templateUrl: './factorauthenticationdetails.component.html',
  styleUrls: ['./factorauthenticationdetails.component.css']
})
export class FactorauthenticationdetailsComponent implements OnInit {
  // test2famodal
  @ViewChild('test2famodal') test2famodal: ElementRef;
  page = 1;
  field: any;
  header: any;
  listdata: any = [];
  errMessage: string;
  responseMessage: any;
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  searchText = { count: 0 };
  filtre: string;
  type: any
  isOtpEnable: Boolean = false;
  countDown;
  counter: any;
  otpForm: FormGroup;
  tick = 1000;
  isCounter: Boolean = false;
  submitted: boolean = false;
  template: any;
  pShow = false;
  featureServiceData: any;
  isDisabledServiceStatus: boolean;
  dropdownSettings: IDropdownSettings = {};
  // selectedItem: any = [];
  bodyArray = []; 


  constructor(private data: SmsService,private user: UsermanagementService,
    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) {
  }

  ngOnInit(): void {
    this.otpForm = this.fb.group({
      FROM: new FormControl('', [Validators.required, Validators.minLength(10)]),
      TO: new FormControl('', [Validators.required, Validators.minLength(10)]),
      template: new FormControl('', [Validators.required]),
      otp: new FormControl('')
    });
    this.user.getfeatureServiceStatus().subscribe(res => {
      this.featureServiceData = res.data.find(x => x.fs_id == '1');
      if(this.featureServiceData!==undefined && this.featureServiceData.as_status=='1')
      {
       this.isDisabledServiceStatus=false;
      }else{
       this.isDisabledServiceStatus=true;
       this.showMsg();
      }
    });
    this.get2FATemData();

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'id',
      textField: 'body',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

  }

  get2FATemData() {
    this.data.get2FATemplates('sms').subscribe(res => {
      if (res.status == 200) {
        this.listdata = res.data;
    
        this.bodyArray = res.data.map((item) => ({
          id: item.id2fa_template,
          body: item.body
        }));
        console.log("Populated bodyArray:",  this.listdata);
      
        $('#basic-datatabless2').DataTable().clear();
        $('#basic-datatabless2').DataTable().destroy();
        $.getScript('./assets/table.js');
        this.listdata.forEach(element => {
          element.pShow = false;
          element.pswd = "password";
        });
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    })
  }

  onClode() {
    this.otpForm.reset();
    //location.reload();
    this.submitted = false;
  }
  onGenerateOtp() {
    this.submitted = true;
    if (this.otpForm.value.template == 'null') {

      this.errMessage = "There is no Template Key for this Template!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
      return false;
    }

    if (this.otpForm.invalid) {
      return false;
    }
    else {
      this.data.SendOtpBySMS(this.otpForm.value).subscribe(res => {
        if (res.status == 200) {
          this.otpForm.patchValue({template:res.result[0].session_id}) 
          this.counter = 120;
          this.isCounter = false;
          this.isOtpEnable = true;
          this.countDown = Observable.timer(0, this.tick)
            .take(this.counter)
            .map(() => {
              if (this.counter <= 1) {
                this.isOtpEnable = true;
                this.isCounter = true;
              }
              return --this.counter
            });
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.isOtpEnable = false;
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  onDelete(id2fa_template) {
    if (confirm("Are you sure you want to delete data!")) {
      this.data.delete2FATemplate(id2fa_template).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.get2FATemData();
          // this.ngOnInit();
        } else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      })
    } else {
      "Cancel!"
    }
  }

  verifyOtp() {
    this.otpForm.value.SessionId = this.otpForm.value.template;
    this.otpForm.value.OTP = this.otpForm.value.otp;
    this.data.verifySMSOtp(this.otpForm.value).subscribe(res => {
      if (res.status == 200) {
        this.resetModal();
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  resetModal() {
    $("#exampleModal").hide();
    $(".modal-backdrop").remove();
    this.isOtpEnable = false;
    this.otpForm.reset();
    this.submitted = false;
    this.otpForm.get('template').setValue('');
    this.otpForm.get('otp').setValue('');
  }

  setDefault(id2fa_template) {
    if (confirm("Are You Sure ?")) {
      this.data.setDefaultTemplate(id2fa_template).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.ngOnInit();
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
    else {
      return
    }
  }

  default() {
    this.listdata.find(element => {
      if (element.default == '1') {
        this.template = element.template_key;
      }
    })
  }

  textMessageFunc(msgText) {
    this.responseMessage = "Copied to Clipboard";
    setTimeout(() => {
      this.responseMessage = "";
    }, 5000);
  }

  keyToggle(id) {
    this.listdata.forEach(element => {
      if (element.template_key == id) {
        if (element.pswd == 'password') {
          element.pswd = 'text';
          element.pShow = true;
        } else {
          element.pswd = 'password';
          element.pShow = false;
        }
      }
    });
  }
  showMsg()
	{
		this.errMessage = "2FA SMS service has been suspended. More information please contact support";
		setTimeout(() => {
			this.errMessage = "";
		}, 5000);
	}
  truncatenotification(subject: string, maxLength: number): string {
    return subject.length > maxLength ? subject.substring(0, maxLength) + '..' : subject;
  }

  
toggleDescription(data, property) {
  data[property] = !data[property];
}

  ngOnDestroy() {
    this.test2famodal.nativeElement.click();
  }
}
