import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { SmsService } from '../sms.service';
import { inboundsms, inboundsmsForm } from '../sms.class';
@Component({
  selector: 'app-inboundsms',
  templateUrl: './inboundsms.component.html',
  styleUrls: ['./inboundsms.component.css']
})
export class InboundsmsComponent extends AppComponentClass<inboundsms, inboundsmsForm>{
  label : any;
  label2 : any;
  header:any;
  rowdata:any;
  p: number = 1;
    page = 1;
    count = 0;
    tableSize = 5;
    tableSizes = [ 5, 9, 12];
    filterTerm: string
    inboundsmsForm: FormGroup;
  public submitted : boolean = false;
  constructor(public data: SmsService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  ngOnInit(): void {
    this.data.get_smsconf().subscribe((result)=>{
      this.header = result[0].headers_details,
      this.rowdata = result[0].product_details
     
     this.label2 = result[2];
     
       console.log(result);
     })


      // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new inboundsmsForm(res);
				this.keyfield = res.id;
				this.inboundsmsForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new inboundsmsForm(null);
				this.keyfield = -1;
				this.inboundsmsForm = this.cdata.makeform(this.fb);
			}
		});
 
   }
 
   onTableSizeChange(event): void {
     this.tableSize = event.target.value;
        this.page = 1;
     } 
     
     onTableDataChange(event){
        this.page = event;
     }  
   
     onSubmit() {
      console.log("event task save");
      this.submitted = true;
  
      if (this.inboundsmsForm.invalid) {
        return false;
      } else {
        console.log("submit data::", this.cdata);
        if (this.cdata.saveForm(this.inboundsmsForm)) {
          console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
          if (this.keyfield == -1) {
            this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
              console.log("Response data::\n", res);
              this.ngOnInit();
            });
          } else {
            this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
              console.log("Response data::\n", res);
              this.ngOnInit();
            });
          }
        }
      }
    }
 }