import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { SmsService } from '../sms.service';
import { Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { ip, ipForm } from '../sms.class';

declare var $:any;
@Component({
  selector: 'app-ip-whitelists',
  templateUrl: './ip-whitelists.component.html',
  styleUrls: ['./ip-whitelists.component.css']
})
export class IpWhitelistsComponent extends AppComponentClass<ip, ipForm> {
	label:any;
	header:any;
	rowdata:any;
	p: number = 1;
	page = 1;
	count = 0;
	tableSize = 5;
	tableSizes = [ 5, 9, 12];
	filterTerm: string;
  public show: boolean = false;
  public show1: boolean = false;
  public buttonName: any = "Add";
  public ipForm : FormGroup;
  public submitted : boolean = false;
  public collection : any;
  public heading = [];
  public main_heading = "";

  constructor(public data: SmsService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  ngOnInit(): void {

    // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new ipForm(res);
				this.keyfield = res.id;
				this.ipForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new ipForm(null);
				this.keyfield = -1;
				this.ipForm = this.cdata.makeform(this.fb);
			}
		});

    this.data.get_ipwhitelist().subscribe((result)=>{
      this.header = result[0].headers_details;
	
	  this.rowdata = result[0].ip_details;
	  this.label = result[1];
      console.log(result);
    })

  
  }

  click(){
	  this.show1 = !this.show1;
  }

 toggle() {
    this.show = !this.show;

    // CHANGE THE NAME OF THE BUTTON.
    if (this.show) this.buttonName = "Close";
    else this.buttonName = "Add";
  }

    // @to edit the record
	editRow(rowdata: any): void {
		this.show = true
		this.Edit(rowdata)
	}

  // @to save/update form data
	onSubmit() {
		console.log("event task save");
		this.submitted = true;

		if (this.ipForm.invalid) {
			return false;
		} else {
			console.log("submit data::", this.cdata);
			if (this.cdata.saveForm(this.ipForm)) {
				console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				}
			}
		}
	}

	onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
	
	
	  } 
	  
	  onTableDataChange(event){
		this.page = event;
		
	  }  
}
