import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { MatSnackBar } from '@angular/material/snack-bar'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { SmsService } from '../sms.service';
import { Validators, FormBuilder, FormGroup, AbstractControl, ValidatorFn } from '@angular/forms';
import { BehaviorSubject, Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { DatePipe, formatDate } from '@angular/common';
import { saveAs } from 'file-saver';
import * as XLSX from 'xlsx';
import { MdrsComponent } from '../mdrs/mdrs.component';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
	selector: 'app-mms-mdr',
	templateUrl: './mms-mdr.component.html',
	styleUrls: ['./mms-mdr.component.css']
})
export class MmsMDRComponent implements OnInit {
	@ViewChild('viewdetails') viewdetails: ElementRef;
	@ViewChild('downloadreportmodal') downloadreportmodal: ElementRef;

	show_filter: boolean = false;
	show_daily: boolean = false;
	editData?: Observable<any>;
	searchText = { count: 0 };
	filtre: string;
	label: Observable<any>;
	header: any;
	rowdata: any;
	p: number = 1;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	filterTerm: string
	snackBar: any;
	public mmdrsForm: FormGroup;
	public summerymmsForm: FormGroup;
	public submitted: boolean = false;
	filterMDR: any = [];
	singleMDR: any = [];
	isOutbound$ = new BehaviorSubject<Boolean>(false);
	isOutbound = this.isOutbound$.asObservable();
	username: any;
	userlist: any = [];
	isAdmin: Boolean = false;
	errMessage: any = "";
	EXCEL_TYPE = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
	EXCEL_EXTENSION = '.xlsx';
	monthNameList: any = [];
	filterSummaryMms: any = [];
	currentDate: any;
	startdate: any;
	lastdate: any;
	exportfile: any = [];
	userType: any;
	public downloadreport: FormGroup;
	submitteddownload: boolean;
	responseMessage: any;
	dropdownSettings: IDropdownSettings = {};
	dropdownSetting: IDropdownSettings = {};
	closeDropdownSelection = true;
	directionOptions: any[] = [];
	directionOptions1: any[] = [];
	dropdownSettingsd: IDropdownSettings = {};
	dropdownSettingsd1: IDropdownSettings = {};
	constructor(public data: SmsService, public router: Router,
		public fb: FormBuilder, msg: MatSnackBar,
		private userService: UsermanagementService,
		private datePipe: DatePipe) {

	}

	ngOnInit(): void {
		this.currentDate = new Date();
		this.currentDate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 1));
		const sValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.startdate = sValue;

		this.lastdate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 6));
		const lValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.lastdate = lValue;

		this.userService.getidAccount().subscribe(res => {
			// this.userlist = res.data[0];
			this.userlist = res.data.map((user)=>({
				iduser: `${user.iduser}-${user.idaccount}`,
				userlist: `${user.san} - ${user.first_name} ${user.last_name}`, 
			}))
			// $.getScript('./assets/table.js');
		}, err => {
			console.log(err.message);
		});

		let isLoggedIn = sessionStorage.getItem("isLoggedIn");
		let user = JSON.parse(isLoggedIn);
		this.userType = user.type;
		this.username = user.username;
		if (user.type == '1') {
			this.isAdmin = true;
		}
		else {
			this.isAdmin = false;
		}

		this.mmdrsForm = this.fb.group({
			from_date: [this.startDate()],
			to_date: [this.current_datetime()],
			from_number: [''],
			to_number: [''],
			direction: [''],
			iduser: [''],
			fType: ['']
		});
		this.summerymmsForm = this.fb.group({
			to_date: ['', [Validators.required]],
			from_date: ['', [Validators.required]],
			directionSummery: [''],
			fType: [''],
			iduser: ['']
			// Status: [''],
		});

		this.summerymmsForm.patchValue({
			to_date: this.startdate,
			from_date: this.lastdate,
		});

		this.data.get_mdrs().subscribe((result) => {
			this.label = result[1];
			this.header = result[0].headers_details;
			// if (this.userType === 1) {
			// 	this.header = result[0].headers_details;
			// } else {
			// 	this.header = result[0].headers_details.filter(column => column !== 'SAN');
			// }
			this.rowdata = result[0].product_details;
		});

		this.data.getMMSMDR(JSON.stringify(this.mmdrsForm.value)).subscribe(response => {
			if (response.data) {
				this.filterMDR = response.data;
				// let filterMDR1 = response.data
				// this.filterMDR = filterMDR1.data;
				$('#basic-datatablesMess').DataTable().clear();
				$('#basic-datatablesMess').DataTable().destroy();
				$.getScript('./assets/table.js');
			}
		});
		this.summeryMms()

		this.downloadreport = this.fb.group({
			from_date: [[this.startDate()]],
			to_date: [[this.current_datetime()]],
			directions: [''],
			// status: [''],
			fromnumber: [''],
			tonumber: [''],
			type: [2]
		})


		this.dropdownSettings = {
			singleSelection: true,
			idField: 'iduser',
			textField: 'userlist',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};
		this.dropdownSetting = {
			singleSelection: true,
			idField: 'iduser',
			textField: 'userlist',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSettingsd = {
			singleSelection: true,
			idField: 'id',
			textField: 'name',
			allowSearchFilter: false,
			closeDropDownOnSelection: true
		};
		this.directionOptions = [
			{ id: 'Inbound', name: 'Inbound' },
			{ id: 'Outbound', name: 'Outbound' },
			{ id: 'Both', name: 'Both' }
		];

		this.dropdownSettingsd1 = {
			singleSelection: true,
			idField: 'id',
			textField: 'option',
			allowSearchFilter: false,
			closeDropDownOnSelection: true
		};
		this.directionOptions1 = [
			{ id: 'Inbound', option: 'Inbound' },
			{ id: 'Outbound', option: 'Outbound' }
		];
	}

	onMMdrsGet() {
		this.submitted = true;
		this.mmdrsForm.patchValue({
			fType: ""
		})
		if (this.mmdrsForm.invalid) {
			// $('#basic-datatablesMess').DataTable().destroy();
			return
		}
		else {
			this.mmdrsForm.value.direction = this.mmdrsForm.value.direction[0]?.id || ''
			this.mmdrsForm.value.iduser = this.mmdrsForm.value.iduser[0]?.iduser || ''
			this.filterMDR = [];
			this.data.getMMSMDR(JSON.stringify(this.mmdrsForm.value)).subscribe(response => {
				if (response.status == 201) {
					this.filterMDR = response.data;
					// let filterMDR1 = response.data
					// this.filterMDR = filterMDR1.data;
					$('#basic-datatablesMess').DataTable().clear();
					$('#basic-datatablesMess').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.filterMDR = [];
					$('#basic-datatablesMess').DataTable().clear();
					$('#basic-datatablesMess').DataTable().destroy();
					$.getScript('./assets/table.js');
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	getFullMdr(data) {
		this.singleMDR = data;
		if (this.singleMDR.Direction == "outbound") {
			this.isOutbound$.next(true);
		}
		else {
			this.isOutbound$.next(false);
		}
	}

	exportFile(e: any) {
        let fType = "filter";
        this.mmdrsForm.patchValue({
          fType: fType
        })
        this.summerymmsForm.patchValue({
          fType: fType
        })
       
        if (e == 'message') {
          // addchange
          const exportFormValues = {...this.mmdrsForm.value};
          exportFormValues.direction = exportFormValues.direction[0]?.id || '';
          exportFormValues.iduser = exportFormValues.iduser[0]?.iduser || '';
         this.exportfile = [];
          this.data.getMMSMDR(JSON.stringify(exportFormValues)).subscribe(response => {
            // let fileData = response.data;
            if (response.status == 201) {
              if (response.data.length > 0) {
                this.exportfile = response.data.map(item => {
                  delete item.idmdr;
                  let transformedItem = {}
                  if (this.userType == 1) {
                    transformedItem = {
                      "SAN": item.SAN,
                      "Direction": item.Direction,
                      "Msg Count": item["Message Count"],
                      "From Number": item["From Number"],
                      "To Number": item["To Number"],
                      "MT rates": item["MT rates"],
                      "MO rates": item["MO rates"],
                      "MT Surcharge": item["MT Surcharge"],
                      "Status": item.Status,
                      "Message Delivered To Operator": item['Message Delivered To Operator'] == false ? item['Message Delivered To Operator'] : new Date(item['Message Delivered To Operator']).toLocaleDateString('en-US'),
                      "Message Accepted By Signalmash": item['Message Accepted By Signalmash'] == false ? item['Message Accepted By Signalmash'] : new Date(item['Message Accepted By Signalmash']).toLocaleDateString('en-US'),
                      "Delivery Receipt Received By Signalmash": item['Delivery Receipt Received By Signalmash'] == false ? item['Delivery Receipt Received By Signalmash'] : new Date(item['Delivery Receipt Received By Signalmash']).toLocaleDateString('en-US'),
                      "Delivery Receipt Delivered": item['Delivery Receipt Delivered'] == false ? item['Delivery Receipt Delivered'] : new Date(item['Delivery Receipt Delivered']).toLocaleDateString('en-US'),
                      "Mobility": item.Mobility,
                      "Message Body": item["Message Body"],
                      "OCN": item.OCN,
                      "Lata": item.Lata,
                      "Created At": new Date(item.Date).toLocaleDateString('en-US'),
                      "Cost": item.Cost,
                    };
                  } else {
                    transformedItem = {
                      "Direction": item.Direction,
                      "Msg Count": item["Message Count"],
                      "From Number": item["From Number"],
                      "To Number": item["To Number"],
                      "MT rates": item["MT rates"],
                      "MO rates": item["MO rates"],
                      "MT Surcharge": item["MT Surcharge"],
                      "Status": item.Status,
                      "Message Delivered To Operator": item['Message Delivered To Operator'] == false ? item['Message Delivered To Operator'] : new Date(item['Message Delivered To Operator']).toLocaleDateString('en-US'),
                      "Message Accepted By Signalmash": item['Message Accepted By Signalmash'] == false ? item['Message Accepted By Signalmash'] : new Date(item['Message Accepted By Signalmash']).toLocaleDateString('en-US'),
                      "Delivery Receipt Received By Signalmash": item['Delivery Receipt Received By Signalmash'] == false ? item['Delivery Receipt Received By Signalmash'] : new Date(item['Delivery Receipt Received By Signalmash']).toLocaleDateString('en-US'),
                      "Delivery Receipt Delivered": item['Delivery Receipt Delivered'] == false ? item['Delivery Receipt Delivered'] : new Date(item['Delivery Receipt Delivered']).toLocaleDateString('en-US'),
                      "Mobility": item.Mobility,
                      "Message Body": item["Message Body"],
                      "OCN": item.OCN,
                      "Lata": item.Lata,
                      "Created At": new Date(item.Date).toLocaleDateString('en-US'),
                      "Cost": item.Cost,
                    };
                  }
                  return transformedItem;
                });
     
                const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
                const workbook: XLSX.WorkBook = { Sheets: { 'MMS-MDR': worksheet }, SheetNames: ['MMS-MDR'] };
                const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
                this.saveAsExcelFile(excelBuffer, "MMS-MDR");
              }
              else {
                this.errMessage = "Record Not Found !";
                setTimeout(() => {
                  this.errMessage = ""
                }, 5000);
              }
            }
            else {
              this.errMessage = response.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          });
        }
       
        if (e == 'summery') {
          this.exportfile = [];
         
          // change update
          const exportSummaryValues = {...this.summerymmsForm.value};
          exportSummaryValues.directionSummery = exportSummaryValues.directionSummery[0]?.id || '';
          exportSummaryValues.iduser = exportSummaryValues.iduser[0]?.iduser || '';
         
          this.data.summeryCdrForm(JSON.stringify(exportSummaryValues)).subscribe(response => {
            if (response.status == 200) {
              if (response.data.length > 0) {
                this.exportfile = response.data.map(item => {
                  delete item.idmdr;
                  let transformedItem = {}
                  if (this.userType == 1) {
                    transformedItem = {
                      "SAN": 100000000 + item.idaccount,
                      "Date": new Date(item.date).toLocaleDateString('en-US') || '',
                      "Direction": item.direction,
                      "Total Message": item.total_message,
                      "Total Cost": item.total_cost,
                    //   "Status": item.status == 0 ? 'Not Dispatched' : item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 3 ? 'Dispatched' : item.status == 4 ? 'Dispatched to End User / Sent' : item.status == 5 ? 'Resend' : '',
                    };
                  } else {
                    transformedItem = {
                      "Date": new Date(item.date).toLocaleDateString('en-US') || '',
                      "Direction": item.direction,
                      "Total Message": item.total_message,
                      "Total Cost": item.total_cost,
                    //   "Status": item.status == 0 ? 'Not Dispatched' : item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 3 ? 'Dispatched' : item.status == 4 ? 'Dispatched to End User / Sent' : item.status == 5 ? 'Resend' : '',
                    };
                  }
                  return transformedItem;
                });
                const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
                const workbook: XLSX.WorkBook = { Sheets: { 'MMS-MDR': worksheet }, SheetNames: ['MMS-MDR'] };
                const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
                this.saveAsExcelFile(excelBuffer, "MMS-MDR");
              }
              else {
                this.errMessage = "Record Not Found !";
                setTimeout(() => {
                  this.errMessage = ""
                }, 5000);
              }
            }
            else {
              this.errMessage = response.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          });
        }
      }

	// exportFile(e: any) {
	// 	let fType = "filter";
	// 	this.mmdrsForm.patchValue({
	// 		fType: fType
	// 	})
	// 	this.summerymmsForm.patchValue({
	// 		fType: fType
	// 	})
	// 	if (e == 'message') {
	// 		this.exportfile = [];
	// 		  // addchange
	// 	  const exportFormValues = {...this.mmdrsForm.value};
	// 	  exportFormValues.direction = exportFormValues.direction[0]?.id || '';
	// 	  exportFormValues.iduser = exportFormValues.iduser[0]?.iduser || '';
	// 		this.data.getMMSMDR(JSON.stringify(exportFormValues)).subscribe(response => {
	// 			console.log('response.dataaaaa', response.data)
	// 			let fileData = response.data;
	// 			if (response.status == 201) {
	// 				if (fileData.data.length > 0) {
	// 					this.exportfile = fileData.data.map(item => {
	// 						delete item.idmdr;
	// 						let transformedItem = {}
	// 						if (this.userType == 1) {
	// 							transformedItem = {
	// 								"SAN": item.SAN,
	// 								"Direction": item.Direction,
	// 								"Msg Count": item["Message Count"],
	// 								"From Number": item["From Number"],
	// 								"To Number": item["To Number"],
	// 								"MT rates": item["MT rates"],
	// 								"MO rates": item["MO rates"],
	// 								"MT Surcharge": item["MT Surcharge"],
	// 								// "Status": item.status,
	// 								"Status": item.Status == 0 ? 'Not Dispatched' : item.Status == 1 ? 'Delivered' : item.Status == 2 ? 'Failed' : item.Status == 3 ? 'Dispatched' : item.Status == 4 ? 'Dispatched to End User / Sent' : item.Status == 5 ? 'Resend' : '',
	// 								"Message Delivered To Operator": item['Message Delivered To Operator'] == false ? item['Message Delivered To Operator'] : new Date(item['Message Delivered To Operator']).toLocaleDateString('en-US'),
	// 								"Message Accepted By Signalmash": item['Message Accepted By Signalmash'] == false ? item['Message Accepted By Signalmash'] : new Date(item['Message Accepted By Signalmash']).toLocaleDateString('en-US'),
	// 								"Delivery Receipt Received By Signalmash": item['Delivery Receipt Received By Signalmash'] == false ? item['Delivery Receipt Received By Signalmash'] : new Date(item['Delivery Receipt Received By Signalmash']).toLocaleDateString('en-US'),
	// 								"Delivery Receipt Delivered": item['Delivery Receipt Delivered'] == false ? item['Delivery Receipt Delivered'] : new Date(item['Delivery Receipt Delivered']).toLocaleDateString('en-US'),
	// 								"Mobility": item.Mobility,
	// 								"Message Body": item["Message Body"],
	// 								"OCN": item.OCN,
	// 								"Lata": item.Lata,
	// 								"Created At": new Date(item.Date).toLocaleDateString('en-US'),
	// 								"Cost": item.Cost,
	// 							};
	// 						} else {
	// 							transformedItem = {
	// 								"Direction": item.Direction,
	// 								"Msg Count": item["Message Count"],
	// 								"From Number": item["From Number"],
	// 								"To Number": item["To Number"],
	// 								"MT rates": item["MT rates"],
	// 								"MO rates": item["MO rates"],
	// 								"MT Surcharge": item["MT Surcharge"],
	// 								// "Status": item.status ,
	// 								"Status": item.Status == 1 ? 'Delivered' : item.Status == 2 ? 'Failed' : item.Status == 34 ? 'Expired' : item.Status == 16 ? 'No Acknowledge From SMSC' : item.Status == 64 ? 'Internal Expired' : item.Status == 'dispatched' ? 'Dispatched' : '',
	// 								"Message Delivered To Operator": item['Message Delivered To Operator'] == false ? item['Message Delivered To Operator'] : new Date(item['Message Delivered To Operator']).toLocaleDateString('en-US'),
	// 								"Message Accepted By Signalmash": item['Message Accepted By Signalmash'] == false ? item['Message Accepted By Signalmash'] : new Date(item['Message Accepted By Signalmash']).toLocaleDateString('en-US'),
	// 								"Delivery Receipt Received By Signalmash": item['Delivery Receipt Received By Signalmash'] == false ? item['Delivery Receipt Received By Signalmash'] : new Date(item['Delivery Receipt Received By Signalmash']).toLocaleDateString('en-US'),
	// 								"Delivery Receipt Delivered": item['Delivery Receipt Delivered'] == false ? item['Delivery Receipt Delivered'] : new Date(item['Delivery Receipt Delivered']).toLocaleDateString('en-US'),
	// 								"Mobility": item.Mobility,
	// 								"Message Body": item["Message Body"],
	// 								"OCN": item.OCN,
	// 								"Lata": item.Lata,
	// 								"Created At": new Date(item.Date).toLocaleDateString('en-US'),
	// 								"Cost": item.Cost,
	// 							};
	// 						}
	// 						return transformedItem;
	// 					});

	// 					const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
	// 					const workbook: XLSX.WorkBook = { Sheets: { 'MMS-MDR': worksheet }, SheetNames: ['MMS-MDR'] };
	// 					const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
	// 					this.saveAsExcelFile(excelBuffer, "MMS-MDR");
	// 				}
	// 				else {
	// 					this.errMessage = "Record Not Found !";
	// 					setTimeout(() => {
	// 						this.errMessage = ""
	// 					}, 5000);
	// 				}
	// 			}
	// 			else {
	// 				this.errMessage = response.message;
	// 				setTimeout(() => {
	// 					this.errMessage = "";
	// 				}, 5000);
	// 			}
	// 		});
	// 	}
	// 	if (e == 'summery') {
	//      const exportSummaryValues = {...this.summerymmsForm.value};
	// 	  exportSummaryValues.directionSummery = exportSummaryValues.directionSummery[0]?.id || '';
	// 	  exportSummaryValues.iduser = exportSummaryValues.iduser[0]?.iduser || '';
	// 		this.exportfile = [];
	// 		this.data.summeryCdrForm(JSON.stringify(exportSummaryValues)).subscribe(response => {
	// 			if (response.status == 200) {
	// 				if (response.data.length > 0) {
	// 					this.exportfile = response.data.map(item => {
	// 						delete item.idmdr;
	// 						let transformedItem = {}
	// 						if (this.userType == 1) {
	// 							transformedItem = {
	// 								"SAN": 100000000 + item.idaccount,
	// 								"Date": new Date(item.date).toLocaleDateString('en-US') || '',
	// 								"Direction": item.direction,
	// 								"Total Message": item.total_message,
	// 								"Total Cost": item.total_cost,
	// 								// "Status": item.status,
	// 								"Status": item.status == 0 ? 'Not Dispatched' : item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 3 ? 'Dispatched' : item.status == 4 ? 'Dispatched to End User / Sent' : item.status == 5 ? 'Resend' : '',

	// 							};
	// 						} else {
	// 							transformedItem = {
	// 								"Date": new Date(item.date).toLocaleDateString('en-US') || '',
	// 								"Direction": item.direction,
	// 								"Total Message": item.total_message,
	// 								"Total Cost": item.total_cost,
	// 								// "Status": item.status,
	// 								"Status": item.status == 0 ? 'Not Dispatched' : item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 3 ? 'Dispatched' : item.status == 4 ? 'Dispatched to End User / Sent' : item.status == 5 ? 'Resend' : '',

	// 							};
	// 						}
	// 						return transformedItem;
	// 					});
	// 					const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
	// 					const workbook: XLSX.WorkBook = { Sheets: { 'MMS-MDR': worksheet }, SheetNames: ['MMS-MDR'] };
	// 					const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
	// 					this.saveAsExcelFile(excelBuffer, "MMS-MDR");
	// 				}
	// 				else {
	// 					this.errMessage = "Record Not Found !";
	// 					setTimeout(() => {
	// 						this.errMessage = ""
	// 					}, 5000);
	// 				}
	// 			}
	// 			else {
	// 				this.errMessage = response.message;
	// 				setTimeout(() => {
	// 					this.errMessage = "";
	// 				}, 5000);
	// 			}
	// 		});
	// 	}
	// }

	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}

	// startDate() {
	// 	let now = new Date();
	// 	let year = "" + now.getFullYear();
	// 	let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
	// 	let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
	// 	let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
	// 	let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
	// 	let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
	// 	return year + '-' + month + "-" + "01";
	// }

	// startDate() {
	// 	let now = new Date();
	// 	now.setDate(now.getDate() - 90);
	// 	let year = "" + now.getFullYear();
	// 	let month = "" + (now.getMonth() + 1);
	// 	if (month.length == 1) {
	// 		month = "0" + month;
	// 	}

	// 	let day = "" + now.getDate();
	// 	if (day.length == 1) {
	// 		day = "0" + day;
	// 	}

	// 	return year + '-' + month + "-" + day;
	// }

	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1);
		if (month.length == 1) {
			month = "0" + month;
		}
		let day = "01";
		return year + '-' + month + "-" + day;
	}

	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + day;
	}

	monthsList() {
		this.monthNameList = [
			{ name: "Jan", value: "1" },
			{ name: "Feb", value: "2" },
			{ name: "Mar", value: "3" },
			{ name: "Apr", value: "4" },
			{ name: "May", value: "5" },
			{ name: "Jun", value: "6" },
			{ name: "Jul", value: "7" },
			{ name: "Aug", value: "8" },
			{ name: "Sep", value: "9" },
			{ name: "Oct", value: "10" },
			{ name: "Nov", value: "11" },
			{ name: "Dec", value: "12" }
		];
	}


	// static dateLessThan(from_date: string, to_date: string, validatorField: { [key: string]: boolean }): ValidatorFn {
	// 	return (c: AbstractControl): { [key: string]: boolean } | null => {
	// 		const date1 = c.get(from_date).value;
	// 		const date2 = c.get(to_date).value;
	// 		if ((date1 !== null && date2 !== null) && date1 > date2) {
	// 			return validatorField;
	// 		}
	// 		return null;
	// 	};
	// }

	messageshow() {
		this.validateDateRange(this.mmdrsForm, 1);
		this.validateDateRange(this.summerymmsForm, 2);
		this.validateDateRange(this.downloadreport, 3);

	}

	validateDateRange(form: FormGroup, type: any) {
		const fromDate = form.get('from_date').value;
		const toDate = form.get('to_date').value;
		const currentDate = new Date();
		const threeMonthsAgo = new Date();
		threeMonthsAgo.setMonth(currentDate.getMonth() - 3);
		const oneAndHalfYearsAgo = new Date();
		oneAndHalfYearsAgo.setMonth(currentDate.getMonth() - 18);


		if ((!fromDate && !toDate)) {
			// No date range selected, do nothing
		} else if ((fromDate == null || !fromDate) && (toDate != null)) {
			form.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((fromDate != null) && (toDate == null || !toDate)) {
			form.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
			form.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
			return;
		} else if (toDate && new Date(toDate) > currentDate) {
			form.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
			return;
		} else if (fromDate && new Date(fromDate) > currentDate) {
			form.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
			return;
		}
		else if (new Date(fromDate) < threeMonthsAgo && type == 1) {
			form.get('from_date').setErrors({ 'dateRange': 'We can only provide data for the last three months' });
			return;
		}
		else if (new Date(fromDate) < oneAndHalfYearsAgo && type == 3) {
			form.get('from_date').setErrors({ 'dateRange': 'We can only provide data for the last 1.5 years' });
			return;
		}
		else {
			form.get('from_date').setErrors(null);
			form.get('to_date').setErrors(null);
		}
	}


	showfilter() {
		if (this.show_filter == false) {
			this.show_filter = true;
		}
		else {
			this.show_filter = false;
		}

	}
	showdaily() {
		if (this.show_daily == false) {
			this.show_daily = true;
		}
		else {
			this.show_daily = false;
		}
	}

	OnRequest() {
		this.submitteddownload = true;
		if (this.downloadreport.invalid) {
			return false;
		} else {
			this.data.SMSrequest(this.downloadreport.value).subscribe((res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					this.downloadreportmodal.nativeElement.click();
					setTimeout(() => {
						this.responseMessage = '';
						this.router.navigate(['./downloadreport/sms']);
					}, 5000);
				} else {
					this.errMessage = res.message;
					this.downloadreportmodal.nativeElement.click();
					setTimeout(() => {
						this.errMessage = '';
						this.router.navigate(['./downloadreport/sms']);
					}, 5000);
				}
			}));
		}
	}

	minDate() {
		const now = new Date();
		now.setMonth(now.getMonth() - 18); // Subtract 18 months
		return now.toISOString().slice(0, 10);
	}


	ResetRequest() {
		this.submitteddownload = false
		this.downloadreport.reset()
		this.downloadreport.get('directions').setValue("")
		this.downloadreport.get('type').setValue(2)
		this.downloadreport.patchValue({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
		})

	}

	summeryMms() {
		this.summerymmsForm.patchValue({
			fType: ""
		})
		if (this.summerymmsForm.invalid) {
			return false
		}
		else {

			this.filterSummaryMms = [];
			this.summerymmsForm.value.directionSummery = this.summerymmsForm.value.directionSummery[0]?.id || '',
			this.summerymmsForm.value.iduser = this.summerymmsForm.value.iduser[0]?.iduser || ''
			this.data.summeryCdrForm(JSON.stringify(this.summerymmsForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterSummaryMms = response.data;
					$('#basic-datatablesSum').DataTable().clear();
					$('#basic-datatablesSum').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	resetMMdr() {
		this.submitted = false;
		this.mmdrsForm.reset({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
			from_number: '',
			to_number: '',
			direction: [],
			iduser: [],
			fType: ''
		});
		this.mmdrsForm.get('direction').setValue([]);
		this.mmdrsForm.get('iduser').setValue([]);
		this.onMMdrsGet();
	}
	mmsSumry() {
		this.submitted = false;
		this.summerymmsForm.reset({
		  from_date: this.lastdate,
		  to_date: this.startdate,
		  directionSummery: [],
		  iduser: [],
		  fType: ''
		});
	  
		this.summerymmsForm.get('directionSummery').setValue([]);
		this.summerymmsForm.get('iduser').setValue([]);
	  
		this.errMessage = "";
	  
		this.summeryMms();
	  }

	truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}

	ngOnDestroy() {
		this.viewdetails.nativeElement.click();
		this.downloadreportmodal.nativeElement.click();
	}
}
