import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { SmsService } from '../sms.service';
import { outboundsms, outboundsmsForm } from '../sms.class';
@Component({
  selector: 'app-outboundsms',
  templateUrl: './outboundsms.component.html',
  styleUrls: ['./outboundsms.component.css']
})
export class OutboundsmsComponent extends AppComponentClass<outboundsms, outboundsmsForm> {
  label : any;
  label2 : any;
  header:any;
  rowdata:any;
  
 
 outboundsmsForm: FormGroup;
  public submitted : boolean = false;
  constructor(public data: SmsService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
   
	}

  ngOnInit(): void {
    this.data.get_smsconf().subscribe((result)=>{
     
     this.label = result[1];
   
     
       console.log(result);
     })

      // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new outboundsmsForm(res);
				this.keyfield = res.id;
				this.outboundsmsForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new outboundsmsForm(null);
				this.keyfield = -1;
				this.outboundsmsForm = this.cdata.makeform(this.fb);
			}
		});
 
   }
 
  

   onSubmit() {
		console.log("event task save");
		this.submitted = true;

		if (this.outboundsmsForm.invalid) {
			return false;
		} else {
			console.log("submit data::", this.cdata);
			if (this.cdata.saveForm(this.outboundsmsForm)) {
				console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				}
			}
		}
	}

 
 }