import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { SubscriptionService } from '../subscription.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { BillingService } from 'src/app/billing/billing.service';
declare var $: any;
@Component({
  selector: 'app-subscription-control',
  templateUrl: './subscription-control.component.html',
  styleUrls: ['./subscription-control.component.css']
})
export class SubscriptionControlComponent implements OnInit {
  @ViewChild('deletesubscription') deletesubscription: ElementRef;
  @ViewChild('deletesubscription1') deletesubscription1: ElementRef;
 
  id1:any;
  tableheader: any;
  show_filter: boolean;
  dropdownSettings: IDropdownSettings = {};
  dropdownSettingsname: IDropdownSettings = {};
  closeDropdownSelection = true;
  mappingForm: FormGroup
  userdata: any = [];
  reloaduserlist: any = [];
  subscriptiondata: any = [];
  selectedname: any
  selectedsa: any
  submitted: boolean = false;
  subscription: any;
  errMessage: any;
  responseMessage: any ='';
  selectedItem: any = [];
  SUBSC: any = [];
  Subdata: any = [];
  selectedItems: any = [];
  id: string;
  getdata: any = [];
  sanid:any;
  subid:any;
  userbalance:any
  act_sub_id:any
  subsid:any
  quantity1:any
  quantity2:any;
  defquantity:any;
  changedquantity:any;
  userdata1:any=[];
  action:any;

  saveButton:string='Save';

  shedulestatus:any;
  isDisabled:boolean=false;
 subDisable:boolean=false;
  constructor(public data: SubscriptionService, public usermanagmentservice: UsermanagementService, public billingService:BillingService,public fb: FormBuilder) { }

  ngOnInit(): void {
    // ------------------table header--------------
    this.data.get_Subscription().subscribe((res) => {
      this.tableheader = res[1].SubscriptionControl
    })

    // ---------------------------san no list---------------------
    this.usermanagmentservice.getUsers("main").subscribe((res) => {
      this.userdata1= res.data[0]
      this.userdata = res.data[0]
      this.userdata = res.data[0].filter(item => item.is_deleted === 0).sort((a, b) => new Date(a.created).getTime() - new Date(b.created).getTime()).map(item => ({
        iduser: item.idaccount,
        san: `${item.san}`
      }));
    })

    this.mappingForm = this.fb.group({
      san: ['', [Validators.required]],
      name: ['', [Validators.required]],
      quantity: ['', [Validators.required, Validators.pattern(/^\d+$/),Validators.maxLength(7)]],
      ScheduleDate:[this.getTodayDate()]
    })

    this.data.get_Subscriptiondata().subscribe((res)=>{
       this.getdata = res.data.map((item) => ({
        subscription:  `${item.subscription_id}-${item.quantity}-${item.type}-${item.mrc}-${item.proration}`,
        name: item.name || "Unknown"
      }));
      this.SUBSC = res.data.map(item => ({
        ...item,
        subscription_quantity: item.subscription_quantity == null || item.subscription_quantity === '' ?item.quantity
         : item.subscription_quantity
      }));
      this.Subdata = this.SUBSC.slice().reverse();
      
    })

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'iduser',
      textField: 'san', 
      selectAllText: 'Select All',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
    this.dropdownSettingsname = {
      singleSelection: true,
      idField: 'subscription',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
    this.get_subscription()
  }

  // ---------get list --------------------
  get_subscription() {
    this.data.get_Subscriptionlist().subscribe((res) => {
      if (res.status == 200) {
        this.subscription = res.data
        $('#basic-datatablessub').DataTable().clear();
        $('#basic-datatablessub').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
        this.subscriptiondata = res.data
      }
      else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    });
  }

  getDate(start_date){
      let formattedDate = new Date(start_date);
      let offset = formattedDate.getTimezoneOffset() * 60000;
      let localDate = new Date(formattedDate.getTime() - offset);
      let formattedDate1 = localDate.toISOString().split('T')[0];
      return formattedDate1;
  }
  editsub(data: any) {
    this.subDisable=true
    this.shedulestatus=Number(data.Subscriptionstatus)
    this.defquantity=data.account_quantity
    this.saveButton='Update'
    this.id = data.idaccount;
    this.sanid=data.idaccount;
    this.act_sub_id=data.act_sub_id;
    this.subsid=data.subscription_id;
    this.data.get_Subscriptiondata().subscribe((res) => {
      const filteredData = res.data.filter(item => 
        item.subscription_id==data.subscription_id
      );
      const subscription = filteredData.length > 0 
      ? `${filteredData[0].subscription_id}-${filteredData[0].quantity}-${filteredData[0].type}-${filteredData[0].mrc}-${filteredData[0].proration}`
      : "Unknown";
      this.selectedItem = [{ name: data.name, subscription: subscription}];
      this.selectedItems = [{ san: data.san, iduser: data.idaccount }];
      this.mappingForm.patchValue({
        quantity: data.account_quantity,
        san: this.selectedItems,
        ScheduleDate:this.getDate(data.start_date)
      });
      

      if (data.status == 1) {
        this.isDisabled = true
      } else if (data.status == 0) {
        this.isDisabled = true
      } else {
        this.isDisabled = false
      }
 
    });
  }
  onChangesubscription(event: any) { 
    let subscriptionid = Number(event.subscription.split("-")[0]);
    this.subid=subscriptionid
    let quantity = event.subscription.split("-")[1];
    this.defquantity=quantity
      this.saveButton='Save'
      this.id=''
      this.shedulestatus=null
      this.isDisabled=false
      this.mappingForm.controls['ScheduleDate'].reset();
      this.mappingForm.patchValue({
        quantity: quantity,
        ScheduleDate: this.getTodayDate(),
      });
  }
  onChange(event: any) {
    this.sanid = Number(event.iduser)
    let subscriptionid = Number(this.subid);
    if(subscriptionid) {
        this.isDisabled=false
        this.mappingForm.controls['ScheduleDate'].reset();
        this.shedulestatus=null
        this.saveButton = 'Save'
        this.mappingForm.patchValue({
            ScheduleDate: this.getTodayDate(),
        });
        this.id = ''
        this.shedulestatus=null
    }
    this.saveButton = 'Save'
    this.mappingForm.patchValue({
        quantity: this.quantity1,
    });
    this.id = ''
}
onChangesan(event:any){
  this.sanid=''
  this.saveButton='Save'
  this.mappingForm.patchValue({
    quantity: this.quantity1,
    
  });

}

  quantity(){
    if (this.mappingForm.invalid) {
      this.submitted = true;
      return;
    }else{
      if(this.defquantity<this.mappingForm.value.quantity){
        $('#deletesubscription').modal('show');
      }else{
        this.onsubmit()
      }
    }
   
  }

  cancelModal() {
    $('#deletesubscription').modal('hide'); 
  }

  getTodayDate(): string {
    const today = new Date();
    return today.toISOString().split('T')[0]; 
  }

  deletedata(data){
    this.act_sub_id=data.act_sub_id
  }
 inactive(){
   if(this.act_sub_id){
        this.data.inActivesubscription(this.act_sub_id).subscribe((res) => {
        if (res.status == 201) {
          // this.ngOnInit()
          this.deletesubscription1.nativeElement.click();
          this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
              this.get_subscription()
          }, 3000);
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    } 
  }

  cancelModal2() {
    this.act_sub_id='';
  }
 
 
/*   deletedata(data){
    if(data.act_sub_id){
      this.data.inActivesubscription(data.act_sub_id).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
              this.get_subscription()
          }, 3000);
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    }    
  } */
  messageshow1() {
    const scheduleDate = this.mappingForm.get('ScheduleDate').value;
    const currentDate = new Date();
    currentDate.setHours(0, 0, 0, 0); 
    this.mappingForm.get('ScheduleDate').setErrors(null);
    if (!scheduleDate) {
      return;
    }
    const selectedDate = new Date(scheduleDate);
    if (selectedDate < currentDate) {
      this.mappingForm.get('ScheduleDate').setErrors({ dateRange: 'To date cannot be smaller than current date' });
      return;
    }
    if (selectedDate.getTime() > (currentDate.getTime() + 365 * 24 * 60 * 60 * 1000)) {
      this.mappingForm.get('ScheduleDate').setErrors({ dateRange: 'To date cannot be greater than 365 days from the current date' });
      return;
    }
  }

  onsubmit() {
    if (this.mappingForm.invalid) {
        this.submitted = true;
        return;
    } else {
      let filteredUsers = this.userdata1.filter((item) =>
        item.idaccount == this.mappingForm.value.san[0]?.iduser
      );
      const formValues = this.mappingForm.value;
      const subscription = formValues.name[0].subscription;
      let date = formValues.ScheduleDate;
      const [subscription_id, quantity, type, mrc, proration] = subscription.split('-').map(Number);
      let payload = {
        act_sub_id: this.act_sub_id,
        idaccount: this.mappingForm.value.san[0].iduser,
        subscription_id: this.mappingForm.value.name[0].subscription.split('-')[0],
        subscription_quantity: this.mappingForm.value.quantity,
        mrc: mrc,
        type: type,
        proration: proration,
        iduser: filteredUsers[0].iduser,
        date: this.mappingForm.value.ScheduleDate,
        shedulestatus: this.shedulestatus,
        action:this.saveButton

      };
      if(this.act_sub_id){
        this.data.updateSubscriptionSchedule(JSON.stringify(payload)).subscribe((res) => {

        if (res.status == 200) {
            this.subDisable=false
            this.act_sub_id=''
            this.isDisabled = false
            this.get_subscription()
            this.resetForm()
            this.mappingForm.reset();
            this.mappingForm.patchValue({
            ScheduleDate: this.getTodayDate(),
        });
          $('#deletesubscription').modal('hide');
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
            this.responseMessage = res.message1;
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
          }, 3000);
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
      }else{
        this.data.saveSubscriptionSchedule(JSON.stringify(payload)).subscribe((res) => {
          if (res.status == 200) {
            this.act_sub_id=''
            this.subDisable=false
            this.isDisabled = false
            this.get_subscription()
            this.resetForm()
            this.mappingForm.reset();
            this.mappingForm.patchValue({
              ScheduleDate: this.getTodayDate(),
          });
            $('#deletesubscription').modal('hide');
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
              this.responseMessage = res.message1;
              setTimeout(() => {
                this.responseMessage = "";
              }, 3000);
            }, 3000);
          } else {
            this.errMessage = res.message
            setTimeout(() => {
              this.errMessage = ""
            }, 5000);
          }
        })
      }
      this.subid = '';
      this.quantity1 = '';
      this.id = '';
    }
  }
   

  
 
  resetForm() {
    this.act_sub_id=''
    this.subDisable=false
    this.id='';
    this.submitted = false
    this.mappingForm.reset();
    this.selectedItem = 0
    this.selectedItem = [];
    this.saveButton='Save';
    this.subid='';
    this.quantity1=''
    this.sanid=''
    this.isDisabled=false
    this.mappingForm.patchValue({
      ScheduleDate: this.getTodayDate(),
    });
  }

  ngOnDestroy() {
    this.deletesubscription.nativeElement.click();
    this.deletesubscription1.nativeElement.click(); 
  }

}
