import { FormBuilder, FormGroup, Validators } from "@angular/forms";

// supplier form
export interface supplier
{
    first_name:string,
    last_name:string,
    phone:string,
    user_name:string ,
    password:string     
}

export interface HTTPsupplier
{
    first_name:string,
    last_name:string,
    phone:string,
    user_name:string ,
    password:string      
}

export class supplierForm implements HTTPsupplier
{
    first_name:string;
    last_name:string;
    phone:string;
    user_name:string ;
    password:string ;  
  
    constructor(data : supplier) 
    {
        if(data==null)
        {        
            this.first_name="";
            this.last_name="";
            this.phone="";
            this.user_name="";
            this.password="";
           
        }
        else
        {         
            this.first_name = data.first_name;
            this.last_name = data.last_name;
            this.phone = data.phone;
            this.user_name = data.user_name;
            this.password = data.password;
           
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            first_name:[this.first_name, Validators.required],
            last_name:[this.last_name, Validators.required],
            phone:[this.phone, Validators.pattern(new RegExp("[0-9 ]{12}"))],
            user_name:[this.user_name, Validators.required],
            password:[this.password, Validators],
           
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.password = fg.get("password").value;
            this.last_name = fg.get("last_name").value;
            this.phone = fg.get("phone").value;
            this.user_name = fg.get("user_name").value; 
            this.password = fg.get("password").value;            
                     
            return true;
        }
        else
        {
            return false;
        }
    }
  }

  // DID form
export interface didupload
{
    did:string,
   
     
}

export interface HTTPdidupload
{
    did:string,
    
}

export class didForm implements HTTPdidupload
{
    did:string;
  
   
   
  
    constructor(data : didupload) 
    {
        if(data==null)
        {        
            this.did="";
           
          
           
        }
        else
        {         
            this.did = data.did;
           
           
           
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            did:[this.did, [Validators.required]],
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.did = fg.get("did").value;
           
                     
            return true;
        }
        else
        {
            return false;
        }
    }
  }



  // DID form
export interface itegratedsolutions
{
    api_key:string,
    api_secret:string,
  
     
}

export interface HTTPitegratedsolutions
{
    api_key:string,
    api_secret:string,
  
      
}

export class intgratedsolutionsForm implements HTTPitegratedsolutions
{
    api_key:string;
    api_secret:string;
  
   
  
    constructor(data : itegratedsolutions) 
    {
        if(data==null)
        {        
            this.api_key="";
            this.api_secret="";
        }
        else
        {         
            this.api_key = data.api_key;
            this.api_secret = data.api_secret;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            api_key:[this.api_key, [Validators.required]],
            api_secret:[this.api_secret, [Validators.required]],
           
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.api_key = fg.get("api_key").value;
            this.api_secret = fg.get("api_secret").value;
            return true;
        }
        else
        {
            return false;
        }
    }
  }

