import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { HttpClient, HttpHeaders, HttpParams } from '@angular/common/http';
import { AppService } from '../shared/service/AppService.class';
import { environment } from 'src/environments/environment';
@Injectable({
  providedIn: 'root'
})
export class SupplierService extends AppService<any>  {
  constructor(public http:HttpClient) {
    super(http)
  }

  saveData(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'custom/saveheadermapping';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  updateData(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'custom/saveheadermapping';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  public getsuppiler():Observable<any>{
    return this.http.get('./assets/supplier.json');
  }

  public getdidupload():Observable<any>{
    return this.http.get('./assets/uploaddid.json');
  }

  public getintegrated():Observable<any>{
    return this.http.get('./assets/integrated.json');
  }

  public getrecord():Observable<any>{
    return this.http.get('./assets/didreport.json');
  }


  public saveFile(fileName: File | string, type: any): Observable<any> {
   
    const endpoint = environment.SERVER+ 'uploads/document_upload';
    
    let formData = new FormData();
    
    formData.append("fileName", fileName)
    formData.append("type", type);
    
    console.log(formData);

    let httpHeaders = new HttpHeaders({

    });
    return this.http.post(endpoint, formData, { headers: httpHeaders });
  }

download(url: string): Observable<Blob> {
  return this.http.get(url, {
    responseType: 'blob'
  });
}

}