import { Component, OnInit } from '@angular/core';
import {SupplierService} from '../supplier.service';
import { Router } from '@angular/router';
import { FormBuilder, FormGroup, FormControl} from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { supplier,  supplierForm } from '../supplier.class';

@Component({
  selector: 'app-supplier',
  templateUrl: './supplier.component.html',
  styleUrls: ['./supplier.component.css']
})
export class SupplierComponent extends AppComponentClass<supplier, supplierForm>{
	showMsg: boolean = false;
  p: number = 1;
	rowdata: any;
	details: any;
	listdata: any;
	record:any;
	list:any;
	// defaultSelect : any = 1;
	page = 1;
	count = 0;
	tableSize = 5;
	tableSizes = [ 5, 9, 12];
	modelform:any;
  public show: boolean = false;
  public package: any;
  public buttonName: any = "Add";
  public supplierForm: FormGroup;
  public submitted : boolean = false;
  filterTerm: string;
  fileToUpload: File = null;
  file:any;

  
  constructor(public data: SupplierService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  
  ngOnInit(): void {


	
    // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new supplierForm(res);
				this.keyfield = res.id;
				this.supplierForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new supplierForm(null);
				this.keyfield = -1;
				this.supplierForm = this.cdata.makeform(this.fb);
			}
		});

    this.data.getsuppiler().subscribe((result) => {
	  this.listdata = result[1] ; 
	 
      console.log(result)
    });

	this.data.getrecord().subscribe((result) => {
		this.record = result[0].headers_details  ;
		this.list = result[0].profile_details ;

		console.log(this.list)
	  });

    
  }

  downloadMyFile(): void {
	this.data
	  .download('./assets/sample-csv/ratelist-sample.csv')
	  .subscribe(blob => {
		const a = document.createElement('a')
		const objectUrl = URL.createObjectURL(blob)
		a.href = objectUrl
		a.download = 'ratelist-sample.csv';
		a.click();
		URL.revokeObjectURL(objectUrl);
	  })
  }

  saveFile(event, type: any){
    this.data.saveFile(event, type).subscribe(res => {
			console.log(res);

		  }, error => {
			console.log(error);
		  });
  }

 toggle() {
    this.show = !this.show;

    // CHANGE THE NAME OF THE BUTTON.
    if (this.show) this.buttonName = "Close";
    else this.buttonName = "Add";
  }

 // @to edit the record
	editRow(rowdata: any): void {
		this.show = true
		this.Edit(rowdata)
	}
	get f() { return this.supplierForm.controls; };

	// @to save/update form data
	onSubmit() {
		console.log("event task save");
		this.submitted = true;

		if (this.supplierForm.invalid) {
			return false;
		} else {
			console.log("submit data::", this.cdata);
			if (this.cdata.saveForm(this.supplierForm)) {
				console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
					setTimeout(() => { alert('Data Successfully Save!') }, 1000)
					// this.show = true
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				}
			}
		}
	}

	onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
	  } 
	  
	onTableDataChange(event){
		this.page = event;
	  } 

	//   click(){
	// 	  this.show = !this.show
	//   }
	
}

