import { Component, OnInit } from '@angular/core';
import { AbstractControl, FormArray, FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { environment } from 'src/environments/environment';
import { AdvanceratesComponent } from '../advancerates/advancerates.component';
import { TariffService } from '../tariff.service';

@Component({
  selector: 'app-addsurcharge',
  templateUrl: './addsurcharge.component.html',
  styleUrls: ['./addsurcharge.component.css']
})
export class AddsurchargeComponent implements OnInit {
  
    show: boolean = false;
    addfield: any;
    status: boolean = false;
  	idtariff: any;
    formField: Observable<any>;
  	newFeatures: Observable<any>;
	  surchargeForm : FormGroup;
    tariffs: any;
    rates:any;
    header: any;
    headers: any;
    responseMessage = "";
    tollfreeForm: FormGroup;
    shortcodeForm: FormGroup;
    resAlertMessage = "";
    DLCRate: any;
    tollfreeRates: any;
    shortCodeRates: any;
    inboundRates: any;
    tariffName: any;
    list: any;
    submitted: boolean = false;
    header1: any;
    header2: any;
    ratelists: any;
    listdata: any;
    id_surcharge: any;
    surcharges: any = [];
    idsurcharge: any;
    tollFreeForm: FormGroup;
    operator: any = [];
    errMessage = "";

  constructor(private data: UsermanagementService, private fb: FormBuilder, 
    private tariffService: TariffService, private route: ActivatedRoute,  public dialog: MatDialog) {


      this.data.getTollFreeForm().subscribe((result) => {
        this.headers = result[0].headers_details;
        this.ratelists = result[0].rowdata;
      });

      this.tariffService.searchByOperator("").subscribe(res => {
        this.operator = res.data;
        let tmpform:any={};
        this.operator.forEach(ele => {
          tmpform["idoperator_"+ele.id]=ele.id;
          tmpform["priority_"+ele.id]= [];
          tmpform["10dlc_sms_inbound_"+ele.id]= [];
          tmpform["tollfree_sms_inbound_"+ele.id]= [];
          tmpform["shortcode_sms_inbound_"+ele.id]= [];
          tmpform["freetoendusershortcode_sms_inbound_"+ele.id]= [];
          tmpform["10dlc_mms_inbound_"+ele.id]= [];
          tmpform["tollfree_mms_inbound_"+ele.id]= [];
          tmpform["shortcode_mms_inbound_"+ele.id]= [];
          tmpform["freetoendusershortcode_mms_inbound_"+ele.id]= [];
          tmpform["10dlc_sms_outbound_"+ele.id]= [];
          tmpform["tollfree_sms_outbound_"+ele.id]= [];
          tmpform["shortcode_sms_outbound_"+ele.id]= [];
          tmpform["freetoendusershortcode_sms_outbound_"+ele.id]= [];
          tmpform["10dlc_mms_outbound_"+ele.id]= [];
          tmpform["tollfree_mms_outbound_"+ele.id]= [];
          tmpform["shortcode_mms_outbound_"+ele.id]= [];
          tmpform["freetoendusershortcode_mms_outbound_"+ele.id]= [];
          //tmpform["10dlc_none"+ele.id] = [];
          //tmpform["tollf_none"+ele.id] = [];
          //tmpform["short_none"+ele.id] = [];
        });
        this.tollFreeForm = this.fb.group(tmpform);
        this.getsurcharge();
        }, err => {
              console.log(err);
        });

      // this.addfield = this.fb.group({
      //   Surcharge: this.fb.array([
      //   ])
      // })
     }

  ngOnInit(): void {

    this.surchargeForm = this.fb.group({
      name:['', [Validators.required, Validators.minLength(3)]],
			description: ['', [Validators.required, Validators.minLength(10)]],
    });



    // this.route.paramMap.subscribe((params: ParamMap) => {
    //   this.idtariff = params.get('id');
    //    this.tariffService.getTariff(this.idtariff).subscribe(res => {
    //      this.tariffName = res.data[0].name;
    //    }, err => {
    //      this.responseMessage = "Something Went Wrong!";
    //      setTimeout(()=>{
    //         this.responseMessage= "";
    //     }, 5000);
    //    })
    // });

    this.data.get_surcharge().subscribe(result => {
      this.header1 = result[0].headers;
      this.header2 = result[0].title;
    });

    // this.tariffService.getSurcharges().subscribe(res => {
    //   if(res.status == 200){
    //       this.surcharges = res.data;
    //       console.log(this.surcharges);
    //   }
    //   else{
    //       this.responseMessage = res.message;  
    //       setTimeout(()=>{
    //         this.responseMessage= "";
    //       }, 3000);
    //   }
    // }, err => {
    //       this.responseMessage = err.message;  
    //       setTimeout(()=>{
    //         this.responseMessage= "";
    //       }, 5000);
    // });


    this.data.getsmsrate().subscribe((result) => {
      this.headers = result[0].headers_details;
      this.listdata = result[0].rowdata;
    });

    
    this.data.getshortcode().subscribe(result => {
      this.header = result[0].headerdetails;
      this.shortCodeRates = result[0].rowlist;
      this.rates = result[0].rowlist;

      
    //   let temp = {};
    //   this.shortCodeRates.forEach(element => {
    //     temp["idshortcode_" +element.priority] = [0],
    //     temp["category_" +element.priority] = [0],
    //     temp["outboundSurcharge_" +element.priority]=[0];
    //     temp["inboundSurcharge_" +element.priority]=[0];
    // });
    // this.shortcodeForm = this.fb.group(temp);  
  });

    // this.newFeatures=this.data.getFeature();

    // this.DLCRate = this.tariffService.Get10DLCRate(this.idtariff);

    // this.tollfreeRates = this.tariffService.GetTollFreeRates(this.idtariff);

    // this.inboundRates = this.tariffService.getRate(this.idtariff);

    // this.tariffService.GetShortCode(this.idtariff).subscribe(res => {
    //   this.shortCodeRates = res.data;
    //   let temp=[];	
    //   res.data.forEach(element => {
    //       temp["idshortcode_" +element.priority] = [element.idshort_code],
		// 			temp["category_" +element.priority] = [element.category],
    //       temp["outboundSurcharge_" +element.priority]=[element.inbound_message_surcharge];
		// 			temp["inboundSurcharge_" +element.priority]=[element.inbound_message_surcharge];
    //   });
    //   this.shortcodeForm = this.fb.group(temp);
    // })
  }

  // onshortCodeRates(){
  // 	let response: any = [];
	// 	response[0]=[];
	// 	response[1]=[];
	// 	response[2]=[];
	// 	response[3]=[];
	// 	response[4]=[];
	// 	response[5]=[];
	// 	response[6]=[];
	// 	response[7]=[];

	// 	for(let key of Object.keys(this.shortcodeForm.value)){
	// 	  let tmp=key.split('_');
	// 	  response[tmp[1]].push({field: tmp[0], value: this.shortcodeForm.value[key]});
	// 	}
	// 	let temp = response.slice(1, 7);
	// 	this.tariffService.updateShortCodeRate(temp).subscribe(resp => {
  // 		        this.responseMessage = resp.message;  
  //             setTimeout(()=>{
  //               this.responseMessage= "";
  //             }, 5000);
	// 	});
  // }


  getsurcharge(){
    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idsurcharge = params.get('id');
       this.tariffService.getSurcharges(this.idsurcharge).subscribe(res => {
        if(res.status == 200){
          // let tmpform: any={};
                this.surcharges = res.data;
                // console.log("surcharge",this.surcharges);
                if(this.surcharges.length > 0){
                  this.surcharges.forEach((ele:any) => {
                    //tmpform["idoperator_"+ele.id.toString()]=[ele.id];
                    // tmpform["priority_"+ele.id.toString()]= [];
                    // let rates= JSON.parse(ele.data);
                    // Object.entries(rates).forEach(element => {
                    //   tmpform[element[0].toLowerCase()+"_"+ele.id]= [element[1]];
                    // });
                     // this.tollFreeForm = this.fb.group(tmpform);
                   
                    if(ele.data){
                      let rates= JSON.parse(ele.data);
                      Object.entries(rates).forEach(element => {
                        let lwrcase = element[0].toLowerCase();
                        let ctrlname = lwrcase+"_"+ele.id;
                        let val = element[1];
                        this.tollFreeForm.get(ctrlname).setValue(val);
                      });
                    }
                  });
                }
            }
            else{
                this.responseMessage = res.message;  
                setTimeout(()=>{
                  this.responseMessage= "";
                }, 3000);
            }
       }, err => {
         this.responseMessage = err.message;
         setTimeout(()=>{
            this.responseMessage= "";
        }, 5000);
       })
    });
  }

  SaveRates(event){
   console.log(event);
  }

  addSurcharge(){
    this.submitted = true;
    if(this.surchargeForm.invalid){
      return true;
    }
    else{
      this.tariffService.saveSurcharge(this.surchargeForm.value).subscribe(res => {
        if(res){
          this.id_surcharge = res.data.insertId;
          this.status = true;
          this.responseMessage = res.message;  
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
        }
      });
    }
  }

  updateSurcharge(){
    this.tariffService.updateSurcharge(this.tollFreeForm.value).subscribe(res => {
      if(res.status == 201){
        this.responseMessage = res.message;  
        this.getsurcharge();
          setTimeout(()=>{
            this.responseMessage= "";
          }, 5000);
      }
      else{
        this.errMessage = res.message;
          setTimeout(()=>{
            this.errMessage= "";
          }, 5000);
      }
    });
  }

  toggle() {
    this.show = !this.show;
  }


  openDialog(id, label, type): void {
    const dialogRef = this.dialog.open(AdvanceratesComponent, {
      width: 'auto',
      data: {id: id, label, type}
    });

    dialogRef.afterClosed().subscribe(result => {
      let tmpdata:any=[];
      Object.entries(result).forEach((ele:any)=>{
        let tmp=ele[0].split("_");
        tmpdata.push({"type":tmp[0], "subtype":tmp[1], "direction":tmp[2], "operator":tmp[3], "category":tmp[4], "rate":ele[1]})
      });

      console.log(tmpdata);
    });
  }
//   addNewIPFormGroup() {
//     return this.fb.group({
//     });
// }

  // addclick(): void {
  //   (this.addfield.get('Surcharge') as FormArray).push(
  //     this.fb.control(null)
  //   );
  // }

  // removeclick(index) {
  //   (this.addfield.get('Surcharge') as FormArray).removeAt(index);
  // }

  // getaddFormControls(): AbstractControl[] {
  //   return (<FormArray>this.addfield.get('Surcharge')).controls
  // }
}
