import { Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { TollfreeratesComponent } from '../tollfreerates/tollfreerates.component';

@Component({
  selector: 'app-advancerates',
  templateUrl: './advancerates.component.html',
  styleUrls: ['./advancerates.component.css']
})

export class AdvanceratesComponent implements OnInit {

  listdata: any;
  headers: any;
  optid: number;
  ctype:string;
  header:string;
  optlist=["A", "C", "E", "G", "Z", "Q", "B","D", "F", "T","NA","P","X","S","Y","W"];
  tollFreeForm: FormGroup;

  constructor(public dialogRef: MatDialogRef<TollfreeratesComponent>,
    @Inject(MAT_DIALOG_DATA) private data: any, private userService: UsermanagementService, private fb:FormBuilder) { }

  ngOnInit(): void {
      this.optid=this.data.id;
      this.header=this.data.label;
      this.ctype=this.data.type;

      let tmpform:any={};
      this.optlist.forEach(ele=>{
        if(this.ctype=="SMS-IN")
          tmpform["10dlc_sms_in_"+ this.optid+"_"+ele] = [0];
        if(this.ctype=="SMS-OUT")
          tmpform["10dlc_sms_out_"+ this.optid+"_"+ele] = [0];
        if(this.ctype=="MMS-IN")
          tmpform["10dlc_mms_in_"+ this.optid+"_"+ele] = [0];
        if(this.ctype=="MMS-OUT")
          tmpform["10dlc_mms_out_"+ this.optid+"_"+ele] = [0];
      });
      this.tollFreeForm = this.fb.group(tmpform);

      this.userService.getsmsrate().subscribe((result) => {
        this.headers = result[0].headers_details;
        this.listdata = result[0].rowdata;
      });
  }

  onSaveTollFree(){
    this.dialogRef.close(this.tollFreeForm.value);
  }

  closeForm(){
    this.dialogRef.close();
  }
}
