import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { environment } from 'src/environments/environment';
import { TariffService } from '../tariff.service';

@Component({
  selector: 'app-edit-tariff',
  templateUrl: './edit-tariff.component.html',
  styleUrls: ['./edit-tariff.component.css']
})
export class EditTariffComponent implements OnInit {

  idtariff: any;
  formField: Observable<any>;
  public DidUpload = environment.SERVER + "uploads/document_upload";
  newFeatures: Observable<any>;
  public tariffForm: FormGroup;
  tariffs: any;
  rates: any;
  header: any;
  headers: any;
  responseMessage = "";
  smsRateForm: FormGroup;
  tollfreeForm: FormGroup;
  shortcodeForm: FormGroup;
  voiceRateForm: FormGroup;
  resAlertMessage = "";
  smsRateData: any;
  DLCRate: any;
  tollfreeRates: any;
  shortCodeRates: any;
  inboundRates: any;
  tariffName: any;
  list: any;

  constructor(private data: UsermanagementService, private fb: FormBuilder,
    private tariffService: TariffService, private route: ActivatedRoute) {
    this.voiceRateForm = this.fb.group({
      id_voicerate: [],
      cvoicerate: [],
      uvoicerate: []
    })
  }

  ngOnInit(): void {

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idtariff = params.get('id');
      this.tariffService.getTariff(this.idtariff).subscribe(res => {
        this.tariffName = res.data[0].name;
      }, err => {
        this.responseMessage = "Something Went Wrong!";
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      })
    });

    this.data.getshortcode().subscribe((result) => {
      this.header = result[0].headerdetails;
      // this.shortCodeRates = result[0].rowlist;
    });

    this.data.getusasms().subscribe((result) => {
      this.headers = result[0].header;
      this.list = result[0].smslist;
    });

    this.newFeatures = this.data.getFeature();

    this.DLCRate = this.tariffService.Get10DLCRate(this.idtariff);

    this.tollfreeRates = this.tariffService.GetTollFreeRates(this.idtariff);

    this.inboundRates = this.tariffService.getRate(this.idtariff);

    this.tariffService.GetVoiceRates(this.idtariff).subscribe(res => {
      let voiceRates = res.data;
      this.voiceRateForm.patchValue({
        id_voicerate: voiceRates.id_voicerate,
        cvoicerate: voiceRates.usa_rate,
        uvoicerate: voiceRates.canada_rate
      })
    });

    this.tariffService.GetSmsRate({ idtariff: this.idtariff, type: "registered" }).subscribe(res => {
      this.smsRateData = res.data;
      let tmp = [];
      res.data.forEach(element => {
        tmp["idsmsrate_" + element.priority] = [element.idsmsrate],
          tmp["category_" + element.priority] = [element.category],
          tmp["MO_" + element.priority] = [element.MO_rates],
          tmp["MT_" + element.priority] = [element.MT_rates]
      });

      this.smsRateForm = this.fb.group(tmp);
    });


    this.tariffService.GetShortCode(this.idtariff).subscribe(res => {
      this.shortCodeRates = res.data;
      let temp = [];
      res.data.forEach(element => {
        temp["idshortcode_" + element.priority] = [element.idshort_code],
          temp["category_" + element.priority] = [element.category],
          temp["outboundSurcharge_" + element.priority] = [element.inbound_message_surcharge];
        temp["inboundSurcharge_" + element.priority] = [element.inbound_message_surcharge];
      });
      this.shortcodeForm = this.fb.group(temp);
    })
  }

  onSaveVoiceRates() {
    this.tariffService.updateVoiceRates(this.voiceRateForm.value).subscribe(response => {
      this.responseMessage = response.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    })
  }

  onshortCodeRates() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];
    response[7] = [];

    for (let key of Object.keys(this.shortcodeForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.shortcodeForm.value[key] });
    }
    let temp = response.slice(1, 7);
    this.tariffService.updateShortCodeRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  SaveRates(event) {
    console.log(event);
  }

  onSmsRates() {

    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];
    response[7] = [];

    for (let key of Object.keys(this.smsRateForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.smsRateForm.value[key] });
    }
    let temp = response.slice(1, 7);
    this.tariffService.updateSMSRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onlyNumber(e) {
    const charCode = (e.which) ? e.which : e.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
      return false;
    }
  }
}
