import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { EditTariffComponent } from './edit-tariff/edit-tariff.component';
import { ListComponent } from './list/list.component';
import { TariffComponent } from './tariff/tariff.component';
import { AddtariffComponent } from './unregistered/addtariff/addtariff.component';
import { EdittariffComponent } from './unregistered/edittariff/edittariff.component';
import { UnregisteredComponent } from './unregistered/unregistered/unregistered.component';
import { SurchargeComponent } from './surcharge/surcharge.component';
import { AddsurchargeComponent } from './addsurcharge/addsurcharge.component';
import { ServiceComponent } from './service/service.component';
import { AddServiceComponent } from './add-service/add-service.component';
import { LerginfoComponent } from './lerginfo/lerginfo.component';
import { OperatorMappingComponent } from './operator-mapping/operator-mapping.component';
import { ZoneComponent } from './zone/zone.component';
import { ClonetariffComponent } from './unregistered/clonetariff/clonetariff.component';

const routes: Routes = [
  {
    path: '',
    children: [
        {
            path: '',
            component: TariffComponent,
            data: {
                title: 'Dashboard',
                urls: [
                    {
                        title: 'Dashboard',
                        url: '/dashboards/dashboard'
                    },
                    {
                        title: 'Dashboard'
                    }
                ]
            }
        },
        {
          path: 'registered',
          component: ListComponent,
          data: {
              title: 'Registered',
              urls: [
                  {
                      title: 'Tariff Management',
                    //   url: 'tariff'
                  },
                  {
                      title: 'Registered'
                  }
              ]
          }
      },

      {
        path: 'surcharge',
        component: SurchargeComponent,
        data: {
            title: 'Surcharge',
            urls: [
                {
                    title: 'Tariff Management',
                 
                },
                {
                    title: 'Surcharge'
                }
            ]
        }
    },


    {
        path: 'zone',
        component: ZoneComponent,
        data: {
            title: 'Zone',
            urls: [
                {
                    title: 'Tariff Management',
                 
                },
                {
                    title: 'Zone Info'
                }
            ]
        }
    },
     
      {
        path: 'addtariff',
        component: AddtariffComponent,
        data: {
            title: 'Unregistered',
            urls: [
                {
                    title: 'Tariff Management',
                  //   url: 'tariff'
                },
                {
                    title: 'Unregistered'
                }
            ]
        }
    },
      {
        path: 'unregistered',
        component: UnregisteredComponent,
        data: {
            title: 'Unregistered',
            urls: [
                {
                    title: 'Tariff Management',
                  //   url: 'tariff'
                },
                {
                    title: 'Unregistered'
                }
            ]
        }
    },
    {
        path: 'edit-tariff/:id',
        component: EditTariffComponent,
        data: {
            title: 'Tariff Management',
            urls: [
                {
                    title: 'Tariff Management',
                  //   url: 'tariff'
                },
                {
                    title: 'Tariff'
                }
            ]
        }
    },
    {
        path: 'add-tariff',
        component: TariffComponent,
        data: {
            title: 'Tariff Management',
            urls: [
                {
                    title: 'Tariff Management',
                  //   url: 'tariff'
                },
                {
                    title: 'Tariff'
                }
            ]
        }
    },
    {
        path: 'add-surcharge',
        component: AddsurchargeComponent,
        data: {
            title: 'Add Surcharge',
            urls: [
                {
                    title: 'Tariff Management',
                  //   url: 'tariff'
                },
                {
                    title: 'Add Surcharge'
                }
            ]
        }
    },
    {
        path: 'surcharge/:id',
        component: AddsurchargeComponent,
        data: {
            title: 'Add Surcharge',
            urls: [
                {
                    title: 'Tariff Management',
                  //   url: 'tariff'
                },
                {
                    title: 'Add Surcharge'
                }
            ]
        }
    },
    {
        path: 'edittariff/:id',
        component: EdittariffComponent,
        data: {
            title: 'Tariff Management',
            urls: [
                {
                    title: 'Tariff Management',
                  //   url: 'tariff'
                },
                {
                    title: 'Tariff'
                }
            ]
        }
    },
    {
        path: 'clonetariff/:id',
        component: ClonetariffComponent,
        data: {
            title: 'Tariff Copy',
            urls: [
                {
                    title: 'Tariff Management',
                  //   url: 'tariff'
                },
                {
                    title: 'Copy Tariff'
                }
            ]
        }
    },
    {
        path: 'service',
        component: ServiceComponent,
        data: {
            title: 'Preference Service',
            urls: [
                {
                    title: 'Preference Service',
                  //   url: 'tariff'
                },
                {
                    title: 'Preference Service'
                }
            ]
        }
    },
    {
        path: 'add-service',
        component: AddServiceComponent,
        data: {
            title: 'Add Service',
            urls: [
                {
                    title: 'Add Service',
                  //   url: 'tariff'
                },
                {
                    title: 'Add Service'
                }
            ]
        }
    },
    {
        path: 'edit-service/:id',
        component: AddServiceComponent,
        data: {
            title: 'Edit Service',
            urls: [
                {
                    title: 'Edit Service',
                  //   url: 'tariff'
                },
                {
                    title: 'Edit Service'
                }
            ]
        }
    },
    {
        path: 'upload_lerg',
        component: LerginfoComponent,
        data: {
            title: 'Upload Lerg Info',
            urls: [
                {
                    title: 'Upload Lerg Info',
                  //   url: 'tariff'
                },
                {
                    title: 'Upload Lerg Info'
                }
            ]
        }
    },
    {
        path: 'operator-mapping',
        component: OperatorMappingComponent,
        data: {
            title: 'Operator Mapping',
            urls: [
                {
                    title: 'Operator Mapping',
                  //   url: 'tariff'
                },
                {
                    title: 'Operator Mapping'
                }
            ]
        }
    }
    ]
}
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class TariffRoutingModule { }
