import { Component, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { TariffService } from '../../tariff.service';
import {MatAccordion} from '@angular/material/expansion';

@Component({
  selector: 'app-addtariff',
  templateUrl: './addtariff.component.html',
  styleUrls: ['./addtariff.component.css']
})

export class AddtariffComponent implements OnInit {
	@ViewChild(MatAccordion) accordion: MatAccordion;
	rowdata: any;
	filterTerm: string
	count = 0;
	tableSize: any;
	page: number;
	headerdetails: any;
  tariffForm: FormGroup;
  resAlertMessage = "";
  responseMessage: any = "";
  submitted: boolean = false;
  status: boolean = false;
  addedTariff: any;
  idtariff: any;
  voiceApiForm: FormGroup;
  headerApi: any;
  voiceApiFields: any;
  iVoiceHeader: any;
  iVoiceFields: any;
  iVoiceForm: any;
  numberPriceForm: FormGroup;
  numberFields: any;
  numberHeader: any;
  depthFields: any;
  depthHeader: any;
  depthForm: FormGroup;
  sipForm: FormGroup;
  sipFields: any;
  sipHeader: any;
  iSipHeader: any;
  iSipFields: any;
  iSipForm: FormGroup;
  sipNumberForm: FormGroup;
  sipNumberFields: any;
  sipNumberHeader: any;
  depthSipForm: FormGroup;
  depthSipHeader: any;
  depthSipFields: any;
  msgActForm: FormGroup;
  msgFields: any;
  msgHeader: any;
  smsHeader: any;
  smsFields: any;
  smsRateForm: FormGroup;
  rateType: boolean = false;

  constructor(private data: TariffService, 
    private fb: FormBuilder, 
   ) { 

    }

  ngOnInit(): void {

    this.tariffForm = this.fb.group({
      type: [],
      name:[ '', [Validators.required, Validators.minLength(3)]],
      description: ['', [Validators.required, Validators.minLength(10)]],
    });

    this.data.get_voiceapi().subscribe(res => {
      this.headerApi = res[0].header;
      this.voiceApiFields = res[0].fields;
      let voiceApiField= [];
      this.voiceApiFields.forEach(element => {
        voiceApiField["priority_" +element.priority] = [element.priority],
        voiceApiField["idtariff_"+element.priority] = [this.idtariff],
        voiceApiField["type_"+element.priority] = ["voice"],
        voiceApiField["subtype_"+element.priority] = ["voice_api"],
        voiceApiField["category_" +element.priority] = [element.categoryValue],
        voiceApiField["mo_" +element.priority] = [0],
        voiceApiField["mt_" +element.priority] = [0]
      });
      this.voiceApiForm = this.fb.group(voiceApiField);


      this.iVoiceHeader = res[1].header1;
      this.iVoiceFields = res[1].fields1;
      let iVoiceFields1$ = [];
      this.iVoiceFields.forEach(element => {
        iVoiceFields1$["priority_" +element.priority] = [element.priority],
        iVoiceFields1$["idtariff_"+element.priority] = [this.idtariff],
        iVoiceFields1$["type_"+element.priority] = ["voice"],
        iVoiceFields1$["subtype_"+element.priority] = ["inteligent"],
        iVoiceFields1$["category_" +element.priority] = [element.categoryValue],
        iVoiceFields1$["price_" +element.priority] = [0]
      });
      this.iVoiceForm = this.fb.group(iVoiceFields1$);

      this.numberHeader = res[2].header2;
      this.numberFields = res[2].fields2;
      let numberFields$ = [];
      this.numberFields.forEach(element => {
        numberFields$["priority_" +element.priority] = [element.priority],
        numberFields$["idtariff_"+element.priority] = [this.idtariff],
        numberFields$["type_"+element.priority] = ["voice"],
        numberFields$["subtype_"+element.priority] = ["number"],
        numberFields$["category_" +element.priority] = [element.categoryValue],
        numberFields$["price_" +element.priority] = [0]
      });
      this.numberPriceForm = this.fb.group(numberFields$);

      this.depthHeader = res[3].header3;
      this.depthFields = res[3].fields3;
      let depthFields$ = [];
      this.depthFields.forEach(element => {
        depthFields$["priority_" +element.priority] = [element.priority],
        depthFields$["idtariff_" +element.priority] = [this.idtariff],
        depthFields$["type_"+element.priority] = ["voice"],
        depthFields$["subtype_"+element.priority] = ["depth_voice"],
        depthFields$["category_" +element.priority] = [element.categoryValue],
        depthFields$["mo_" +element.priority] = [0],
        depthFields$["mt_" +element.priority] = [0]
      });
      this.depthForm = this.fb.group(depthFields$);

  });

  this.data.get_elasticSip().subscribe(res => {
    this.sipFields = res[0].fields;
    this.sipHeader = res[0].header;
    let sipFields$ = [];
    this.sipFields.forEach(element => {
      sipFields$["priority_" +element.priority] = [element.priority],
      sipFields$["idtariff_" +element.priority] = [this.idtariff],
      sipFields$["type_"+element.priority] = ["elastic"],
      sipFields$["subtype_"+element.priority] = ["sip_trunking"],
      sipFields$["category_" +element.priority] = [element.categoryValue],
      sipFields$["mo_" +element.priority] = [0],
      sipFields$["mt_" +element.priority] = [0]
    });
     this.sipForm = this.fb.group(sipFields$);

     this.iSipFields = res[1].fields1;
     this.iSipHeader = res[1].header1;
     let iSipFields$ = [];
     this.iSipFields.forEach(element => {
      iSipFields$["priority_" +element.priority] = [element.priority],
      iSipFields$["idtariff_"+element.priority] = [this.idtariff],
      iSipFields$["type_"+element.priority] = ["elastic"],
      iSipFields$["subtype_"+element.priority] = ["inteligent"],
      iSipFields$["category_" +element.priority] = [element.categoryValue],
      iSipFields$["price_" +element.priority] = [0]
     });
      this.iSipForm = this.fb.group(iSipFields$);

      this.sipNumberFields = res[2].fields2;
      this.sipNumberHeader = res[2].header2;
      let sipNumberFields$ = [];
      this.sipNumberFields.forEach(element => {
        sipNumberFields$["priority_" +element.priority] = [element.priority],
        sipNumberFields$["idtariff_"+element.priority] = [this.idtariff],
        sipNumberFields$["type_"+element.priority] = ["elastic"],
        sipNumberFields$["subtype_"+element.priority] = ["number"],
        sipNumberFields$["category_" +element.priority] = [element.categoryValue],
        sipNumberFields$["price_" +element.priority] = [0]
      });
      this.sipNumberForm = this.fb.group(sipNumberFields$);

      this.depthSipFields = res[3].fields3;
      this.depthSipHeader = res[3].header3;
      let depthSipFields$ = [];
      this.depthSipFields.forEach(element => {
        depthSipFields$["priority_" +element.priority] = [element.priority],
        depthSipFields$["idtariff_" +element.priority] = [this.idtariff],
        depthSipFields$["type_"+element.priority] = ["elastic"],
        depthSipFields$["subtype_"+element.priority] = ["depth_voice"],
        depthSipFields$["category_" +element.priority] = [element.categoryValue],
        depthSipFields$["mo_" +element.priority] = [0],
        depthSipFields$["mt_" +element.priority] = [0]
      });
      this.depthSipForm = this.fb.group(depthSipFields$);
  });

  this.data.get_MessagePricing().subscribe(res => {

    this.smsHeader = res[5].header5;
    this.smsFields = res[5].fields5;

    	let tmp=[];
				this.smsFields.forEach(element => {
				  tmp["priority_"+ element.priority] = [element.priority],
				  tmp["idtariff_"+ element.priority] = [this.idtariff],
				  tmp["category_"+ element.priority] = [element.categoryValue],
				  tmp["categoryValue_"+ element.priority] = [element.category],
				  tmp["subCategory_"+ element.priority] = [element.SubCategory],
          tmp["type_" +element.priority] = ["unregistered"],
				  tmp["MO_"+element.priority]=[0],
				  tmp["MT_"+element.priority]=[0]
				});
				this.smsRateForm = this.fb.group(tmp);

        this.msgHeader = res[1].header1;
        this.msgFields = res[1].fields1;
        let msgFields$ = [];
        this.msgFields.forEach(element => {
          msgFields$["priority_" +element.priority] = [element.priority],
          msgFields$["idtariff_" +element.priority] = [this.idtariff],
          msgFields$["type_"+element.priority] = ["message"],
          msgFields$["subtype_"+element.priority] = ["message_activation"],
          msgFields$["category_" +element.priority] = [element.categoryValue],
          msgFields$["price_" +element.priority] = [0],
          msgFields$["rateType_"+element.priority] = [this.rateType];
        });
        this.msgActForm = this.fb.group(msgFields$);
      });
  }

  saveTariff(){
		this.submitted = true;
		if(this.tariffForm.invalid){
			return false;
		}
		else{
			this.data.saveTariff(this.tariffForm.value).subscribe(res => {
				if(res.data){
					this.addedTariff = res.data[0].name;
					this.idtariff = res.data[0].idtariff;
					this.status = true;
					this.responseMessage=res.message;
					setTimeout(()=>{
						this.responseMessage= "";
					  }, 5000);
				
            this.data.getUnregisteredRate({idtariff :this.idtariff, type: "voice", subtype: "voice_api"}).subscribe(res => {
              // this.voiceApiFields = res.data;
              let tmp=[];	
              res.data.forEach(element => {
                tmp["idrates_"+ element.priority] = [element.idrates],
                tmp["category_"+ element.priority] = [element.category],
                tmp["mo_"+element.priority]=[element.mo],
                tmp["mt_"+element.priority]=[element.mt]
              });
              
              this.voiceApiForm = this.fb.group(tmp);
            });
      
            this.data.getUnregisteredRate({idtariff :this.idtariff, type: "voice", subtype: "inteligent"}).subscribe(res => {
              // this.voiceApiFields = res.data;
              let tmp=[];	
              res.data.forEach(element => {
                tmp["idrates_"+ element.priority] = [element.idrates],
                tmp["category_"+ element.priority] = [element.category],
                tmp["price_"+element.priority]=[element.rate]
                // tmp["mt_"+element.priority]=[element.mt]
              });
              this.iVoiceForm = this.fb.group(tmp);
    
            });

            this.data.getUnregisteredRate({idtariff :this.idtariff, type: "voice", subtype: "number"}).subscribe(res => {
              let tmp=[];	
              res.data.forEach(element => {
                tmp["idrates_"+ element.priority] = [element.idrates],
                tmp["category_"+ element.priority] = [element.category],
                tmp["price_"+element.priority] = [element.rate]
              });
              
              this.numberPriceForm = this.fb.group(tmp);
            });

            this.data.getUnregisteredRate({idtariff :this.idtariff, type: "voice", subtype: "depth_voice"}).subscribe(res => {
              let tmp=[];	
              res.data.forEach(element => {
                tmp["idrates_"+ element.priority] = [element.idrates],
                tmp["category_"+ element.priority] = [element.category],
                tmp["mo_"+element.priority] = [element.mo],
                tmp["mt_"+element.priority] = [element.mt]
              });
              
              this.depthForm = this.fb.group(tmp);
            });

            this.data.getUnregisteredRate({idtariff :this.idtariff, type: "elastic", subtype: "sip_trunking"}).subscribe(res => {
              let tmp=[];	
              res.data.forEach(element => {
                tmp["idrates_"+ element.priority] = [element.idrates],
                tmp["category_"+ element.priority] = [element.category],
                tmp["mo_"+element.priority] = [element.mo],
                tmp["mt_"+element.priority] = [element.mt]
              });
              
              this.sipForm = this.fb.group(tmp);
            });

            this.data.getUnregisteredRate({idtariff :this.idtariff, type: "elastic", subtype: "inteligent"}).subscribe(res => {
              let tmp=[];	
              res.data.forEach(element => {
                tmp["idrates_"+ element.priority] = [element.idrates],
                tmp["category_"+ element.priority] = [element.category],
                tmp["price_"+element.priority] = [element.rate]
              });
              
              this.iSipForm = this.fb.group(tmp);
            });

            this.data.getUnregisteredRate({idtariff :this.idtariff, type: "elastic", subtype: "number"}).subscribe(res => {
              let tmp=[];	
              res.data.forEach(element => {
                tmp["idrates_"+ element.priority] = [element.idrates],
                tmp["category_"+ element.priority] = [element.category],
                tmp["price_"+element.priority] = [element.rate]
              });
              
              this.sipNumberForm = this.fb.group(tmp);
            });

            this.data.getUnregisteredRate({idtariff :this.idtariff, type: "elastic", subtype: "depth_voice"}).subscribe(res => {
              let tmp=[];	
              res.data.forEach(element => {
                tmp["idrates_"+ element.priority] = [element.idrates],
                tmp["category_"+ element.priority] = [element.category],
                tmp["mo_"+element.priority] = [element.mo],
                tmp["mt_"+element.priority] = [element.mt]
              });
              
              this.depthSipForm = this.fb.group(tmp);
            });

            this.data.GetSmsRate({idtariff: this.idtariff, type: "unregistered"}).subscribe(res => {
              let tmp=[];	
              res.data.forEach(element => {
                tmp["idsmsrate_"+ element.priority] = [element.idsmsrate],
                tmp["category_"+ element.priority] = [element.category],
                tmp["MO_"+element.priority]=[element.MO_rates],
                tmp["MT_"+element.priority]=[element.MT_rates]
              });
              this.smsRateForm = this.fb.group(tmp);
            });

            this.data.getUnregisteredRate({idtariff :this.idtariff, type: "message", subtype: "message_activation"}).subscribe(res => {
              let tmp=[];	
              res.data.forEach(element => {
                this.rateType = element.rateType; 
                tmp["idrates_"+ element.priority] = [element.idrates],
                tmp["category_"+ element.priority] = [element.category],
                tmp["price_"+element.priority] = [element.rate],
                tmp["rateType_"+element.priority]=[element.rateType]
              });
              this.msgActForm = this.fb.group(tmp);
            });
				}
				else{
					this.resAlertMessage = res.message;
					setTimeout(()=>{
						this.resAlertMessage= "";
					  }, 5000);
				}
			});
		}
	}
  
  onRateTypes(e){
      this.rateType = e.target.checked;
  }

  onVoiceApi(){
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];
    response[4]=[];

		for(let key of Object.keys(this.voiceApiForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.voiceApiForm.value[key]});
		}
			let temp = response.slice(1, 4);
			this.data.updateVoiceRate(temp).subscribe(resp => {
			      this.responseMessage = resp.message;  
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
			}, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
      });
  }

  oniVoice() {
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];
    response[4]=[];
    response[5]=[];
    response[6]=[];

		for(let key of Object.keys(this.iVoiceForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.iVoiceForm.value[key]});
		}
			let temp = response.slice(1, 6);
			this.data.updateVoiceRate(temp).subscribe(resp => {
			      this.responseMessage = resp.message;  
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
			}, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
      });
  }

  onNumberPrice(){
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];

		for(let key of Object.keys(this.numberPriceForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.numberPriceForm.value[key]});
		}
			let temp = response.slice(1, 3);
			this.data.updateVoiceRate(temp).subscribe(resp => {
			      this.responseMessage = resp.message;  
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
			}, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
      });
  }

  onDepthRate() {
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];
    response[4]=[];
    response[5]=[];
    response[6]=[];
    response[7]=[];

		for(let key of Object.keys(this.depthForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.depthForm.value[key]});
		}
			let temp = response.slice(1, 7);
			this.data.updateVoiceRate(temp).subscribe(resp => {
			      this.responseMessage = resp.message;  
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
			}, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
      });
  }

  onSipPrice(){
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];

		for(let key of Object.keys(this.sipForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.sipForm.value[key]});
		}
			let temp = response.slice(1, 3);
			this.data.updateVoiceRate(temp).subscribe(resp => {
			      this.responseMessage = resp.message;  
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
			}, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
      });
  }

  oniSipPrice(){
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];
    response[4]=[];
    response[5]=[];
    response[6]=[];
    response[7]=[];

		for(let key of Object.keys(this.iSipForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.iSipForm.value[key]});
		}
			let temp = response.slice(1, 7);
			this.data.updateVoiceRate(temp).subscribe(resp => {
			      this.responseMessage = resp.message;  
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
			}, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
      });
  }

  onSipNumber(){
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];	

		for(let key of Object.keys(this.sipNumberForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.sipNumberForm.value[key]});
		}
			let temp = response.slice(1, 3);
			this.data.updateVoiceRate(temp).subscribe(resp => {
			      this.responseMessage = resp.message;  
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
			}, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
      });
  }

  onDepthSipRate(){
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];
    response[4]=[];
    response[5]=[];
    response[6]=[];
    response[7]=[];

		for(let key of Object.keys(this.depthSipForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.depthSipForm.value[key]});
		}
			let temp = response.slice(1, 7);
			this.data.updateVoiceRate(temp).subscribe(resp => {
			      this.responseMessage = resp.message;  
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
			}, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
      });
  }

  onSmsRates() {
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];
		response[4]=[];
		response[5]=[];
		response[6]=[];
		response[7]=[];

		for(let key of Object.keys(this.smsRateForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.smsRateForm.value[key]});
		}
		let temp = response.slice(1, 7);
		this.data.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;  
			setTimeout(()=>{
			this.responseMessage= "";
			}, 5000);
		});
  }


  msgActivationRates(){
    let response: any = [];
		response[0]=[];
		response[1]=[];
		response[2]=[];
		response[3]=[];
    response[4]=[];
    response[5]=[];
    response[6]=[];
    response[7]=[];

		for(let key of Object.keys(this.msgActForm.value)){
		  let tmp=key.split('_');
		  response[tmp[1]].push({field: tmp[0], value: this.msgActForm.value[key]});
		}
			let temp = response.slice(1, 7);
			this.data.updateVoiceRate(temp).subscribe(resp => {
			      this.responseMessage = resp.message;  
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
			}, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
      });
  }

  onTableSizeChange(event): void {
    this.tableSize = event.target.value;
    this.page = 1;
  } 
    
  onTableDataChange(event){
    this.page = event.length;   
  } 
}
