import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { TariffService } from '../../tariff.service';

@Component({
  selector: 'app-unregistered',
  templateUrl: './unregistered.component.html',
  styleUrls: ['./unregistered.component.css']
})

export class UnregisteredComponent implements OnInit {hide:boolean=true;
  
  tariffs: any;
  searchText = { count: 0 };
	filtre: string;
  page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
  filterTerm: string;
	row: any;
	idtariff: any;
  tariffForm: FormGroup;
  responseMessage = "";
  tariffsName: any;
  tariffLength: any;

  constructor(
    private data: UsermanagementService,
    private tariffService: TariffService,
    private fb: FormBuilder) { }

  ngOnInit(): void {
    this.tariffForm=this.fb.group({
      id: [],
			name:[],
			description: [],
		});
    
    this.tariffService.getTariffs().subscribe(res => {
      this.tariffs = res.data;
      this.tariffLength = this.tariffs.length;
    });
  }

  editModal(data){
    this.tariffForm.setValue({
      id: data.idtariff,
      name: data.name,
      description: data.description
    });
  }


  editTariff(){
      this.tariffService.updateTariff(this.tariffForm.value).subscribe(res => {
        this.responseMessage = res.message;
        if(res.data[0]){
        this.tariffs = res.data[0];
        $.getScript('./assets/table.js');
        }
       
        setTimeout(()=>{
          this.responseMessage= "";
        }, 5000);
      }, err => {
        this.responseMessage = err.message;
        setTimeout(()=>{
          this.responseMessage= "";
        }, 5000);
      });
      this.ngOnInit();
  }

  deleteTariff(idtariff){
    if(confirm("Are you sure you want delete data!")){
      this.tariffService.deleteTariff(idtariff).subscribe(res => {
        this.responseMessage = res.message;
        setTimeout(()=>{
          this.responseMessage= "";
        }, 5000);
      }, err => {
        this.responseMessage = err.message;
        setTimeout( () => {
          this.responseMessage = "";
        }, 5000)
      })
    }else{
      "Cancel!";
    }
    this.ngOnInit();
  }

  onTableSizeChange(event): void {
    this.tableSize = event.target.value;
    this.page = 1;
  }

  onTableDataChange(event){
    this.page = event;
  }

}
