import { assign } from 'assign';


export const THEME_SET="SET";
export const THEME_GET="GET";

export interface ITheme{
    header:string;
    navigation:string;
    logo:string;
    sidebar:string;
}

export const INITIAL_THEME:ITheme={
    header:"blue",
    navigation:"blue",
    logo:"",
    sidebar:"black"
}

export function SetTheme(state:ITheme, action:any): ITheme
{
    switch(action.type)
    {
        case THEME_SET: {
            let cur={header:action.header, navigation: action.navigation, logo: action.logo, sidebar: action.sidebar};
            return assign(state, cur);
        }
        case THEME_GET : {
            return assign(state);
        }

        default: {
            return assign(state);
        }
    }
}