import { Component, OnInit } from '@angular/core';
import {TiermanagementService} from '../tiermanagement.service';
import { Router } from '@angular/router';
import { FormBuilder, FormGroup, FormControl} from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { tiermanagement, tiermanagementForm } from '../tier.class';

@Component({
  selector: 'app-tier',
  templateUrl: './tier.component.html',
  styleUrls: ['./tier.component.css']
})

export class TierComponent extends AppComponentClass<tiermanagement, tiermanagementForm> {

	showMsg: boolean = false;
 	p: number = 1;
	rowdata: any;
	ro: any;
	row: any;
	details: any;
	listdata: any;
	record:any;
	list:any;
	// defaultSelect : any = 1;
	page = 1;
	count = 0;
	tableSize = 5;
	tableSizes = [ 5, 9, 12];
	modelform:any;

  public show: boolean = false;
  public package: any;
  public buttonName: any = "Add";
  public tiermanagementForm: FormGroup;
  public submitted : boolean = false;
  filterTerm: string;
  fileToUpload: File = null;
  file:any;

  constructor(public data: TiermanagementService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  
  ngOnInit(): void {

	this.data.gettier().subscribe((result) => {
			this.listdata = result[0].headers
			this.row = result[0].invoice
			console.log(this.listdata)
		  });

		  this.data.getrecord().subscribe((result) => {
			this.record = result[0].headers_details  ;
			this.list = result[0].profile_details ;
	
			console.log(this.list)
		  });  
  	}

	onSubmit(){
		console.log("data", this.tiermanagementForm);
	}

	downloadMyFile(): void {
		this.data
		  .download('./assets/sample-csv/ratelist-sample.csv')
		  .subscribe(blob => {
			const a = document.createElement('a')
			const objectUrl = URL.createObjectURL(blob)
			a.href = objectUrl
			a.download = 'ratelist-sample.csv';
			a.click();
			URL.revokeObjectURL(objectUrl);
		  })
	  }

	handleFileInput(files) {
		let sessionid = 32;
		let filetype = "agent guide";
		files.item(0)["sessionid"] = sessionid;
		files.item(0)["filetyepe"] = filetype;
		this.fileToUpload = files.item(0);
		console.log(files.item(0));
		this.data.postFile(this.fileToUpload,sessionid,filetype).subscribe(res => {
		  console.log(res);
		  this.file = res.filename;
		  console.log("check1");
		}, error => {
		  console.log(error);
		});
	}
}

