import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { BehaviorSubject, Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { environment } from 'src/environments/environment';
@Injectable({
  providedIn: 'root'
})


  export class TiermanagementService extends AppService<any>  {
    constructor(public http:HttpClient) {
      super(http)
    }
  
    saveData(data: any): Observable<any> {
      let tmp = this.appmod;
      this.appmod = 'tier/save_rate';
      let result = super.saveService(data);
      this.appmod = tmp;
      return result;
    }

    updateData(data: any): Observable<any> {
      let tmp = this.appmod;
      this.appmod = 'tier/update_rate';
      let result = super.saveService(data);
      this.appmod = tmp;
      return result;
    }

    public getFeature():Observable<any> {
      return this.http.get(environment.SERVER + 'tier/get_feature');
    }
  
    public gettier():Observable<any>{
      return this.http.get('./assets/tier.json');
    }
    public getrecord():Observable<any>{
      return this.http.get('./assets/tierreports.json');
    }

    public postFile(fileToUpload: File,sessionid,filetype): Observable<any> {
      console.log("check2");
      console.log(sessionid);
      console.log(filetype);
      const endpoint = environment.SERVER + 'uploads/rate_csv';
      const formData: FormData = new FormData();
      console.log(formData);
      formData.append('fileKey', fileToUpload, fileToUpload.name);
      formData.append('filetype',filetype);
      formData.append('sessionid',sessionid);
      console.log(fileToUpload);
      //console.log(fileToUpload.sessionid);
      let httpHeaders = new HttpHeaders()
      return this.http
        .post(endpoint, formData, { headers: httpHeaders });
        //  .map(() => { return true; })
        //  .catch((e) => this.handleError(e));
  }

  download(url: string): Observable<Blob> {
    return this.http.get(url, {
      responseType: 'blob'
    });
  }
  
  }