import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { Router } from '@angular/router';
import { HttpClient, HttpRequest } from '@angular/common/http'
import { TollfreesmsService } from '../tollfreesms.service';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { Observable } from 'rxjs';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { environment } from 'src/environments/environment';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
  selector: 'app-tollfreesms',
  templateUrl: './tollfreesms.component.html',
  styleUrls: ['./tollfreesms.component.css']
})
export class TollfreesmsComponent implements OnInit {
  @ViewChild('checkboxes') checkboxes: ElementRef;
  @ViewChild('viewalldata11') viewalldata11: ElementRef;
  @ViewChild('viewalldata1') viewalldata1: ElementRef;
  @ViewChild('reject') reject: ElementRef;
  @ViewChild('reject1') reject1: ElementRef;
  show: boolean = false;
  public userInfo: any;
  public userInfo1: any;
  public userInfo2: any;
  public userInfo3: any;
  public rejectForm: any;
  tabs: any = [];
  headers: any = [];
  sendMail: boolean = false;
  tabheader1: any;
  tabheader2: any;
  tabheader3: any;
  tabheader4: any;
  tabheader5: any;
  tabheader6: any;
  tabheader7: any;
  tabheader01: any;
  userType: any;
  iduser: any;
  idaccount: any;
  isShow = false;
  currentFilter: string = 'Pending Review'
  selectedTab: string = '';
  show_filter: boolean = false;
  public tollFree: FormGroup;
  public submitted: boolean = false;
  label: Observable<any>;
  verified: any = [];
  pending: any[];
  rejected: any[];
  verified_started: any[];
  Awaiting: any[];
  verified_rejected: any[];
  verified_approved: any[];
  approved: any[];
  selectedAwait: any = [];
  selectedAwaitCount: any;
  iselectAll: Boolean = false;
  isSelected: Boolean = false;
  isChecked: Boolean = false;
  reviewId: any;
  unique_id: any;
  idaccount1: any;
  iduser1: any;
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  responseMessage: any;
  errMessage: any;
  userData: any;
  batchdata: any;
  filepath: any;
  bach_id: any;
  number: any[];
  checkedNumbers: number[] = [];
  reques_id: any;
  VerifiedfilterCSV: any = [];
  Verifiedfilter: any = [];
  did_sinch: any = [];
  did_status: any = [];
  users: any = [];
  selectedUser: any;
  selectedStatus: any;
  Status: any;
  batchId: boolean = false;
  ShowMessage: boolean;
  user_id: any;
  getVerifyData: any;
  user_acc: any;
  selectAllChecked: boolean = false;
  AssignNum: any;
  public rejectForm1: FormGroup
  AccountID: any;
  UserID: any;
  ProfileID: any;
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  selectedItem: any = [];
  name_with_san: any = [];
  userss: any = [];
dropdownSettingsstatus: IDropdownSettings = {};
  dropdownSettings1: IDropdownSettings = {};
  selectedItem1: any = [];
  idacc: any;
  idpro: any;
  iduse: any;
  Provider: any;
  filterType: any = '1'
  subacount: any;
  provide: any;
  tabheader8: any;
  constructor(public router: Router, private http: HttpClient, public data: TollfreesmsService, public fb: FormBuilder, public _http: HttpClient, private userService: UsermanagementService) { }

  ngOnInit(): void {
    this.selectedAwaitCount = '';
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    this.iduser = session.iduser;
    this.idaccount = session.idaccount;

    /*get headers for all tabs*/
    this.data.get_tollfreeheader().subscribe((result) => {
      this.userInfo = result[0].header;
      this.tabheader1 = this.userInfo[0].tableheaders
      this.tabheader2 = this.userInfo[1].tableheaders
      this.tabheader3 = this.userInfo[2].tableheaders
      this.tabheader4 = this.userInfo[3].tableheaders
      this.tabheader8 = this.userInfo[4].tableheaders
      this.tabheader5 = this.userInfo[5].tableheaders
      this.tabheader6 = this.userInfo[6].tableheaders
      this.tabheader7 = this.userInfo[7].tableheaders
    });

    /*get header for customer*/
    this.data.get_tollfree_detail().subscribe((result) => {
      this.userInfo1 = result;
      this.tabheader01 = this.userInfo1[0].tableheaders
    })

    // starting filter code 
    this.data.get_tollfreeheader().subscribe((result) => {
      this.userInfo2 = result[1].filterheader;
      this.label = this.userInfo2;
      this.userInfo3 = result[2].rejectfield;
      this.Status = result[3].StatusValues;
      this.Provider = result[4].Provider; 
    });

    this.batchData();
    $.getScript('./assets/tollfree.js');
    this.tollFree = this.fb.group({
      from_date: [''],
      to_date: [''],
      Request_Id: [''],
      username: [''],
      statusResponse: [''],
      filter_type: [''],
      batchid: [''],
      provider: ['']
    });
    // end here filter code
    this.Get_VerifiedList()

    this.rejectForm = this.fb.group({
      reject_text: ['', [Validators.required]],
    });

    this.tollFree.patchValue({
      filter_type: this.userType == 1 ? "Pending Review" : ''
    })

    // For showing Username and san of customers
    // this.userService.getUsers("main").subscribe(res => {
    //   if (res.status == 200) {
    //     this.users = res.data[0];
    //     this.users.sort((a, b) => {
    //       return a.san - b.san;
    //     });
    //   }
    //   else {
    //     this.errMessage = res.message;
    //     setTimeout(() => {
    //       this.errMessage = "";
    //     }, 5000);
    //   }
    // }, err => {
    //   this.errMessage = err.message;
    //   setTimeout(() => {
    //     this.errMessage = "";
    //   }, 5000);
    // });

    this.getlistusers();

    this.rejectForm1 = this.fb.group({
      reject_text: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]],
    });

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'name',
      textField: 'Name_san',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    this.dropdownSettings1 = {
      singleSelection: true,
      idField: 'value',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
    this.dropdownSettingsstatus = {
      singleSelection: true,
      idField: 'value',
      textField: 'status',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
 
  }

  getlistusers() {
    this.userService.getidAccount().subscribe(res => {
      if (res.status == 200) {
        this.users = res.data;
        this.users.sort((a, b) => {
          return a.idaccount - b.idaccount;
        });
        // this.users.forEach(element => {
        //   const fullName = `${element.first_name} ${element.last_name}`
        //   this.name_with_san.push({ name: fullName, Name_san: element.san + ' - ' +  fullName});
        // })
        // this.userss = this.name_with_san
        const uniqueUsers = this.users.filter((value, index, self) =>
          index === self.findIndex((t) => t.iduser === value.iduser)
        );
        
        uniqueUsers.forEach(element => {
          const fullName = `${element.first_name} ${element.last_name}`;
          this.name_with_san.push({
            name: element.idaccount + ' - ' + element.iduser,
            Name_san: element.san + ' - ' + fullName
        });
        });
        
        this.userss = this.name_with_san;
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  onItemSelect(item: any) {
    console.log(item);
  }


  filterByUser(ev: any) {
    this.selectedUser = ev.target.value;
  }

  byStatus(ev: any) {
    this.selectedStatus = ev.target.value;
  }


  Get_VerifiedList() {
    // Fetch batch data
    this.data.getBatch().subscribe(res1 => {
      this.data.get_verifySender().subscribe(res => {
        if (res.status == 200) {
          this.getVerifyData = res.data;
          for (const itemVerifySender of res.data) {
            const uniqueRequestId = itemVerifySender.unique_request_id;
            const matchingBatchData = this.batchdata.find(
              batchItem => batchItem.verified_sender_id.includes(uniqueRequestId)
            );

            if (matchingBatchData) {
              itemVerifySender.batch_id = matchingBatchData.batch_id;
            }
          }

          this.verified = [];
          this.pending = [];
          this.rejected = [];
          this.Awaiting = [];
          this.verified_started = [];
          this.verified_rejected = [];
          this.verified_approved = [];
          this.approved = [];

          if (res.data.length > 0) {
            this.verified = res.data;
            if (this.userType == 1) {
              this.verified.forEach((element) => {
                if (element.status == 1) {
                  element.status = 'Pending Review';
                  this.pending.push(element);
                }
                if (element.status == 2) {
                  element.status = 'Rejected';
                  this.rejected.push(element);
                }
                if (element.status == 3) {
                  element.status = 'Awaiting Downstream Processing';
                  this.Awaiting.push(element);
                }
                if (element.status == 4) {
                  element.status = 'Verified Sender Review Process Started';
                  this.verified_started.push(element);
                }
                if (element.status == 5) {
                  element.status = 'Verified Sender Submission Rejected';
                  this.verified_rejected.push(element);
                }
                if (element.status == 6) {
                  element.status = 'Verified Sender Submission Approved';
                  this.verified_approved.push(element);
                }
                if (element.status == 7) {
                  element.status = 'Profile Approved';
                  this.approved.push(element);
                }
              });
            } else {
              this.verified = res.data;
              this.setStatus(this.verified);
              $('#basic-datatables7').dataTable().fnClearTable();
              $('#basic-datatables7').dataTable().fnDraw();
              $('#basic-datatables7').dataTable().fnDestroy();
              $.getScript('./assets/tollfree.js');
            }

            $('#basic-datatables1').dataTable().fnClearTable();
            $('#basic-datatables1').dataTable().fnDraw();
            $('#basic-datatables1').dataTable().fnDestroy();

            $('#basic-datatables2').dataTable().fnClearTable();
            $('#basic-datatables2').dataTable().fnDraw();
            $('#basic-datatables2').dataTable().fnDestroy();

            $('#basic-datatables3').dataTable().fnClearTable();
            $('#basic-datatables3').dataTable().fnDraw();
            $('#basic-datatables3').dataTable().fnDestroy();

            $('#basic-datatables13').dataTable().fnClearTable();
            $('#basic-datatables13').dataTable().fnDraw();
            $('#basic-datatables13').dataTable().fnDestroy();

            $('#basic-datatables11').dataTable().fnClearTable();
            $('#basic-datatables11').dataTable().fnDraw();
            $('#basic-datatables11').dataTable().fnDestroy();

            $('#basic-datatables12').dataTable().fnClearTable();
            $('#basic-datatables12').dataTable().fnDraw();
            $('#basic-datatables12').dataTable().fnDestroy();

            $('#basic-datatables2a').dataTable().fnClearTable();
            $('#basic-datatables2a').dataTable().fnDraw();
            $('#basic-datatables2a').dataTable().fnDestroy();

            $.getScript('./assets/tollfree.js');

          }
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      });
    })
  }


  onSelectAll(e) {
    if (e.target.checked) {
      this.selectedAwait = [];
      this.Awaiting.forEach((ele: any) => {
        ele.isChecked = true;
        this.selectedAwait.push(ele);
      });
    }
    else {
      this.iselectAll = false;
      this.selectedAwait = [];
      this.Awaiting.forEach((ele: any) => {
        ele.isChecked = false;
      });
    }
    if (this.selectedAwait.length == this.Awaiting.length) {
      this.iselectAll = true;
    }
    else {
      this.iselectAll = false;
    }
    this.selectedAwaitCount = this.selectedAwait.length;
  }

  onSelectAwait(e, data, idx) {
    if (e.target.checked) {
      this.selectedAwait.push(data);
    } else {
      this.selectedAwait = this.selectedAwait.filter(item => item.unique_request_id !== data.unique_request_id);
    }

    if (this.selectedAwait.length === this.Awaiting.length) {
      this.iselectAll = true;
    } else {
      this.iselectAll = false;
    }

    this.isSelected = this.selectedAwait.length > 0;
    this.selectedAwaitCount = this.selectedAwait.length;
  }


  showbtn1(data: any) {
    // Add more conditions for other tabs if needed
    if (data === 'Awaiting Downstream Processing') {
      this.sendMail = true;
      this.currentFilter = 'Awaiting Downstream Processing';
      this.filterType = '3'
    } else if (data === 'Verified Sender Review Process Started') {
      this.sendMail = false;
      this.currentFilter = 'Verified Sender Review Process Started';
      this.filterType = '4'
    } else if (data === 'Verified Sender Submission Rejected') {
      this.sendMail = false;
      this.currentFilter = 'Verified Sender Submission Rejected';
      this.filterType = '5'
    } else if (data === 'Verified Sender Submission Approved') {
      this.sendMail = false;
      this.currentFilter = 'Verified Sender Submission Approved';
      this.filterType = '6'
    } else if (data === 'Email Sent to INTQ') {
      this.sendMail = false;
      this.currentFilter = 'Email Sent to INTQ';
      this.filterType = '7'
    } else if ((data === 'Rejected')) {
      this.sendMail = false;
      this.currentFilter = 'Rejected';
      this.filterType = '2'
 
    } else if ((data === 'Approved')) {
      this.sendMail = false;
      this.currentFilter = 'Approved';
      this.filterType = '8'
 
    }
    else {
      this.sendMail = false;
      this.currentFilter = 'Pending Review';
      this.filterType = '1'
 
    }
    if (data === 'Email Sent to INTQ') {
      this.batchId = true;
    } else {
      this.batchId = false;
    }
    this.tollFree.reset();
    this.tollFree.patchValue({
      filter_type: this.userType == 1 ? data : ''
    })
  }
 

  checkStatus = (num: number): void => {
    this.checkedNumbers = this.checkedNumbers.includes(num)
      ? this.checkedNumbers.filter((n) => n !== num)
      : [...this.checkedNumbers, num];

    if (this.checkedNumbers.length === 0) {
      this.isShow = false;
    } else {
      this.isShow = true;
    }

    this.selectAllChecked = this.did_status
      .filter((num) => num.sinch_status === '15')
      .every((num) => this.checkedNumbers.includes(num.did));
  };

  /*for filter function*/
  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }

  }


  /*for getting request IDs*/
  sendmailid() {
    const selectedCheckboxIds = this.selectedAwait.map(item => item.unique_request_id);
    let data = {
      requestId: selectedCheckboxIds
    }
    if (confirm("Please click on 'OK' to Submit ")) {
      this.data.sendMailIds(data).subscribe((res) => {
        if (res.status == 200) {
          let manageDID = res.data;
          if (manageDID.length > 0) {
            const groupedData = this.groupfiles_and_did(manageDID);
            const formattedData = this.formatKeysForExcel(groupedData);
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(formattedData);
            const workbook: XLSX.WorkBook = { Sheets: { 'did': worksheet }, SheetNames: ['did'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
            this.saveAsExcelFile(excelBuffer);
          } else {
            this.errMessage = "Data is not Available";
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    } else {
      this.router.navigateByUrl['/toll-free-sms']
    }
  }

formatKeysForExcel(data: any[]): any[] {
  return data.map(item => {
    const newItem: any = {};
    Object.keys(item).forEach(key => {
      const formattedKey = key
        .replace(/_/g, ' ')                    
        .replace(/\w\S*/g, (txt) =>            
          txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase()
        );
      newItem[formattedKey] = item[key];
    });
    return newItem;
  });
}
  groupfiles_and_did(data) {
    const groupedData = {};
  
    data.forEach(entry => {
      const trimmedPhoneNumber = entry.Phone_Numbers.trim();
      const Additional = entry.Additional_Opt_In_Information.trim(); 
      if (!groupedData[entry.REquest_ID]) {
        groupedData[entry.REquest_ID] = {
          ...entry,
          Phone_Numbers: trimmedPhoneNumber,
          Additional_Opt_In_Information: Additional,
        };
      } else {
        groupedData[entry.REquest_ID].Additional_Opt_In_Information += '; ' + Additional;
        if (!groupedData[entry.REquest_ID].Phone_Numbers.includes(trimmedPhoneNumber)) {
          groupedData[entry.REquest_ID].Phone_Numbers += '; ' + trimmedPhoneNumber;
        }
      }
      delete groupedData[entry.REquest_ID].REquest_ID;
    });
  
    return Object.values(groupedData);
  }

  saveAsExcelFile(csvFile: string): void {
    const selectedCheckboxIds = this.selectedAwait.map(item => item.unique_request_id);
    var target = environment.SERVER + "sentMailtoIntq";
    let data = JSON.stringify({
      requestId: selectedCheckboxIds
    })
    const blob = new Blob([csvFile], { type: 'text/csv' });
    const formData = new FormData();
    formData.append('ATTACHMENTS', blob, "file.csv");
    formData.append('data', data)
    const token = sessionStorage.getItem('authkey');
    this.http.post(target, formData, { headers: { "Authorization": `${token}` } })
      .subscribe((res: any) => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            window.location.reload()
            this.responseMessage = "";
          }, 3000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      }
      );
  }

  selectAll(): void {
    if (this.did_status && this.did_status.length > 0) {
      if (this.selectAllChecked) {
        this.checkedNumbers = this.did_status
          .filter((num) => num.sinch_status === '15')
          .map((num) => num.did);
      } else {
        this.checkedNumbers = [];
      }
    }

    this.did_status.forEach((num) => {
      if (num.sinch_status === '15') {
        num.isChecked = this.selectAllChecked;
      }
    });

    this.isShow = this.checkedNumbers.length > 0;
  }

  setStatus(list) {
    list.forEach(element => {
      if (element.status == 1) {
        element.status = 'Pending Review'
      }
      if (element.status == 2) {
        element.status = 'Rejected'
      }
      if (element.status == 3) {
        element.status = 'Awaiting Downstream Processing'
      }
      if (element.status == 4) {
        element.status = 'Verified Sender Review Process Started'
      }
      if (element.status == 5) {
        element.status = 'Verified Sender Submission Rejected'
      }
      if (element.status == 6) {
        element.status = 'Verified Sender Submission Approved'
      }
      if (element.status == 7) {
        element.status = 'Profile Approved'
      }
    })
  }

  verifyReview(id: any) {
    this.reviewId = id;
    const user = this.getVerifyData.find(
      (user) => user.unique_request_id === this.reviewId
    );
    this.user_id = user.iduser;
    this.user_acc = user.idaccount;
    let data = {
      iduser: this.user_id,
      idaccount: this.user_acc,
      id: this.reviewId,
    };

    this.data.approveReview(data).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        this.Get_VerifiedList();
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }

    })
  }


  /*for filter process*/
  onSubmitfilter() {
    this.submitted = true;
    if (this.tollFree.invalid) {
      return false;
    } else {

      if (this.selectedItem && this.selectedItem.length > 0) {
        this.tollFree.value.username = this.selectedItem[0].name.split(' - ')[0];
      } else {
        this.tollFree.value.username = '';
      }
      
      // if (Array.isArray(this.tollFree.value.statusResponse) && this.tollFree.value.statusResponse.length > 0) {
      //   this.tollFree.value.statusResponse = this.tollFree.value.statusResponse[0].value;
      // } else {
      //   this.tollFree.value.statusResponse = '';
      // }
      const selectedStatusValue = this.tollFree.get('statusResponse').value;
      this.tollFree.value.statusResponse =  Array.isArray(selectedStatusValue) && selectedStatusValue.length > 0
      ? selectedStatusValue[0].value
      : selectedStatusValue || this.selectedStatus || ''
      this.tollFree.value.provider = this.selectedItem1?.[0]?.value || '';      
 
      this.data.applyTollfreeFilter(this.tollFree.value).subscribe((res) => {
        if (res.status == 200) {
          this.Verifiedfilter = res.data;
          this.VerifiedfilterCSV = res.data;
          for (const itemVerifySender of this.Verifiedfilter) {
            const uniqueRequestId = itemVerifySender.unique_request_id;
            const matchingBatchData = this.batchdata.find(
              batchItem => batchItem.verified_sender_id && batchItem.verified_sender_id.includes(uniqueRequestId)
            );

            if (matchingBatchData) {
              itemVerifySender.batch_id = matchingBatchData.batch_id;
            }
          }

          if (this.userType == 1) {
            if (this.currentFilter == 'Pending Review') {
              $('#basic-datatables1').DataTable().clear();
              $('#basic-datatables1').DataTable().destroy();
              this.pending = this.Verifiedfilter;
              this.setStatus(this.pending);
            }
            if (this.currentFilter == 'Rejected') {
              $('#basic-datatables2').DataTable().clear();
              $('#basic-datatables2').DataTable().destroy();
              this.rejected = this.Verifiedfilter;
              this.setStatus(this.rejected);
            }
            if (this.currentFilter == 'Awaiting Downstream Processing') {
              $('#basic-datatables3').DataTable().clear();
              $('#basic-datatables3').DataTable().destroy();
              this.Awaiting = this.Verifiedfilter;
              this.setStatus(this.Awaiting);
            }
            if (
              this.currentFilter == 'Verified Sender Review Process Started'
            ) {
              $('#basic-datatables13').DataTable().clear();
              $('#basic-datatables13').DataTable().destroy();
              this.verified_started = this.Verifiedfilter;
              this.setStatus(this.verified_started);
            }
            if (this.currentFilter == 'Verified Sender Submission Rejected') {
              $('#basic-datatables11').DataTable().clear();
              $('#basic-datatables11').DataTable().destroy();
              this.verified_rejected = this.Verifiedfilter;
              this.setStatus(this.verified_rejected);
            }
            if (this.currentFilter == 'Verified Sender Submission Approved') {
              $('#basic-datatables12').DataTable().clear();
              $('#basic-datatables12').DataTable().destroy();
              this.verified_approved = this.Verifiedfilter;
              this.setStatus(this.verified_approved);
            }
            if (this.currentFilter == 'Approved') {
              $('#basic-datatables2a').DataTable().clear();
              $('#basic-datatables2a').DataTable().destroy();
              this.approved = this.Verifiedfilter;
              this.setStatus(this.approved);
            }
          } else {
            $('#basic-datatables7').DataTable().clear();
            $('#basic-datatables7').DataTable().destroy();
            this.verified = this.Verifiedfilter;
            this.setStatus(this.verified);
          }
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      });
    }
  }

  /*for email Send filter*/
  Emailfilter() {
    this.submitted = true;

    if (this.tollFree.invalid) {
      return false;
    } else {

      this.data.emailTollfreeFilter(this.tollFree.value).subscribe(res => {
        if (res.status == 200) {
          this.Verifiedfilter = res.data;
          this.VerifiedfilterCSV = res.data;
          if (this.userType == 1) {
            if (this.currentFilter == "Email Sent to INTQ") {

              $('#basic-datatabless').DataTable().clear();
              $('#basic-datatabless').DataTable().destroy();

              this.batchdata = this.Verifiedfilter;
              $.getScript('./assets/tollfree.js');
            }

          }
          else {
            $('#basic-datatabless').DataTable().clear();
            $('#basic-datatabless').DataTable().destroy();
            this.verified = this.Verifiedfilter;
            this.setStatus(this.verified);
          }
          $.getScript('./assets/tollfree.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }
  downloadCSVFileEMail() {
    this.Emailfilter();
    setTimeout(() => {
      if (this.VerifiedfilterCSV.length > 0) {
        let NewFilteredRes = this.VerifiedfilterCSV.map((item) => {
          const { batch_id, created_at } = item;
          const Batch_ID = batch_id;
          const formattedDate = new Date(created_at).toLocaleDateString('en-US', { timeZone: 'UTC' });
          return { 'Batch Id': Batch_ID, Date: formattedDate };
        });
 
        const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
        const workbook: XLSX.WorkBook = { Sheets: { TollFree: worksheet }, SheetNames: ['TollFree'] };
        const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
        this.saveAsExcelFile1(excelBuffer, 'TollFree');
      } else {
        this.errMessage = 'No Record Available!';
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    }, 2000);
  }

  batchData() {
    this.data.getBatch().subscribe(res => {
      if (res.status == 200) {
        $('#basic-datatabless').dataTable().fnClearTable();
        $('#basic-datatabless').dataTable().fnDraw();
        $('#basic-datatabless').dataTable().fnDestroy();
        this.batchdata = res.data;

        //$.getScript('./assets/tollfree.js');
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }
  /*closed here filter email send*/

  resetfilter() {
    this.submitted = false;
    this.tollFree.reset();
    this.selectedItem = [];
    this.selectedItem1 = []; 
    // this.tollFree.get('statusResponse').setValue('');
    Object.keys(this.tollFree.controls).forEach(key => {
      this.tollFree.get(key).setValue('');
    });
    this.tollFree.patchValue({
      filter_type: this.userType === 1 ? this.currentFilter : ''
    });
    this.Get_VerifiedList()
    this.batchData()
    this.currentFilter = this.currentFilter;
    this.name_with_san = [];
    this.getlistusers();
  }

  /*for download csv files*/
  downloadCSVFile() {
    this.onSubmitfilter();
    setTimeout(() => {
      if (this.VerifiedfilterCSV.length > 0) {
        let NewFilteredRes = this.VerifiedfilterCSV.map((item) => {
          if (this.userType === 1) {
            const { provider, idaccount,username, created_at, status, unique_request_id, reject_date, awaiting_downstream_date, review_date, submission_reject_date, submission_approve_date, batch_id } = item;
            const SAN = 100000000 + idaccount;
            const Customer_Name = `${username}`;
            const Status = status;
            const Request_ID = unique_request_id;
            const reject = new Date(reject_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const awaiting = new Date(awaiting_downstream_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const review = new Date(review_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const submission_reject = new Date(submission_reject_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const submission_approve = new Date(submission_approve_date).toLocaleDateString('en-US', { timeZone: 'UTC' });
            const batch = batch_id ?? 'N/A';
            const providers = provider === 0 ? 'InteliQ' : provider === 1 ? 'Twilio' : provider === 2 ? 'OTT MASH' : 'N/A'
            const formattedDate = new Date(created_at).toLocaleDateString('en-US', { timeZone: 'UTC' });
            if (this.currentFilter == 'Pending Review') {
              return { 'Request ID': Request_ID, 'Customer Name': Customer_Name, SAN, Status, Date: formattedDate };
            }
            if (this.currentFilter == 'Rejected') {
              return { 'Request ID': Request_ID, 'Customer Name': Customer_Name, SAN, Status, Date: formattedDate, 'Updated At': reject };
            }
            if (this.currentFilter == 'Approved') {
              return { 'Request ID': Request_ID, 'Customer Name': Customer_Name, SAN, Status, Date: formattedDate, 'Updated At': awaiting };
            }
            if (this.currentFilter == 'Awaiting Downstream Processing') {
              return { 'Request ID': Request_ID, 'Customer Name': Customer_Name, SAN, Status, Date: formattedDate, 'Updated At': awaiting };
            }
            if (this.currentFilter == 'Verified Sender Review Process Started') {
              return { 'Batch ID': batch, 'Request ID': Request_ID, 'Customer Name': Customer_Name, SAN, Status, 'Provider':providers, Date: formattedDate, 'Updated At': review };
            }
            if (this.currentFilter == 'Verified Sender Submission Rejected') {
              return { 'Batch ID': batch, 'Request ID': Request_ID, 'Customer Name': Customer_Name, SAN, Status, 'Provider':providers, Date: formattedDate, 'Updated At': submission_reject };
            }
            if (this.currentFilter == 'Verified Sender Submission Approved') {
              return { 'Batch ID': batch, 'Request ID': Request_ID, 'Customer Name': Customer_Name, SAN, Status, 'Provider':providers, Date: formattedDate, 'Updated At': submission_approve };
            }
          } else {
            const { created_at, status, business_name, unique_request_id } = item;
            const BusinesName = business_name;
            const Status = status;
            const Request_ID = unique_request_id;
            const formattedDate = new Date(created_at).toLocaleDateString('en-US', { timeZone: 'UTC' });
            return { 'Request ID': Request_ID, 'Business Name': BusinesName, Status, Date: formattedDate };
          }
        });
        const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
        const workbook: XLSX.WorkBook = { Sheets: { TollFree: worksheet }, SheetNames: ['TollFree'] };
        const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
        this.saveAsExcelFile1(excelBuffer, 'TollFree');
      } else {
        this.errMessage = 'No Record Available!';
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    }, 2000);
  }

  private saveAsExcelFile1(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  savedDownloadFile(path: any, batchId: any) {
    if (path) {
      fetch(path).then(resp => resp.arrayBuffer()).then(resp => {
        const file = new Blob([resp], { type: 'text/csv' });
        const fileURL = URL.createObjectURL(file);
        const link = document.createElement('a');
        link.href = fileURL;
        link.download = batchId + '-CSVFile.csv';
        link.click();
      });
    } else {
      this.errMessage = "File Type is Corrupted!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  }

  rejectReview() {
    // this.unique_id = id;
    // const user = this.getVerifyData.find(
    //   (user) => user.unique_request_id === this.unique_id
    // );
    // this.user_id = user.iduser;
    // this.user_acc = user.idaccount;
    // let data = {
    //   iduser: this.user_id,
    //   idaccount: this.user_acc,
    //   id: this.unique_id,
    // };
    this.submitted = true;
    if (this.rejectForm1.invalid) {
      return false;
    }
    const data = {
      idaccount: this.AccountID,
      iduser: this.UserID,
      id: this.ProfileID,
      reject_text: this.rejectForm1.get('reject_text').value,
      sid : this.subacount,
      provider : this.provide
    };
 
    this.data.rejectReview(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.reject1.nativeElement.click();
        this.Get_VerifiedList();
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }
 

  resendEmail(id: any) {
    this.bach_id = id;
    this.data.resendEmail(this.bach_id).subscribe((res) => {
      if ((res.status = 200)) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  openModal(id, user, account) {
    this.unique_id = id;
    this.idaccount1 = account;
    this.iduser1 = user;
    this.submitted = false;
    this.rejectForm.reset();
    const rejectModal = document.getElementById('reject');
    $(rejectModal).modal('show');
  }

  getNumber(id: any,idaccount:any) {
    this.selectAllChecked = false;
    this.ShowMessage = false;
    this.did_status = [];
    this.number = [];
    this.isShow = false;
    this.checkedNumbers = [];
    this.reques_id = id;
    this.data.getAssign_number(idaccount).subscribe((result) => {
      if (result.status === 200) {
        const dataArray = result.data;

        const groupedData = {};

        dataArray.forEach((item) => {
          const requestId = item.requestId;
          const didList = item.did.split(',');

          if (!groupedData[requestId]) {
            groupedData[requestId] = [item];
          } else {
            const existingItem = groupedData[requestId][0];
            existingItem.did += ',' + didList.join(',');
          }
        });

        this.AssignNum = Object.values(groupedData);
        this.AssignNum = [].concat(...this.AssignNum);
      }

      const user = this.AssignNum.find(
        (user) => user.requestId === this.reques_id
      );

      if (user?.did) {
        this.number = this.number || [];
        const numbersArray = user.did.split(',');
        this.number = this.number.concat(numbersArray);

        let payLoad: any = JSON.stringify({
          idaccount: idaccount,
          number:this.number
        })
        this.data.get_status(payLoad).subscribe((result) => {
          if (result.status == 200) {
            this.did_sinch = result.data;
            this.did_status = this.did_sinch.filter(
              (obj, index, self) =>
                index === self.findIndex((o) => o.did === obj.did)
            );
            if (
              this.number.length === 0 ||
              !this.did_status.some((num) => num.sinch_status === '15')
            ) {
              this.ShowMessage = true;
            }
            const Modal = document.getElementById('viewalldata1');
            $(Modal).modal('show');
          }
        });
      } else {
        this.ShowMessage = true;
        const Modal = document.getElementById('viewalldata1');
        $(Modal).modal('show');
      }
    });
  }


  onSubmit() {
    const user = this.getVerifyData.find(
      (user) => user.unique_request_id === this.reques_id
    );
    this.user_id = user.iduser;
    const account = user.idaccount
    let data = {
      iduser: this.user_id,
      number: this.checkedNumbers,
      idaccount: account,
      request_id: this.reques_id,
    };
    this.data.did_change(data).subscribe((result) => {
      if ((result.status = 200)) {
        this.responseMessage = result.message;
        const Modal = document.getElementById('viewalldata1');
        $(Modal).modal('hide');
        this.responseMessage = result.message;
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }


  onRejectt() {
    const user = this.getVerifyData.find(
      (user) => user.unique_request_id === this.reques_id
    );
    this.user_id = user.iduser;
    const account = user.idaccount
    let data = {
      iduser: this.user_id,
      number: this.checkedNumbers,
      idaccount: account,
    };
    this.data.did_reject(data).subscribe((result) => {
      if ((result.status = 200)) {
        this.responseMessage = result.message;
        const Modal = document.getElementById('viewalldata1');
        $(Modal).modal('hide');
        this.responseMessage = result.message;
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  awaiting_getnumber(id: any,idaccount:any) {
    this.ShowMessage = false;
    this.did_status = [];
    this.number = [];
    this.reques_id = id;
    this.data.getAssign_number(idaccount).subscribe((result) => {
      if (result.status === 200) {
        const dataArray = result.data;

        const groupedData = {};

        dataArray.forEach((item) => {
          const requestId = item.requestId;
          const didList = item.did.split(',');

          if (!groupedData[requestId]) {
            groupedData[requestId] = [item];
          } else {
            const existingItem = groupedData[requestId][0];
            existingItem.did += ',' + didList.join(',');
          }
        });

        this.AssignNum = Object.values(groupedData);
        this.AssignNum = [].concat(...this.AssignNum);
      }

      const user = this.AssignNum.find(
        (user) => user.requestId === this.reques_id
      );

      if (user?.did) {
        this.number = this.number || [];
        const numbersArray = user.did.split(',');
        this.number = this.number.concat(numbersArray);

        if (this.number.length === 0) {
          this.ShowMessage = true;
        }

        const Modal = document.getElementById('viewalldata11');
        $(Modal).modal('show');
      } else {
        this.ShowMessage = true;
        const Modal = document.getElementById('viewalldata11');
        $(Modal).modal('show');
      }
    });
  }

  messageshow() {
    const fromDate = this.tollFree.get('from_date').value;
    const toDate = this.tollFree.get('to_date').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.tollFree.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.tollFree.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.tollFree.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.tollFree.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.tollFree.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.tollFree.get('from_date').setErrors(null);
      this.tollFree.get('to_date').setErrors(null);
    }

  }

  verifiedp(idacc: any, idu: any, idpro: any) {
    const data = {
      idaccount: idacc,
      iduser: idu,
      id: idpro,
    };
    this.data.approveSender(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.Get_VerifiedList();
        setTimeout(() => {
          this.responseMessage = '';
        }, 2000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

 getdata(idacc: any, idu: any, idpro: any,subaccount:any,provider:any) {
    this.AccountID = idacc;
    this.UserID = idu;
    this.ProfileID = idpro;
    this.subacount = subaccount;
    this.provide = provider
  }

  rejectedp() {
    this.submitted = true;
    if (this.rejectForm1.invalid) {
      return false;
    }
    const data = {
      idaccount: this.AccountID,
      iduser: this.UserID,
      id: this.ProfileID,
      reject_text: this.rejectForm1.get('reject_text').value,
    };
    this.data.rejectSenderStatus(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.reject.nativeElement.click();
        this.Get_VerifiedList();
        setTimeout(() => {
          this.responseMessage = '';
        }, 2000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  OnReset() {
    this.submitted = false;
    this.rejectForm1.reset();
  }

  ngOnDestroy() {
    this.viewalldata11.nativeElement.click();
    this.viewalldata1.nativeElement.click();
    this.reject.nativeElement.click();
    this.reject1.nativeElement.click();
  }
}
