import { Component, OnInit , EventEmitter, Output, Input, ChangeDetectorRef} from '@angular/core';
import { FormBuilder, FormGroup,Validators } from '@angular/forms';
import { UsermanagementService } from '../usermanagement.service';
import { HttpClient,HttpRequest } from '@angular/common/http';
import { environment } from 'src/environments/environment';
import { saveAs } from 'file-saver';
import { ActivatedRoute } from '@angular/router';

declare var $: any;

@Component({
  selector: 'app-addnote',
  templateUrl: './addnote.component.html',
  styleUrls: ['./addnote.component.css']
})
export class AddnoteComponent implements OnInit {
  @Output() back = new EventEmitter<void>();
  expandedRowIndex: number | null = null;
  showNote: boolean = false;
  index: number = 0;
  public addnote: FormGroup;
  responseMessage: string;
  errMessage: string;
  selectedFile: File[] = [];
  fileData: any;
  FileData: any=[];
  files: any = [];
  selectedFiles: File[] = [];
  previousfiles: any = [];
  lastId: any = [];
  usernotes: any = [];
  submitted: boolean = false;
  key:any;
  receivedMessage: string;
  iduser: any;
  idaccount: any; 
  expandedNotes: boolean[] = [];
  navigationlink:any;
  constructor(private fb: FormBuilder,public userManagementService: UsermanagementService,public _http: HttpClient,private cdRef: ChangeDetectorRef,private route: ActivatedRoute) { }
  
  ngOnInit(): void {
    this.key ='SN' + Math.random().toString(36).slice(2);
    this.addnote = this.fb.group({
      note:['',[Validators.required,Validators.pattern(/^\s*\S.*$/m),Validators.maxLength(1024)]],
      file:['']
    })

    this.navigationlink=sessionStorage.getItem('navigation');

    this.route.params.subscribe(params => {
      this.idaccount = params['idaccount'];;
      this.iduser = params['iduser'];
    });
    
    this.geUsernotes()
  }
  getUploadedFile(): void {
    this.userManagementService.GetUploadFile(this.key).subscribe({
      next: (res: any) => {
        if (res.status === 200) {
          this.FileData.push(res.data);
          this.receivedMessage = res.message;
        } else {
          this.errMessage = res.message;
        }
      },
      error: (err: any) => {
        this.errMessage = "An error occurred while fetching the file list.";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
 
geUsernotes() {
  this.userManagementService.getattached(this.iduser).subscribe({
    next: (res: any) => {
      if (res.status === 200) {
        $('#basic-datatables').dataTable().fnDraw();
        $('#basic-datatables').dataTable().fnDestroy();
        $.getScript('./assets/tollfree.js');
        this.selectedFiles = res.data;   
        this.receivedMessage=res.message
        setTimeout(() => {
          this.receivedMessage = "";
        }, 5000);
        this.cdRef.detectChanges();
      } else {
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    },
    error: (err: any) => {
      console.error('Error retrieving attached files:', err);
    }
  });
}

submitNotes() {
  const noteDescription = this.addnote.get('note')?.value;
  if (!noteDescription || noteDescription.trim() === '') {
    return;
  }
  const data = {
    key: this.key,
    idaccount: this.idaccount,
    iduser: this.iduser,
    note: noteDescription,
    lastId: JSON.stringify(this.lastId)
  };
  this.userManagementService.updatenotes(data).subscribe({
    next: (res) => {
      if (res.status === 200) {
        this.geUsernotes()
        this.responseMessage = res.message;
        this.addnote.reset();
        this.lastId = [];
        this.FileData = [];
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      } else {
        this.errMessage = res.message || "Failed to save note.";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    },
    error: (err) => {
      this.errMessage = "An error occurred while saving the note.";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  });
}

downloadFile(filepath: string, filename: string): void {
  this._http.get(filepath, { responseType: 'blob' }).subscribe((data: Blob) => {
    saveAs(data, filename);
  }, error => {
    console.error("File download failed", error);
  });
}

uploadFile(event: Event) {
  if(this.lastId.length==5){
  this.errMessage="Only 5 files are allowed at a time."
   setTimeout(() => {
     this.errMessage = "";
   }, 5000);
   return; 
  } else{
   const inputElement = event.target as HTMLInputElement;
   if (inputElement.files && inputElement.files.length > 0) {
     const file: File = inputElement.files[0];
     const allowedExtensions = ['pdf', 'jpg', 'png', 'mp3', 'mp4', 'csv'];
     const fileExtension = file.name.split('.').pop()?.toLowerCase();
     if (!allowedExtensions.includes(fileExtension!)) {
       this.errMessage = "Invalid file type. Allowed types: .pdf, .jpg, .png, .mp3, .mp4, .csv";
       setTimeout(() => {
         this.errMessage = "";
       }, 5000);
       return;
     }
     const fileSize = file.size;
     const maxSizePerFile = 5*1024*1024; 
     if (fileSize > maxSizePerFile) {
       this.errMessage = "Individual file size limit exceeded";
       setTimeout(() => {
         this.errMessage = "";
       }, 5000);
       return;
     }
     const reader = new FileReader();
     reader.readAsDataURL(file);
     const target = environment.SERVER + "saveusernotefile"; 
     const formData = new FormData();
     var _http = this._http;
     formData.append('UNKEY', this.key);
     formData.append("ATTACHMENTS", file, file.name);
 
     const req = new HttpRequest('POST', target, formData, {
       reportProgress: true
     });
     _http.request(req).subscribe(
       (res: any) => {
         if (res.body) {
           if (res.body.status == 200) {
             this.lastId.push(res.body.lastId);
             this.selectedFile.push(res.body.data[0]);
             this.responseMessage = res.body.message;
             this.getUploadedFile();
             inputElement.value = '';
             this.cdRef.detectChanges();  
           } else {
             this.errMessage = res.body.message;
           }
           setTimeout(() => {
             this.responseMessage = "";
             this.errMessage = "";
           }, 5000);
         }
       },
       (error: any) => {
         this.errMessage = "An error occurred while uploading the file.";
         setTimeout(() => {
           this.errMessage = "";
         }, 5000);
       }
     );
   } else {
     this.errMessage = "No file selected.";
     setTimeout(() => {
       this.errMessage = "";
     }, 5000);
   }
  }
 }

deleteFile(id: string) {
  this.userManagementService.deleteusernotesfile(id).subscribe((res: any) => {
    if (res.status == 201) {
      this.responseMessage = res.message;
      const fileIndex = this.FileData.findIndex(file => file.id_una === id);
      if (fileIndex !== -1) {
        this.FileData.splice(fileIndex, 1);
      }
      const lastIdIndex = this.lastId.indexOf(id);  
      if (lastIdIndex !== -1) {
        this.lastId.splice(lastIdIndex, 1); 
      }
      // this.getUploadedFile()
      setTimeout(() => {
        this.responseMessage = '';
      }, 3000);
    } else {
      this.errMessage = res.message;
      setTimeout(() => {
        this.errMessage = '';
      }, 3000);
    }
  });
}


    toggleNote(): void {
		  this.showNote = !this.showNote; 
	  }

	  toggleRowHeight(index: number): void {
		  this.expandedRowIndex = this.expandedRowIndex === index ? null : index;
	  }

    toggleDescription(note: any) {
      note.moreShown = !note.moreShown;
    }

    closeAddNote(): void {
      this.back.emit();
    }

    reset() {
      this.FileData = [];
      this.selectedFile = [];
      this.addnote.reset();      
      this.lastId = [];
    }
}
