import { Component, Input, OnInit } from '@angular/core';
import { UsermanagementService } from '../usermanagement.service';
import { Router } from '@angular/router';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { FormBuilder, FormGroup } from '@angular/forms';
declare var $: any;
@Component({
  selector: 'app-failed-billing',
  templateUrl: './failed-billing.component.html',
  styleUrls: ['./failed-billing.component.css']
})
export class FailedBillingComponent implements OnInit {
  @Input() customerdropdownlist: any;
  errMessage: any;
  responseMessage: any;
  showFilter: boolean = false;
  dropdownSetting: IDropdownSettings = {};
  closeDropdownSelection = true;
  failedBillingData: any[] = [];
  filteredData = [];
  filterForm: FormGroup;
  userlist: any;
  selectedItem: any = [];
  name_with_san: any = [];

  constructor(public data: UsermanagementService, public router: Router, private fb: FormBuilder) {
  }

  ngOnInit(): void {
    this.dropdownSetting = {
			singleSelection: true,
			idField: 'userdata', // idaccount 
			textField: 'reloaduserlist', // SAN with Name
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

    this.filterForm = this.fb.group({
      idaccount: [''],
      // current_month_failure: [''],
      // last_month_failure: [''],
      // last_to_last_month_failure: [''],
      // current_balance: [''],
      to_date: [''],
      from_date: [''],
    });

    this.getFailedBillingData();
    this.getlistusers();
  }
  messageshow() {
    const from_date = this.filterForm.get('from_date').value;
    const to_date = this.filterForm.get('to_date').value;
    const currentDate = new Date();
    if ((!from_date && !to_date)) {
    } else if ((from_date == null || !from_date) && (to_date != null)) {
      this.filterForm.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((from_date != null) && (to_date == null || !to_date)) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (to_date && new Date(to_date) > currentDate) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (from_date && new Date(from_date) > currentDate) {
      this.filterForm.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterForm.get('from_date').setErrors(null);
      this.filterForm.get('to_date').setErrors(null);
    }
  }
 
  getlistusers() {
		if(this.customerdropdownlist && this.customerdropdownlist.length){
      
		}else{
			console.error('User list is empty or undefined');
		} 
	}

  showfilter(): void {
    this.showFilter = !this.showFilter;
  }

  getFailedBillingData(): void {
    this.getFailedBilling('');
  }

  applyFilterFailed(): void {
   
    // if (!this.filterForm.value.idaccount) {
    //   this.errMessage = "Please Select Customer Name!";
    //   setTimeout(() => {
    //     this.errMessage = "";
    //   }, 3000);
    //   return;
    // }
     this.filterForm.value.idaccount = this.selectedItem?.[0]?.userdata || '';
  //  console.log(this.filterForm.value, "dysdfgashdfasgh");
    this.getFailedBilling(JSON.stringify(this.filterForm.value));
  }
  // getFailedBilling(userdata){
  //   console.log("userdata", userdata);
  //   this.data.billingService(userdata).subscribe(
  //     (res) => {
  //       if (res.status == 200) {
  //         this.updateTable('#basic-datatablesallcnp');
  //         this.failedBillingData = res.data;
  //         this.filteredData = [...this.failedBillingData];
  //       } else {
  //         this.showMessage('errMessage', res.message);
  //       }
  //       $.getScript('./assets/table.js');
  //     },
  //     (err) => console.error('Error fetching failed billing data:', err.message)
  //   );
  // }
  getFailedBilling(userdata){
    console.log("userdata", userdata);
    if(this.filterForm.invalid){
      return false
    }else{
   
    this.data.billingService(userdata).subscribe(
      (res) => {
        if (res.status == 200) {
          this.updateTable('#basic-datatablesallcnp');
          this.failedBillingData = res.data;
          this.filteredData = [...this.failedBillingData];
        } else {
          this.showMessage('errMessage', res.message);
        }
        $.getScript('./assets/table.js');
      },
      (err) => console.error('Error fetching failed billing data:', err.message)
    );      
 
    }
 
  }
 

  clearFilter(): void {
    this.filterForm.reset();
    Object.keys(this.filterForm.controls).forEach(key => {
      this.filterForm.get(key).setValue('');
    })
    this.router.navigate(['/user/user-details']);
    this.getFailedBillingData();
  }

  exportFailedBilling(): void {
    if (!this.filteredData.length) {
      console.error('No data available to export.');
      this.errMessage = "No Record Found!";
      setTimeout(() => {
        this.errMessage = "";
      }, 3000);
      return;
    }

    const csvData = this.convertToCSV(this.filteredData);
    const blob = new Blob([csvData], { type: 'text/csv' });
    const url = window.URL.createObjectURL(blob);
    const a = document.createElement('a');

    a.style.display = 'none';
    document.body.appendChild(a);
    a.href = url;
    a.download = 'filtered_failed_billing_data.csv';
    a.click();

    window.URL.revokeObjectURL(url);
    a.remove();
  }

  convertToCSV(data: any[]): string {
    if (!data.length) return '';

    const headers = [
      "San",
      "Customer Name",
      "Current Balance",
      "Current Month Failed",
      "Last Month Failed",
      "Last 2 Month Failed",
      "Date"
    ];
    
    const filteredData = data.map(({ iduser, idaccount, ...rest }) => ({
      san:rest.san,
      customer_name: rest.customer_name,
      current_balance: rest.current_balance,
      current_month_failed: rest.current_month_failure,
      last_month_failed: rest.last_month_failure,
      last_2_month_failed: rest.last_to_last_month_failure,
      Date:new Date(rest.created_at).toLocaleDateString('en-US')
    }));

    
    const values = filteredData.map(row =>  
      Object.values(row).map(value => `"${value}"`).join(',')
    );

    return [headers.join(','), ...values].join('\n');
  }
  
  private updateTable(selector: string): void {
    $(selector).dataTable().fnClearTable();
    $(selector).dataTable().fnDraw();
    $(selector).dataTable().fnDestroy();
    $.getScript('./assets/table.js');
  }

  private showMessage(type: 'responseMessage' | 'errMessage', message: string): void {
    this[type] = message;
    setTimeout(() => (this[type] = ''), 5000);
  }


}
