import { Component, Input, OnInit } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { UsermanagementService } from '../usermanagement.service';
import { AuthenticationService } from 'src/app/authentication/authentication.service';
import { Router } from '@angular/router';

declare var $: any;
@Component({
	selector: 'app-multiuser-list',
	templateUrl: './multiuser-list.component.html',
	styleUrls: ['./multiuser-list.component.css']
})
export class MultiuserListComponent implements OnInit {
	@Input() userList: any;
	showFilter: boolean = false;
	filterUser: FormGroup;
	dropdownSettingtype: IDropdownSettings = {};
	dropdownSetting: IDropdownSettings = {};
	// closeDropdownSelection1 = true;
	userlist: any;
	errMessage: any;
	responseMessage: any;
	multiuserlist: any[] = [];
	selectedUser: any;
	dropdownSettings: IDropdownSettings = {};
	closeDropdownSelection = true;
	selectedItem: any = [];
	name_with_san: any = [];
	userss: any = [];
	listuser: any = [];
	users: any = [];
	userTypes: any = [];
	afilter: any = [];
	newdata: any = [];
	public submitted: boolean = false;
	selectedItem1: any = [];
	selectedItem2: any = [];

	constructor(public fb: FormBuilder, public data: UsermanagementService, private authService: AuthenticationService, public router: Router) { }

	ngOnInit(): void {

		this.filterUser = this.fb.group({
			to_date: [''],
			from_date: [''],
			customername: [''],
			additionaluser: [''],
			email: [''],
			// contact:[''],
			usertype: ['']
		});

		this.dropdownSetting = {
			singleSelection: true,
			idField: 'iduser',
			textField: 'name',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};
		this.dropdownSettingtype = {
			singleSelection: true,
			idField: 'user_type',
			textField: 'user_type_name',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSettings = {
			singleSelection: true,
			idField: 'idaccount',
			textField: 'Name_san',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.GetmultiUsers();
		$('#basic-datatablesmultiuser').dataTable().fnClearTable();
		$('#basic-datatablesmultiuser').dataTable().fnDraw();
		$('#basic-datatablesmultiuser').dataTable().fnDestroy();
		$.getScript('./assets/tollfree.js');

		this.getlistusers();

		this.data.getUserType().subscribe((res) => {
			this.userTypes = res.data;
		})

	}

	getlistusers() {
		if(this.userList && this.userList.length){
			this.users = this.userList.filter(item => item.is_deleted == 0);
			this.users.sort((a, b) => {
			return a.idaccount - b.idaccount;
			});
			this.users.forEach(element => {
			const fullName = `${element.first_name} ${element.last_name}`;
			this.name_with_san.push({ idaccount: element.idaccount, Name_san: fullName + '-' + element.san });
			});
			this.userss = this.name_with_san;
		}else{
			console.error('User list is empty or undefined');
		} 
	}

	onItemSelect(item: any) {
		console.log(item);
	}

	GetmultiUsers() {
		this.data.getMultiUser().subscribe(res => {
			if (res.status == 200) {
				this.multiuserlist = res.data;
				this.listuser = res.data
				this.listuser.forEach(element => {
					const fullname = `${element.user_firstname} ${element.user_lastname}`
					this.afilter.push({ iduser: element.iduser, name: fullname })
				});
				this.newdata = this.afilter
				// this.responseMessage = res.message;
				$('#basic-datatablesmultiuser').dataTable().fnClearTable();
				$('#basic-datatablesmultiuser').dataTable().fnDraw();
				$('#basic-datatablesmultiuser').dataTable().fnDestroy();
				$.getScript('./assets/tollfree.js')
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			} else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = "Connection loss while getting multiuser list";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		})
	}

	resetPassword(email: any, username: any) {
		let data = JSON.stringify({
			email: email,
			username: username
		})
		this.authService.sendMailForgot(data).subscribe(res => {
			if (res.status == 201) {
				this.responseMessage = "Link sent to the registered email address!";
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			} else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = "Connection loss while sent reset password mail";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	deleteUser(iduser, idaccount) {
		let sdata = { "iduser": iduser, "idaccount": idaccount }
		if (confirm("Are you sure you want delete data!")) {
			this.data.deleteUser(JSON.stringify(sdata)).subscribe(result => {
				this.responseMessage = result.message;
				setTimeout(() => {
					this.responseMessage = "";
					this.GetmultiUsers();
				}, 5000);
				this.ngOnInit();
			})
		} else {
			"Cancel!";
		}
	}

	showfilter() {
		if (this.showFilter == false) {
			this.showFilter = true;
		}
		else {
			this.showFilter = false;
		}
	}
	
	applyFilter() {
		this.submitted = true;
		if (this.filterUser.invalid) {
			return
		} else {
			this.filterUser.value.usertype = this.selectedItem2?.[0]?.user_type|| '';
			this.filterUser.value.additionaluser = this.selectedItem1?.[0]?.iduser|| '';
			this.filterUser.value.customername = this.selectedItem?.[0]?.idaccount|| '';
				this.data.multiuserfilter(JSON.stringify(this.filterUser.value)).subscribe((res) => {
					if (res.status == 200) {
						this.multiuserlist = res.data;
						$('#basic-datatablesmultiuser').dataTable().fnClearTable();
						$('#basic-datatablesmultiuser').dataTable().fnDraw();
						$('#basic-datatablesmultiuser').dataTable().fnDestroy();
						$.getScript('./assets/tollfree.js');
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					}
					else {
						this.errMessage = res.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});
		}
	}

	resetFilter() {
		this.submitted = false;
		this.filterUser.reset();
		Object.keys(this.filterUser.controls).forEach(key=>{
			this.filterUser.get(key).setValue('');
		  })
		this.GetmultiUsers();
		this.getlistusers();
	}

	messageshow() {
		const from_date = this.filterUser.get('from_date').value;
		const to_date = this.filterUser.get('to_date').value;
		const currentDate = new Date();
		if ((!from_date && !to_date)) {
		} else if ((from_date == null || !from_date) && (to_date != null)) {
			this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((from_date != null) && (to_date == null || !to_date)) {
			this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
			this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
			return;
		} else if (to_date && new Date(to_date) > currentDate) {
			this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
			return;
		} else if (from_date && new Date(from_date) > currentDate) {
			this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
			return;
		} else {
			this.filterUser.get('from_date').setErrors(null);
			this.filterUser.get('to_date').setErrors(null);
		}
	}

	loginUser(data: any) {
		let userLogin = { username: data.username, typeCheck: 'admin_checking', sessionType: "MORPHING"};
		this.data.userMorphingLogin(userLogin).subscribe(res => {
			if (res.authkey) {
				let userData = res;
				this.router.navigate([], { state: { userData: userData } }).then(result => {
					window.open(window.location.origin + '/#/userlogin/' + userData.authkey);
				});
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

}
